/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.managed.TransactionContext;
import org.apache.commons.dbcp.managed.TransactionContextListener;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.commons.pool.ObjectPool;

public class ManagedConnection
extends DelegatingConnection {
    private final ObjectPool pool;
    private final TransactionRegistry transactionRegistry;
    private final boolean accessToUnderlyingConnectionAllowed;
    private TransactionContext transactionContext;
    private boolean isSharedConnection;

    public ManagedConnection(ObjectPool pool, TransactionRegistry transactionRegistry, boolean accessToUnderlyingConnectionAllowed) throws SQLException {
        super((Connection)null);
        this.pool = pool;
        this.transactionRegistry = transactionRegistry;
        this.accessToUnderlyingConnectionAllowed = accessToUnderlyingConnectionAllowed;
        this.updateTransactionStatus();
    }

    protected void checkOpen() throws SQLException {
        super.checkOpen();
        this.updateTransactionStatus();
    }

    private void updateTransactionStatus() throws SQLException {
        if (this.transactionContext != null) {
            if (this.transactionContext.isActive()) {
                if (this.transactionContext != this.transactionRegistry.getActiveTransactionContext()) {
                    throw new SQLException("Connection can not be used while enlisted in another transaction");
                }
                return;
            }
            this.transactionComplete();
        }
        this.transactionContext = this.transactionRegistry.getActiveTransactionContext();
        if (this.transactionContext != null && this.transactionContext.getSharedConnection() != null) {
            Connection connection = this.getDelegateInternal();
            this.setDelegate(null);
            if (connection != null) {
                try {
                    this.pool.returnObject(connection);
                }
                catch (Exception ignored) {
                    try {
                        this.pool.invalidateObject(connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.transactionContext.addTransactionContextListener(new CompletionListener());
            this.setDelegate(this.transactionContext.getSharedConnection());
            this.isSharedConnection = true;
        } else {
            if (this.getDelegateInternal() == null) {
                try {
                    Connection connection = (Connection)this.pool.borrowObject();
                    this.setDelegate(connection);
                }
                catch (Exception e) {
                    throw (SQLException)new SQLException("Unable to acquire a new connection from the pool").initCause(e);
                }
            }
            if (this.transactionContext != null) {
                this.transactionContext.addTransactionContextListener(new CompletionListener());
                try {
                    this.transactionContext.setSharedConnection(this.getDelegateInternal());
                }
                catch (SQLException e) {
                    this.transactionContext = null;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (!this._closed) {
            try {
                if (this.transactionContext == null) {
                    this.getDelegateInternal().close();
                }
            }
            finally {
                this._closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transactionComplete() {
        this.transactionContext = null;
        if (this.isSharedConnection) {
            this.setDelegate(null);
            this.isSharedConnection = false;
        }
        Connection delegate = this.getDelegateInternal();
        if (this._closed && delegate != null) {
            try {
                this.setDelegate(null);
                if (!delegate.isClosed()) {
                    delegate.close();
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                this._closed = true;
            }
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Auto-commit can not be set while enrolled in a transaction");
        }
        super.setAutoCommit(autoCommit);
    }

    public void commit() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.commit();
    }

    public void rollback() throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Commit can not be set while enrolled in a transaction");
        }
        super.rollback();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.transactionContext != null) {
            throw new SQLException("Read-only can not be set while enrolled in a transaction");
        }
        super.setReadOnly(readOnly);
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public Connection getDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return this.getDelegateInternal();
        }
        return null;
    }

    protected Connection getDelegateInternal() {
        return super.getDelegate();
    }

    public Connection getInnermostDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return super.getInnermostDelegate();
        }
        return null;
    }

    protected class CompletionListener
    implements TransactionContextListener {
        protected CompletionListener() {
        }

        public void afterCompletion(TransactionContext transactionContext, boolean commited) {
            if (transactionContext == transactionContext) {
                ManagedConnection.this.transactionComplete();
            }
        }
    }
}

