/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

class DatatypeConverterHelper
implements DatatypeConverterInterface {
    private final DatatypeConverterInterface delegate;

    DatatypeConverterHelper(DatatypeConverterInterface delegate) {
        this.delegate = delegate;
    }

    public String parseAnySimpleType(String lexicalXSDAnySimpleType) {
        return this.delegate.parseAnySimpleType(lexicalXSDAnySimpleType);
    }

    public byte[] parseBase64Binary(String lexicalXSDBase64Binary) {
        return this.delegate.parseBase64Binary(lexicalXSDBase64Binary);
    }

    public boolean parseBoolean(String lexicalXSDBoolean) {
        return this.delegate.parseBoolean(lexicalXSDBoolean);
    }

    public byte parseByte(String lexicalXSDByte) {
        return this.delegate.parseByte(lexicalXSDByte);
    }

    public Calendar parseDate(String lexicalXSDDate) {
        return this.delegate.parseDate(lexicalXSDDate);
    }

    public Calendar parseDateTime(String lexicalXSDDateTime) {
        return this.delegate.parseDateTime(lexicalXSDDateTime);
    }

    public BigDecimal parseDecimal(String lexicalXSDDecimal) {
        return this.delegate.parseDecimal(lexicalXSDDecimal);
    }

    public double parseDouble(String lexicalXSDDouble) {
        return this.delegate.parseDouble(lexicalXSDDouble);
    }

    public float parseFloat(String lexicalXSDFloat) {
        return this.delegate.parseFloat(lexicalXSDFloat);
    }

    public byte[] parseHexBinary(String lexicalXSDHexBinary) {
        return this.delegate.parseHexBinary(lexicalXSDHexBinary);
    }

    public int parseInt(String lexicalXSDInt) {
        return this.delegate.parseInt(lexicalXSDInt);
    }

    public BigInteger parseInteger(String lexicalXSDInteger) {
        return this.delegate.parseInteger(lexicalXSDInteger);
    }

    public long parseLong(String lexicalXSDLong) {
        return this.delegate.parseLong(lexicalXSDLong);
    }

    public QName parseQName(String lexicalXSDQName, NamespaceContext nsc) {
        return this.delegate.parseQName(lexicalXSDQName, nsc);
    }

    public short parseShort(String lexicalXSDShort) {
        return this.delegate.parseShort(lexicalXSDShort);
    }

    public String parseString(String lexicalXSDString) {
        return this.delegate.parseString(lexicalXSDString);
    }

    public Calendar parseTime(String lexicalXSDTime) {
        return this.delegate.parseTime(lexicalXSDTime);
    }

    public long parseUnsignedInt(String lexicalXSDUnsignedInt) {
        return this.delegate.parseUnsignedInt(lexicalXSDUnsignedInt);
    }

    public int parseUnsignedShort(String lexicalXSDUnsignedShort) {
        return this.delegate.parseUnsignedShort(lexicalXSDUnsignedShort);
    }

    public String printAnySimpleType(String val) {
        return this.delegate.printAnySimpleType(val);
    }

    public String printBase64Binary(byte[] val) {
        return this.delegate.printBase64Binary(val);
    }

    public String printBoolean(boolean val) {
        return this.delegate.printBoolean(val);
    }

    public String printByte(byte val) {
        return this.delegate.printByte(val);
    }

    public String printDate(Calendar cal) {
        StringBuilder buf = new StringBuilder();
        int year = cal.get(1);
        if (year < 0) {
            buf.append("-");
            year = -year;
        }
        DatatypeConverterHelper.append(buf, year, 4);
        buf.append('-');
        DatatypeConverterHelper.append(buf, cal.get(2) + 1, 2);
        buf.append('-');
        DatatypeConverterHelper.append(buf, cal.get(5), 2);
        TimeZone tz = cal.getTimeZone();
        if (tz != null) {
            int offset = cal.get(15);
            if (tz.inDaylightTime(cal.getTime())) {
                offset += cal.get(16);
            }
            if (offset == 0) {
                buf.append('Z');
            } else {
                if (offset < 0) {
                    buf.append('-');
                    offset = -offset;
                } else {
                    buf.append('+');
                }
                DatatypeConverterHelper.append(buf, (offset /= 60000) / 60, 2);
                buf.append(':');
                DatatypeConverterHelper.append(buf, offset % 60, 2);
            }
        }
        return buf.toString();
    }

    private static void append(StringBuilder buf, int value, int minLength) {
        String str = String.valueOf(value);
        for (int i = str.length(); i < minLength; ++i) {
            buf.append('0');
        }
        buf.append(str);
    }

    public String printDateTime(Calendar val) {
        return this.delegate.printDateTime(val);
    }

    public String printDecimal(BigDecimal val) {
        return this.delegate.printDecimal(val);
    }

    public String printDouble(double val) {
        return this.delegate.printDouble(val);
    }

    public String printFloat(float val) {
        return this.delegate.printFloat(val);
    }

    public String printHexBinary(byte[] val) {
        return this.delegate.printHexBinary(val);
    }

    public String printInt(int val) {
        return this.delegate.printInt(val);
    }

    public String printInteger(BigInteger val) {
        return this.delegate.printInteger(val);
    }

    public String printLong(long val) {
        return this.delegate.printLong(val);
    }

    public String printQName(QName val, NamespaceContext nsc) {
        return this.delegate.printQName(val, nsc);
    }

    public String printShort(short val) {
        return this.delegate.printShort(val);
    }

    public String printString(String val) {
        return this.delegate.printString(val);
    }

    public String printTime(Calendar val) {
        return this.delegate.printTime(val);
    }

    public String printUnsignedInt(long val) {
        return this.delegate.printUnsignedInt(val);
    }

    public String printUnsignedShort(int val) {
        return this.delegate.printUnsignedShort(val);
    }
}

