/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.DefaultJAXRPC11TypeMappingImpl;
import org.apache.axis.encoding.DefaultSOAPEncodingTypeMappingImpl;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingImpl;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.ArrayDeserializerFactory;
import org.apache.axis.encoding.ser.ArraySerializerFactory;
import org.apache.axis.encoding.ser.BaseDeserializerFactory;
import org.apache.axis.encoding.ser.BaseSerializerFactory;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.EnumDeserializerFactory;
import org.apache.axis.encoding.ser.EnumSerializerFactory;
import org.apache.axis.encoding.ser.SimpleListDeserializerFactory;
import org.apache.axis.encoding.ser.SimpleListSerializerFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.axis.ReadOnlyServiceDesc;
import org.apache.openejb.server.axis.assembler.BindingStyle;
import org.apache.openejb.server.axis.assembler.JaxRpcFaultInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcOperationInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcParameterInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcServiceInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcTypeInfo;

public class JavaServiceDescBuilder {
    private static final TypeMappingImpl SOAP_TYPE_MAPPING = DefaultSOAPEncodingTypeMappingImpl.getSingleton();
    private static final TypeMappingImpl JAXRPC_TYPE_MAPPING = DefaultJAXRPC11TypeMappingImpl.getSingleton();
    private final JaxRpcServiceInfo serviceInfo;
    private final ClassLoader classLoader;

    public JavaServiceDescBuilder(JaxRpcServiceInfo serviceInfo, ClassLoader classLoader) {
        this.serviceInfo = serviceInfo;
        this.classLoader = classLoader;
    }

    public JavaServiceDesc createServiceDesc() throws OpenEJBException {
        Class<?> serviceEndpointInterface;
        try {
            serviceEndpointInterface = this.classLoader.loadClass(this.serviceInfo.serviceEndpointInterface);
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Unable to load the service endpoint interface " + this.serviceInfo.serviceEndpointInterface, (Throwable)e);
        }
        JavaServiceDesc serviceDesc = new JavaServiceDesc();
        serviceDesc.setName(this.serviceInfo.name);
        serviceDesc.setEndpointURL(this.serviceInfo.endpointURL);
        serviceDesc.setWSDLFile(this.serviceInfo.wsdlFile);
        BindingStyle bindingStyle = this.serviceInfo.defaultBindingStyle;
        switch (bindingStyle) {
            case RPC_ENCODED: {
                serviceDesc.setStyle(Style.RPC);
                serviceDesc.setUse(Use.ENCODED);
                break;
            }
            case RPC_LITERAL: {
                serviceDesc.setStyle(Style.RPC);
                serviceDesc.setUse(Use.LITERAL);
                break;
            }
            case DOCUMENT_ENCODED: {
                serviceDesc.setStyle(Style.DOCUMENT);
                serviceDesc.setUse(Use.ENCODED);
                break;
            }
            case DOCUMENT_LITERAL: {
                serviceDesc.setStyle(Style.DOCUMENT);
                serviceDesc.setUse(Use.LITERAL);
                break;
            }
            case DOCUMENT_LITERAL_WRAPPED: {
                serviceDesc.setStyle(Style.WRAPPED);
                serviceDesc.setUse(Use.LITERAL);
            }
        }
        for (JaxRpcOperationInfo operationInfo : this.serviceInfo.operations) {
            OperationDesc operationDesc = this.buildOperationDesc(operationInfo, serviceEndpointInterface);
            serviceDesc.addOperationDesc(operationDesc);
        }
        TypeMappingRegistryImpl typeMappingRegistry = new TypeMappingRegistryImpl();
        typeMappingRegistry.doRegisterFromVersion("1.3");
        serviceDesc.setTypeMappingRegistry((TypeMappingRegistry)typeMappingRegistry);
        TypeMapping typeMapping = typeMappingRegistry.getOrMakeTypeMapping(serviceDesc.getUse().getEncoding());
        serviceDesc.setTypeMapping(typeMapping);
        for (JaxRpcTypeInfo type : this.serviceInfo.types) {
            this.registerType(type, typeMapping);
        }
        return new ReadOnlyServiceDesc(serviceDesc);
    }

    private OperationDesc buildOperationDesc(JaxRpcOperationInfo operationInfo, Class serviceEndpointInterface) throws OpenEJBException {
        OperationDesc operationDesc = new OperationDesc();
        operationDesc.setName(operationInfo.name);
        switch (operationInfo.bindingStyle) {
            case RPC_ENCODED: {
                operationDesc.setStyle(Style.RPC);
                operationDesc.setUse(Use.ENCODED);
                break;
            }
            case RPC_LITERAL: {
                operationDesc.setStyle(Style.RPC);
                operationDesc.setUse(Use.LITERAL);
                break;
            }
            case DOCUMENT_ENCODED: {
                operationDesc.setStyle(Style.DOCUMENT);
                operationDesc.setUse(Use.ENCODED);
                break;
            }
            case DOCUMENT_LITERAL: {
                operationDesc.setStyle(Style.DOCUMENT);
                operationDesc.setUse(Use.LITERAL);
                break;
            }
            case DOCUMENT_LITERAL_WRAPPED: {
                operationDesc.setStyle(Style.WRAPPED);
                operationDesc.setUse(Use.LITERAL);
            }
        }
        switch (operationInfo.operationStyle) {
            case NOTIFICATION: {
                operationDesc.setMep(OperationType.NOTIFICATION);
                break;
            }
            case ONE_WAY: {
                operationDesc.setMep(OperationType.ONE_WAY);
                break;
            }
            case REQUEST_RESPONSE: {
                operationDesc.setMep(OperationType.REQUEST_RESPONSE);
                break;
            }
            case SOLICIT_RESPONSE: {
                operationDesc.setMep(OperationType.SOLICIT_RESPONSE);
            }
        }
        Class[] paramTypes = new Class[operationInfo.parameters.size()];
        int i = 0;
        for (JaxRpcParameterInfo parameterInfo : operationInfo.parameters) {
            ParameterDesc parameterDesc = this.buildParameterDesc(parameterInfo);
            operationDesc.addParameter(parameterDesc);
            paramTypes[i++] = parameterDesc.getJavaType();
        }
        try {
            Method method = serviceEndpointInterface.getMethod(operationInfo.javaMethodName, paramTypes);
            operationDesc.setMethod(method);
        }
        catch (NoSuchMethodException e) {
            String args = "";
            for (Class paramType : paramTypes) {
                if (args.length() > 0) {
                    args = args + ", ";
                }
                args = args + paramType.getName();
            }
            throw new OpenEJBException("Mapping references non-existent method in service-endpoint: " + operationInfo.javaMethodName + "(" + args + ")");
        }
        if (operationInfo.returnQName != null) {
            operationDesc.setReturnQName(operationInfo.returnQName);
            operationDesc.setReturnType(operationInfo.returnXmlType);
            try {
                Class<?> returnClass = this.classLoader.loadClass(operationInfo.returnJavaType);
                operationDesc.setReturnClass(returnClass);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException();
            }
        } else if (operationInfo.operationStyle == JaxRpcOperationInfo.OperationStyle.REQUEST_RESPONSE) {
            operationDesc.setReturnQName(null);
            operationDesc.setReturnType(XMLType.AXIS_VOID);
            operationDesc.setReturnClass(Void.TYPE);
        }
        for (JaxRpcFaultInfo faultInfo : operationInfo.faults) {
            FaultDesc faultDesc = this.buildFaultDesc(faultInfo);
            operationDesc.addFault(faultDesc);
        }
        return operationDesc;
    }

    private ParameterDesc buildParameterDesc(JaxRpcParameterInfo parameterInfo) throws OpenEJBException {
        Class<?> javaType;
        byte mode = ParameterDesc.modeFromString((String)parameterInfo.mode.toString());
        boolean inHeader = parameterInfo.soapHeader && parameterInfo.mode.isIn();
        boolean outHeader = parameterInfo.soapHeader && parameterInfo.mode.isOut();
        try {
            javaType = this.classLoader.loadClass(parameterInfo.javaType);
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Unable to load parameter type " + parameterInfo.javaType);
        }
        ParameterDesc parameterDesc = new ParameterDesc(parameterInfo.qname, mode, parameterInfo.xmlType, javaType, inHeader, outHeader);
        return parameterDesc;
    }

    private FaultDesc buildFaultDesc(JaxRpcFaultInfo faultInfo) throws OpenEJBException {
        FaultDesc faultDesc = new FaultDesc(faultInfo.qname, faultInfo.javaType, faultInfo.xmlType, faultInfo.complex);
        ArrayList<ParameterDesc> parameters = new ArrayList<ParameterDesc>();
        for (JaxRpcParameterInfo parameterInfo : faultInfo.parameters) {
            ParameterDesc parameterDesc = this.buildParameterDesc(parameterInfo);
            parameters.add(parameterDesc);
        }
        faultDesc.setParameters(parameters);
        return faultDesc;
    }

    private void registerType(JaxRpcTypeInfo type, TypeMapping typeMapping) throws OpenEJBException {
        Class<?> javaType;
        try {
            javaType = this.classLoader.loadClass(type.javaType);
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Could not load class for JaxRpc mapping " + type.javaType);
        }
        Class serializerFactoryClass = BeanSerializerFactory.class;
        Class deserializerFactoryClass = BeanDeserializerFactory.class;
        switch (type.serializerType) {
            case ARRAY: {
                serializerFactoryClass = ArraySerializerFactory.class;
                deserializerFactoryClass = ArrayDeserializerFactory.class;
                break;
            }
            case ENUM: {
                serializerFactoryClass = EnumSerializerFactory.class;
                deserializerFactoryClass = EnumDeserializerFactory.class;
                break;
            }
            case LIST: {
                serializerFactoryClass = SimpleListSerializerFactory.class;
                deserializerFactoryClass = SimpleListDeserializerFactory.class;
                break;
            }
            default: {
                if (type.simpleBaseType == null) break;
                Class clazz = SOAP_TYPE_MAPPING.getClassForQName(type.simpleBaseType, null, null);
                if (null != clazz) {
                    serializerFactoryClass = SOAP_TYPE_MAPPING.getSerializer(clazz, type.simpleBaseType).getClass();
                    deserializerFactoryClass = SOAP_TYPE_MAPPING.getDeserializer(clazz, type.simpleBaseType, null).getClass();
                    break;
                }
                clazz = JAXRPC_TYPE_MAPPING.getClassForQName(type.simpleBaseType, null, null);
                if (null == clazz) break;
                serializerFactoryClass = JAXRPC_TYPE_MAPPING.getSerializer(clazz, type.simpleBaseType).getClass();
                deserializerFactoryClass = JAXRPC_TYPE_MAPPING.getDeserializer(clazz, type.simpleBaseType, null).getClass();
            }
        }
        SerializerFactory serializerFactory = BaseSerializerFactory.createFactory(serializerFactoryClass, javaType, (QName)type.qname);
        DeserializerFactory deserializerFactory = BaseDeserializerFactory.createFactory(deserializerFactoryClass, javaType, (QName)type.qname);
        typeMapping.register(javaType, type.qname, (javax.xml.rpc.encoding.SerializerFactory)serializerFactory, (javax.xml.rpc.encoding.DeserializerFactory)deserializerFactory);
    }
}

