/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BigDecimalHolder;
import javax.xml.rpc.holders.BigIntegerHolder;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.BooleanWrapperHolder;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.ByteHolder;
import javax.xml.rpc.holders.ByteWrapperHolder;
import javax.xml.rpc.holders.CalendarHolder;
import javax.xml.rpc.holders.DoubleHolder;
import javax.xml.rpc.holders.DoubleWrapperHolder;
import javax.xml.rpc.holders.FloatHolder;
import javax.xml.rpc.holders.FloatWrapperHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.IntegerWrapperHolder;
import javax.xml.rpc.holders.LongHolder;
import javax.xml.rpc.holders.LongWrapperHolder;
import javax.xml.rpc.holders.ObjectHolder;
import javax.xml.rpc.holders.QNameHolder;
import javax.xml.rpc.holders.ShortHolder;
import javax.xml.rpc.holders.ShortWrapperHolder;
import javax.xml.rpc.holders.StringHolder;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.jee.ConstructorParameterOrder;
import org.apache.openejb.jee.ExceptionMapping;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JavaXmlTypeMapping;
import org.apache.openejb.jee.MethodParamPartsMapping;
import org.apache.openejb.jee.PackageMapping;
import org.apache.openejb.jee.ServiceEndpointMethodMapping;
import org.apache.openejb.jee.WsdlMessageMapping;
import org.apache.openejb.jee.WsdlReturnValueMapping;
import org.apache.openejb.server.axis.assembler.BindingStyle;
import org.apache.openejb.server.axis.assembler.JaxRpcFaultInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcOperationInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcParameterInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcServiceInfoBuilder;
import org.apache.openejb.server.axis.assembler.XmlElementInfo;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;
import org.apache.openejb.server.axis.assembler.XmlTypeInfo;

public class HeavyweightOperationInfoBuilder {
    private final JavaWsdlMapping mapping;
    private final ServiceEndpointMethodMapping methodMapping;
    private final XmlSchemaInfo schemaInfo;
    private final BindingStyle bindingStyle;
    private final Map<QName, String> publicTypes = new HashMap<QName, String>();
    private final Map<String, String> anonymousTypes = new HashMap<String, String>();
    private final Set<String> inParamNames = new HashSet<String>();
    private final Set<String> outParamNames = new HashSet<String>();
    private final Set<QName> wrapperElementQNames = new HashSet<QName>();
    private final String operationName;
    private final JaxRpcOperationInfo.OperationStyle operationStyle;
    private final Message inputMessage;
    private final Message outputMessage;
    private final Collection<Fault> faults = new ArrayList<Fault>();
    private JaxRpcOperationInfo operationInfo;
    private static final Map<QName, String> qnameToJavaType = new HashMap<QName, String>();
    private static final Map<String, String> rpcHolderClasses;

    public HeavyweightOperationInfoBuilder(BindingOperation bindingOperation, ServiceEndpointMethodMapping methodMapping, JavaWsdlMapping mapping, XmlSchemaInfo schemaInfo) throws OpenEJBException {
        Operation operation = bindingOperation.getOperation();
        this.operationName = operation.getName();
        this.operationStyle = JaxRpcOperationInfo.OperationStyle.valueOf(operation.getStyle().toString());
        this.outputMessage = operation.getOutput() == null ? null : operation.getOutput().getMessage();
        this.inputMessage = operation.getInput().getMessage();
        for (Object o : operation.getFaults().values()) {
            this.faults.add((Fault)o);
        }
        this.mapping = mapping;
        this.methodMapping = methodMapping;
        this.schemaInfo = schemaInfo;
        for (JavaXmlTypeMapping javaXmlTypeMapping : mapping.getJavaXmlTypeMapping()) {
            String javaClassName = javaXmlTypeMapping.getJavaType();
            if (javaXmlTypeMapping.getAnonymousTypeQname() != null) {
                String anonymousTypeQName = javaXmlTypeMapping.getAnonymousTypeQname();
                this.anonymousTypes.put(anonymousTypeQName, javaClassName);
                continue;
            }
            if (javaXmlTypeMapping.getRootTypeQname() == null) continue;
            QName qname = javaXmlTypeMapping.getRootTypeQname();
            this.publicTypes.put(qname, javaClassName);
        }
        if (methodMapping.getWrappedElement() != null) {
            this.bindingStyle = BindingStyle.DOCUMENT_LITERAL_WRAPPED;
        } else {
            BindingInput bindingInput = bindingOperation.getBindingInput();
            SOAPOperation soapOperation = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPOperation.class, bindingOperation.getExtensibilityElements());
            String styleString = soapOperation.getStyle();
            if (styleString == null) {
                SOAPBinding soapBinding = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPBinding.class, bindingInput.getExtensibilityElements());
                styleString = soapBinding.getStyle();
            }
            SOAPBody soapBody = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPBody.class, bindingInput.getExtensibilityElements());
            String useString = soapBody.getUse();
            this.bindingStyle = BindingStyle.getBindingStyle(styleString, useString);
        }
    }

    public Set<QName> getWrapperElementQNames() throws OpenEJBException {
        this.buildOperationInfo();
        return Collections.unmodifiableSet(this.wrapperElementQNames);
    }

    public JaxRpcOperationInfo buildOperationInfo() throws OpenEJBException {
        if (this.operationInfo != null) {
            return this.operationInfo;
        }
        this.operationInfo = new JaxRpcOperationInfo();
        this.operationInfo.name = this.operationName;
        this.operationInfo.bindingStyle = this.bindingStyle;
        this.operationInfo.operationStyle = this.operationStyle;
        this.operationInfo.javaMethodName = this.methodMapping.getJavaMethodName();
        this.mapParameters();
        if (this.methodMapping.getWsdlReturnValueMapping() != null) {
            this.mapReturnType();
        }
        if (this.outputMessage != null && this.bindingStyle.isWrapped()) {
            Part inputPart = this.getWrappedPart(this.outputMessage);
            QName wrapperName = inputPart.getElementName();
            XmlElementInfo wraperElement = this.schemaInfo.elements.get(wrapperName);
            XmlTypeInfo wrapperType = this.schemaInfo.types.get(wraperElement.xmlType);
            HashSet<String> expectedOutParams = new HashSet<String>();
            for (XmlElementInfo expectedOutParam : wrapperType.elements.values()) {
                expectedOutParams.add(expectedOutParam.qname.getLocalPart());
            }
            if (!((Object)this.outParamNames).equals(expectedOutParams)) {
                throw new OpenEJBException("Not all wrapper children were mapped to parameters or a return value for operation " + this.operationName);
            }
        } else if (null != this.outputMessage && !((Object)this.outParamNames).equals(this.outputMessage.getParts().keySet())) {
            throw new OpenEJBException("Not all output message parts were mapped to parameters or a return value for operation " + this.operationName);
        }
        for (Fault fault : this.faults) {
            JaxRpcFaultInfo faultInfo = this.mapFaults(fault);
            this.operationInfo.faults.add(faultInfo);
        }
        return this.operationInfo;
    }

    private JaxRpcParameterInfo[] mapParameters() throws OpenEJBException {
        List paramMappings = this.methodMapping.getMethodParamPartsMapping();
        JaxRpcParameterInfo[] parameterInfos = new JaxRpcParameterInfo[paramMappings.size()];
        for (MethodParamPartsMapping paramMapping : paramMappings) {
            JaxRpcParameterInfo parameterInfo;
            parameterInfos[paramMapping.getParamPosition().intValue()] = parameterInfo = this.mapParameter(paramMapping);
        }
        for (int i = 0; i < parameterInfos.length; ++i) {
            if (parameterInfos[i] != null) continue;
            throw new OpenEJBException("There is no mapping for parameter number " + i + " for operation " + this.operationName);
        }
        if (this.bindingStyle.isWrapped()) {
            Part inputPart = this.getWrappedPart(this.inputMessage);
            QName wrapperName = inputPart.getElementName();
            XmlElementInfo wrapperElement = this.schemaInfo.elements.get(wrapperName);
            XmlTypeInfo wrapperType = this.schemaInfo.types.get(wrapperElement.xmlType);
            HashSet<String> expectedInParams = new HashSet<String>();
            for (XmlElementInfo expectedInParam : wrapperType.elements.values()) {
                expectedInParams.add(expectedInParam.qname.getLocalPart());
            }
            if (!((Object)this.inParamNames).equals(expectedInParams)) {
                throw new OpenEJBException("Not all wrapper children were mapped for operation name" + this.operationName);
            }
        } else if (!((Object)this.inParamNames).equals(this.inputMessage.getParts().keySet())) {
            throw new OpenEJBException("Not all input message parts were mapped for operation name" + this.operationName);
        }
        return parameterInfos;
    }

    private JaxRpcParameterInfo mapParameter(MethodParamPartsMapping paramMapping) throws OpenEJBException {
        String paramJavaType;
        QName paramXmlType;
        QName paramQName;
        Part part;
        WsdlMessageMapping wsdlMessageMappingType = paramMapping.getWsdlMessageMapping();
        QName wsdlMessageQName = wsdlMessageMappingType.getWsdlMessage();
        String wsdlMessagePartName = wsdlMessageMappingType.getWsdlMessagePartName();
        JaxRpcParameterInfo.Mode mode = JaxRpcParameterInfo.Mode.valueOf(wsdlMessageMappingType.getParameterMode());
        if ((mode == JaxRpcParameterInfo.Mode.OUT || mode == JaxRpcParameterInfo.Mode.INOUT) && this.outputMessage == null) {
            throw new OpenEJBException("Mapping for output parameter " + wsdlMessagePartName + " found, but no output message for operation " + this.operationName);
        }
        if (mode == JaxRpcParameterInfo.Mode.IN || mode == JaxRpcParameterInfo.Mode.INOUT) {
            if (!wsdlMessageQName.equals(this.inputMessage.getQName())) {
                throw new OpenEJBException("QName of input message: " + this.inputMessage.getQName() + " does not match mapping message QName: " + wsdlMessageQName + " for operation " + this.operationName);
            }
            part = null;
            XmlElementInfo inParameter = null;
            if (this.bindingStyle.isWrapped()) {
                Part inPart = this.getWrappedPart(this.inputMessage);
                QName name = inPart.getElementName();
                if (!name.getLocalPart().equals(this.operationName)) {
                    throw new OpenEJBException("message " + this.inputMessage.getQName() + " refers to a global element named " + name.getLocalPart() + ", which is not equal to the operation name " + this.operationName);
                }
                inParameter = this.getWrapperChild(inPart, wsdlMessagePartName);
                paramQName = new QName("", inParameter.qname.getLocalPart());
                paramXmlType = inParameter.xmlType;
            } else if (this.bindingStyle.isRpc()) {
                part = this.inputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in input message for operation " + this.operationName);
                }
                paramQName = new QName("", part.getName());
                paramXmlType = part.getTypeName();
            } else {
                part = this.inputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in input message for operation " + this.operationName);
                }
                paramXmlType = paramQName = this.getPartName(part);
            }
            this.inParamNames.add(wsdlMessagePartName);
            if (mode == JaxRpcParameterInfo.Mode.INOUT) {
                Part outPart;
                if (this.bindingStyle.isWrapped()) {
                    outPart = this.getWrappedPart(this.outputMessage);
                    XmlElementInfo outParameter = this.getWrapperChild(outPart, wsdlMessagePartName);
                    if (inParameter.xmlType != outParameter.xmlType) {
                        throw new OpenEJBException("The wrapper children " + wsdlMessagePartName + " do not have the same type for operation " + this.operationName);
                    }
                } else if (this.bindingStyle.isRpc()) {
                    outPart = this.outputMessage.getPart(wsdlMessagePartName);
                    if (outPart == null) {
                        throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for INOUT parameter of operation " + this.operationName);
                    }
                    if (!part.getName().equals(outPart.getName())) {
                        throw new OpenEJBException("Mismatched input part name: " + part.getName() + " and output part name: " + outPart.getName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                    if (!(part.getElementName() != null ? part.getElementName().equals(outPart.getElementName()) : outPart.getElementName() == null)) {
                        throw new OpenEJBException("Mismatched input part element name: " + part.getElementName() + " and output part element name: " + outPart.getElementName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                    if (!(part.getTypeName() != null ? part.getTypeName().equals(outPart.getTypeName()) : outPart.getTypeName() == null)) {
                        throw new OpenEJBException("Mismatched input part type name: " + part.getTypeName() + " and output part type name: " + outPart.getTypeName() + " for INOUT parameter for wsdlMessagePartName " + wsdlMessagePartName + " for operation " + this.operationName);
                    }
                } else {
                    part = this.outputMessage.getPart(wsdlMessagePartName);
                    if (part == null) {
                        throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                    }
                    paramXmlType = paramQName = this.getPartName(part);
                }
                this.outParamNames.add(wsdlMessagePartName);
            }
        } else {
            if (!wsdlMessageQName.equals(this.outputMessage.getQName())) {
                throw new OpenEJBException("QName of output message: " + this.outputMessage.getQName() + " does not match mapping message QName: " + wsdlMessageQName + " for operation " + this.operationName);
            }
            if (this.bindingStyle.isWrapped()) {
                Part outPart = this.getWrappedPart(this.outputMessage);
                XmlElementInfo outParameter = this.getWrapperChild(outPart, wsdlMessagePartName);
                paramQName = new QName("", outParameter.qname.getLocalPart());
                paramXmlType = outParameter.xmlType;
            } else if (this.bindingStyle.isRpc()) {
                part = this.outputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                paramQName = new QName("", part.getName());
                paramXmlType = part.getTypeName();
            } else {
                part = this.outputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                paramXmlType = paramQName = this.getPartName(part);
            }
            this.outParamNames.add(wsdlMessagePartName);
        }
        if (mode == JaxRpcParameterInfo.Mode.IN) {
            paramJavaType = paramMapping.getParamType();
        } else if (rpcHolderClasses.containsKey(paramMapping.getParamType())) {
            paramJavaType = rpcHolderClasses.get(paramMapping.getParamType());
        } else {
            String typeName;
            String packageName;
            PackageMapping packageMapping = (PackageMapping)this.mapping.getPackageMappingMap().get(paramXmlType.getNamespaceURI());
            if (packageMapping != null) {
                packageName = packageMapping.getPackageType();
                typeName = paramXmlType.getLocalPart();
                typeName = Character.toUpperCase(typeName.charAt(0)) + typeName.substring(1);
            } else {
                String paramJavaTypeName = paramMapping.getParamType();
                int lastDot = paramJavaTypeName.lastIndexOf(".");
                packageName = paramJavaTypeName.substring(0, lastDot);
                typeName = paramJavaTypeName.substring(lastDot + 1);
            }
            paramJavaType = packageName + ".holders." + typeName + "Holder";
        }
        JaxRpcParameterInfo parameterInfo = new JaxRpcParameterInfo();
        parameterInfo.qname = paramQName;
        parameterInfo.xmlType = paramXmlType;
        parameterInfo.javaType = paramJavaType;
        parameterInfo.mode = JaxRpcParameterInfo.Mode.valueOf(wsdlMessageMappingType.getParameterMode());
        parameterInfo.soapHeader = wsdlMessageMappingType.getSoapHeader() != null;
        return parameterInfo;
    }

    private void mapReturnType() throws OpenEJBException {
        if (this.outputMessage == null) {
            throw new OpenEJBException("No output message, but a mapping for it for operation " + this.operationName);
        }
        WsdlReturnValueMapping wsdlReturnValueMapping = this.methodMapping.getWsdlReturnValueMapping();
        if (!wsdlReturnValueMapping.getWsdlMessage().equals(this.outputMessage.getQName())) {
            throw new OpenEJBException("OutputMessage has QName: " + this.outputMessage.getQName() + " but mapping specifies: " + wsdlReturnValueMapping.getWsdlMessage() + " for operation " + this.operationName);
        }
        QName returnQName = null;
        QName returnXmlType = null;
        if (wsdlReturnValueMapping.getWsdlMessagePartName() != null) {
            String wsdlMessagePartName = wsdlReturnValueMapping.getWsdlMessagePartName();
            if (this.outParamNames.contains(wsdlMessagePartName)) {
                throw new OpenEJBException("output message part " + wsdlMessagePartName + " has both an INOUT or OUT mapping and a return value mapping for operation " + this.operationName);
            }
            if (this.bindingStyle.isWrapped()) {
                Part outPart = this.getWrappedPart(this.outputMessage);
                XmlElementInfo returnParticle = this.getWrapperChild(outPart, wsdlMessagePartName);
                returnQName = new QName("", returnParticle.qname.getLocalPart());
                returnXmlType = returnParticle.xmlType;
            } else if (this.bindingStyle.isRpc()) {
                Part part = this.outputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                returnQName = new QName("", part.getName());
                returnXmlType = part.getTypeName();
            } else {
                Part part = this.outputMessage.getPart(wsdlMessagePartName);
                if (part == null) {
                    throw new OpenEJBException("No part for wsdlMessagePartName " + wsdlMessagePartName + " in output message for operation " + this.operationName);
                }
                returnXmlType = returnQName = this.getPartName(part);
            }
            this.outParamNames.add(wsdlMessagePartName);
        }
        this.operationInfo.returnQName = returnQName;
        this.operationInfo.returnXmlType = returnXmlType;
        this.operationInfo.returnJavaType = wsdlReturnValueMapping.getMethodReturnValue();
    }

    private JaxRpcFaultInfo mapFaults(Fault fault) throws OpenEJBException {
        QName faultQName;
        XmlTypeInfo faultTypeInfo;
        Part part;
        Message message = fault.getMessage();
        ExceptionMapping exceptionMapping = (ExceptionMapping)this.mapping.getExceptionMappingMap().get(message.getQName());
        if (exceptionMapping == null) {
            throw new OpenEJBException("No exception mapping for fault " + fault.getName() + " and fault message " + message.getQName() + " for operation " + this.operationName);
        }
        if (exceptionMapping.getWsdlMessagePartName() != null) {
            String headerFaultMessagePartName = exceptionMapping.getWsdlMessagePartName();
            part = message.getPart(headerFaultMessagePartName);
        } else {
            part = (Part)message.getOrderedParts(null).iterator().next();
        }
        if (part.getElementName() != null) {
            XmlElementInfo elementInfo = this.schemaInfo.elements.get(part.getElementName());
            if (elementInfo == null) {
                throw new OpenEJBException("Can not find element: " + part.getElementName() + ", known elements: " + this.schemaInfo.elements.keySet());
            }
            faultTypeInfo = this.schemaInfo.types.get(elementInfo.xmlType);
            if (faultTypeInfo == null) {
                throw new OpenEJBException("Can not find type " + elementInfo.xmlType + " for element " + elementInfo.qname + ", known types: " + this.schemaInfo.types.keySet());
            }
            faultQName = part.getElementName();
        } else if (part.getTypeName() != null) {
            faultTypeInfo = this.schemaInfo.types.get(part.getTypeName());
            if (faultTypeInfo == null) {
                throw new OpenEJBException("Can not find type: " + part.getTypeName() + ", known elements: " + this.schemaInfo.types.keySet());
            }
            faultQName = new QName("", fault.getName());
        } else {
            throw new OpenEJBException("Neither type nor element name supplied for part: " + part);
        }
        JaxRpcFaultInfo faultInfo = new JaxRpcFaultInfo();
        faultInfo.qname = faultQName;
        faultInfo.xmlType = faultTypeInfo.qname;
        faultInfo.javaType = exceptionMapping.getExceptionType();
        boolean bl = faultInfo.complex = faultTypeInfo.simpleBaseType == null;
        if (exceptionMapping.getConstructorParameterOrder() != null) {
            if (faultTypeInfo.simpleBaseType != null) {
                throw new OpenEJBException("ConstructorParameterOrder can only be set for complex types, not " + faultTypeInfo.qname);
            }
            HashMap<String, XmlElementInfo> elements = new HashMap<String, XmlElementInfo>();
            for (XmlElementInfo element : faultTypeInfo.elements.values()) {
                elements.put(element.qname.getLocalPart(), element);
            }
            ConstructorParameterOrder constructorParameterOrder = exceptionMapping.getConstructorParameterOrder();
            for (int i = 0; i < constructorParameterOrder.getElementName().size(); ++i) {
                String paramName = (String)constructorParameterOrder.getElementName().get(i);
                XmlElementInfo paramElementInfo = (XmlElementInfo)((Object)elements.get(paramName));
                if (paramElementInfo == null) {
                    throw new OpenEJBException("Can not find element " + paramName + " in fault type " + faultTypeInfo.qname + ", known elements: " + elements.keySet());
                }
                String paramJavaType = null;
                XmlTypeInfo paramTypeInfo = this.schemaInfo.types.get(paramElementInfo.xmlType);
                if (paramTypeInfo != null) {
                    paramJavaType = paramTypeInfo.anonymous ? this.anonymousTypes.get(paramTypeInfo.qname.getLocalPart()) : this.publicTypes.get(paramTypeInfo.qname);
                }
                if (paramJavaType == null) {
                    paramJavaType = qnameToJavaType.get(paramElementInfo.xmlType);
                }
                if (paramJavaType == null) {
                    throw new OpenEJBException("No class mapped for element type: " + paramElementInfo.xmlType);
                }
                JaxRpcParameterInfo parameterInfo = new JaxRpcParameterInfo();
                parameterInfo.qname = paramElementInfo.qname;
                parameterInfo.mode = JaxRpcParameterInfo.Mode.OUT;
                parameterInfo.soapHeader = false;
                parameterInfo.xmlType = paramElementInfo.xmlType;
                parameterInfo.javaType = paramJavaType;
                faultInfo.parameters.add(parameterInfo);
            }
        }
        return faultInfo;
    }

    private QName getPartName(Part part) {
        return part.getElementName() == null ? part.getTypeName() : part.getElementName();
    }

    private Part getWrappedPart(Message message) throws OpenEJBException {
        Collection parts = message.getParts().values();
        if (parts.size() != 1) {
            throw new OpenEJBException("message " + message.getQName() + " has " + parts.size() + " parts and should only have one as wrapper style mapping is specified for operation " + this.operationName);
        }
        return (Part)parts.iterator().next();
    }

    private XmlElementInfo getWrapperChild(Part part, String wsdlMessagePartName) throws OpenEJBException {
        QName elementName = part.getElementName();
        this.wrapperElementQNames.add(elementName);
        XmlElementInfo wrapperElement = this.schemaInfo.elements.get(elementName);
        if (wrapperElement == null) {
            throw new OpenEJBException("No global element named " + elementName + " for operation " + this.operationName);
        }
        XmlTypeInfo wrapperType = this.schemaInfo.types.get(wrapperElement.xmlType);
        if (wrapperType == null) {
            throw new OpenEJBException("Can not find type " + wrapperElement.xmlType + " for element " + wrapperElement.qname + ", known types: " + this.schemaInfo.types.keySet());
        }
        for (XmlElementInfo wrapperChild : wrapperType.elements.values()) {
            if (!wrapperChild.qname.getLocalPart().equals(wsdlMessagePartName)) continue;
            return wrapperChild;
        }
        throw new OpenEJBException("Global element named " + elementName + " does not define a child element named " + wsdlMessagePartName + " required by the operation " + this.operationName);
    }

    static {
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "string"), String.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "integer"), BigInteger.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "int"), Integer.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "long"), Long.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "short"), Short.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "decimal"), BigDecimal.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "float"), Float.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "double"), Double.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean"), Boolean.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "byte"), Byte.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt"), Long.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), Integer.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedByte"), Short.TYPE.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "QName"), QName.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "dateTime"), Calendar.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "date"), Calendar.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "time"), Calendar.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), URI.class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"), byte[].class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "hexBinary"), byte[].class.getName());
        qnameToJavaType.put(new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType"), String.class.getName());
        rpcHolderClasses = new HashMap<String, String>();
        rpcHolderClasses.put(BigDecimal.class.getName(), BigDecimalHolder.class.getName());
        rpcHolderClasses.put(BigInteger.class.getName(), BigIntegerHolder.class.getName());
        rpcHolderClasses.put(Boolean.TYPE.getName(), BooleanHolder.class.getName());
        rpcHolderClasses.put(Boolean.class.getName(), BooleanWrapperHolder.class.getName());
        rpcHolderClasses.put(byte[].class.getName(), ByteArrayHolder.class.getName());
        rpcHolderClasses.put(Byte.TYPE.getName(), ByteHolder.class.getName());
        rpcHolderClasses.put(Byte.class.getName(), ByteWrapperHolder.class.getName());
        rpcHolderClasses.put(Calendar.class.getName(), CalendarHolder.class.getName());
        rpcHolderClasses.put(Double.TYPE.getName(), DoubleHolder.class.getName());
        rpcHolderClasses.put(Double.class.getName(), DoubleWrapperHolder.class.getName());
        rpcHolderClasses.put(Float.TYPE.getName(), FloatHolder.class.getName());
        rpcHolderClasses.put(Float.class.getName(), FloatWrapperHolder.class.getName());
        rpcHolderClasses.put(Integer.TYPE.getName(), IntHolder.class.getName());
        rpcHolderClasses.put(Integer.class.getName(), IntegerWrapperHolder.class.getName());
        rpcHolderClasses.put(Long.TYPE.getName(), LongHolder.class.getName());
        rpcHolderClasses.put(Long.class.getName(), LongWrapperHolder.class.getName());
        rpcHolderClasses.put(Object.class.getName(), ObjectHolder.class.getName());
        rpcHolderClasses.put(QName.class.getName(), QNameHolder.class.getName());
        rpcHolderClasses.put(Short.TYPE.getName(), ShortHolder.class.getName());
        rpcHolderClasses.put(Short.class.getName(), ShortWrapperHolder.class.getName());
        rpcHolderClasses.put(String.class.getName(), StringHolder.class.getName());
    }
}

