/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JavaXmlTypeMapping;
import org.apache.openejb.jee.VariableMapping;
import org.apache.openejb.server.axis.assembler.JaxRpcFieldInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcOperationInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcParameterInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcTypeInfo;
import org.apache.openejb.server.axis.assembler.XmlElementInfo;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;
import org.apache.openejb.server.axis.assembler.XmlTypeInfo;

public class HeavyweightTypeInfoBuilder {
    private static final String SOAP_ENCODING_NS = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final String XML_SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final Log log = LogFactory.getLog(HeavyweightTypeInfoBuilder.class);
    private final JavaWsdlMapping mapping;
    private final ClassLoader classLoader;
    private final XmlSchemaInfo schemaInfo;
    private final Set wrapperElementQNames;
    private final Collection<JaxRpcOperationInfo> operations;
    private final boolean hasEncoded;
    private static final Set<String> WebserviceNameSpaces = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("http://schemas.xmlsoap.org/soap/encoding/", "http://www.w3.org/2003/05/soap-encoding", "http://xml.apache.org/xml-soap", "http://www.w3.org/1999/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/2001/XMLSchema", "http://www.w3.org/XML/1998/namespace")));

    public HeavyweightTypeInfoBuilder(JavaWsdlMapping mapping, XmlSchemaInfo schemaInfo, ClassLoader classLoader, Set wrapperElementQNames, Collection<JaxRpcOperationInfo> operations, boolean hasEncoded) {
        this.mapping = mapping;
        this.classLoader = classLoader;
        this.schemaInfo = schemaInfo;
        this.wrapperElementQNames = wrapperElementQNames;
        this.operations = operations;
        this.hasEncoded = hasEncoded;
    }

    public List<JaxRpcTypeInfo> buildTypeInfo() throws OpenEJBException {
        ArrayList<JaxRpcTypeInfo> typeInfos = new ArrayList<JaxRpcTypeInfo>();
        HashSet<QName> mappedTypeQNames = new HashSet<QName>();
        for (JavaXmlTypeMapping javaXmlTypeMapping : this.mapping.getJavaXmlTypeMapping()) {
            Class<?> clazz;
            QName xmlTypeQName;
            QName qname;
            if (javaXmlTypeMapping.getRootTypeQname() != null) {
                qname = javaXmlTypeMapping.getRootTypeQname();
                if (this.wrapperElementQNames.contains(qname)) {
                    continue;
                }
            } else if (javaXmlTypeMapping.getAnonymousTypeQname() != null) {
                String anonTypeQNameString = javaXmlTypeMapping.getAnonymousTypeQname();
                int pos = anonTypeQNameString.lastIndexOf(":");
                if (pos == -1) {
                    throw new OpenEJBException("anon QName is invalid, no final ':' " + anonTypeQNameString);
                }
                String namespace = anonTypeQNameString.substring(0, pos);
                String localPart = anonTypeQNameString.substring(pos + 1);
                qname = new QName(namespace, localPart);
                if (this.wrapperElementQNames.contains(new QName(namespace, anonTypeQNameString.substring(pos + 2)))) {
                    continue;
                }
            } else {
                throw new OpenEJBException("either root type qname or anonymous type qname must be set");
            }
            if ("element".equals(javaXmlTypeMapping.getQNameScope())) {
                XmlElementInfo elementInfo = this.schemaInfo.elements.get(qname);
                if (elementInfo == null) {
                    log.warn((Object)("Element [" + qname + "] not been found in schema, known elements: " + this.schemaInfo.elements.keySet()));
                }
                xmlTypeQName = elementInfo.xmlType;
            } else {
                xmlTypeQName = qname;
            }
            XmlTypeInfo xmlTypeInfo = this.schemaInfo.types.get(xmlTypeQName);
            if (xmlTypeInfo == null) {
                if (WebserviceNameSpaces.contains(xmlTypeInfo.qname.getNamespaceURI())) continue;
                log.warn((Object)("Schema type QName [" + qname + "] not been found in schema: " + this.schemaInfo.types.keySet()));
                continue;
            }
            mappedTypeQNames.add(xmlTypeInfo.qname);
            try {
                clazz = Class.forName(javaXmlTypeMapping.getJavaType(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBException("Could not load java type " + javaXmlTypeMapping.getJavaType(), (Throwable)e);
            }
            JaxRpcTypeInfo typeInfo = this.createTypeInfo(qname, xmlTypeInfo, clazz);
            this.mapFields(clazz, xmlTypeInfo, javaXmlTypeMapping, typeInfo);
            typeInfos.add(typeInfo);
        }
        for (JaxRpcOperationInfo operationInfo : this.operations) {
            ArrayList<JaxRpcParameterInfo> parameters = new ArrayList<JaxRpcParameterInfo>(operationInfo.parameters);
            if (operationInfo.returnXmlType != null) {
                JaxRpcParameterInfo returnParameter = new JaxRpcParameterInfo();
                returnParameter.xmlType = operationInfo.returnXmlType;
                returnParameter.javaType = operationInfo.returnJavaType;
                parameters.add(returnParameter);
            }
            for (JaxRpcParameterInfo parameterInfo : parameters) {
                Class<?> clazz;
                QName xmlType = parameterInfo.xmlType;
                if (xmlType == null || mappedTypeQNames.contains(xmlType) || xmlType.getNamespaceURI().equals(XML_SCHEMA_NS) || xmlType.getNamespaceURI().equals(SOAP_ENCODING_NS)) continue;
                XmlTypeInfo xmlTypeInfo = this.schemaInfo.types.get(xmlType);
                if (xmlTypeInfo == null) {
                    log.warn((Object)("Type QName [" + xmlType + "] defined by operation [" + operationInfo + "] has not been found in schema: " + this.schemaInfo.types.keySet()));
                    continue;
                }
                mappedTypeQNames.add(xmlTypeInfo.qname);
                try {
                    clazz = this.classLoader.loadClass(parameterInfo.javaType);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenEJBException("Could not load paramter");
                }
                if (xmlTypeInfo.simpleBaseType == null && !clazz.isArray()) {
                    if (mappedTypeQNames.contains(xmlTypeInfo.qname)) continue;
                    log.warn((Object)("Operation " + operationInfo.name + "] uses XML type [" + (Object)((Object)xmlTypeInfo) + "], whose mapping is not declared by the jaxrpc mapping file.\n Continuing deployment; " + "yet, the deployment is not-portable."));
                    continue;
                }
                JaxRpcTypeInfo typeInfo = this.createTypeInfo(parameterInfo.qname, xmlTypeInfo, clazz);
                typeInfos.add(typeInfo);
            }
        }
        return typeInfos;
    }

    private JaxRpcTypeInfo createTypeInfo(QName qname, XmlTypeInfo xmlTypeInfo, Class clazz) throws OpenEJBException {
        JaxRpcTypeInfo.SerializerType serializerType = xmlTypeInfo.listType ? JaxRpcTypeInfo.SerializerType.LIST : (clazz.isArray() ? JaxRpcTypeInfo.SerializerType.ARRAY : (xmlTypeInfo.enumType ? JaxRpcTypeInfo.SerializerType.ENUM : JaxRpcTypeInfo.SerializerType.OTHER));
        JaxRpcTypeInfo typeInfo = new JaxRpcTypeInfo();
        typeInfo.qname = qname;
        typeInfo.javaType = clazz.getName();
        typeInfo.serializerType = serializerType;
        typeInfo.simpleBaseType = xmlTypeInfo.simpleBaseType;
        if (serializerType == JaxRpcTypeInfo.SerializerType.ARRAY) {
            typeInfo.componentType = xmlTypeInfo.arrayComponentType;
        }
        return typeInfo;
    }

    private void mapFields(Class javaClass, XmlTypeInfo xmlTypeInfo, JavaXmlTypeMapping javaXmlTypeMapping, JaxRpcTypeInfo typeInfo) throws OpenEJBException {
        if (!javaClass.isArray()) {
            if (!javaXmlTypeMapping.getVariableMapping().isEmpty()) {
                log.warn((Object)("Ignoring variable-mapping defined for class " + javaClass + " which is an array."));
            }
            return;
        }
        HashMap properties = new HashMap();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(javaClass).getPropertyDescriptors()) {
                properties.put(propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
            }
        }
        catch (IntrospectionException e) {
            throw new OpenEJBException("Class " + javaClass + " is not a valid javabean", (Throwable)e);
        }
        for (VariableMapping variableMapping : javaXmlTypeMapping.getVariableMapping()) {
            String ns;
            QName xmlName;
            XmlElementInfo nestedElement;
            Class javaType;
            JaxRpcFieldInfo fieldInfo;
            String fieldName = variableMapping.getJavaVariableName();
            if (variableMapping.getXmlAttributeName() != null) {
                QName xmlName2;
                fieldInfo = new JaxRpcFieldInfo();
                fieldInfo.name = fieldName;
                javaType = (Class)properties.get(fieldName);
                if (javaType == null) {
                    throw new OpenEJBException("field name " + fieldName + " not found in " + properties);
                }
                String attributeLocalName = variableMapping.getXmlAttributeName();
                fieldInfo.xmlName = xmlName2 = new QName("", attributeLocalName);
                fieldInfo.xmlType = xmlTypeInfo.attributes.get(attributeLocalName);
                if (fieldInfo.xmlType == null) {
                    throw new OpenEJBException("attribute " + xmlName2 + " not found in schema " + xmlTypeInfo.qname);
                }
                typeInfo.fields.add(fieldInfo);
                continue;
            }
            fieldInfo = new JaxRpcFieldInfo();
            fieldInfo.isElement = true;
            fieldInfo.name = fieldName;
            javaType = (Class)properties.get(fieldName);
            if (javaType == null) {
                try {
                    Field field = javaClass.getField(fieldName);
                    javaType = field.getType();
                }
                catch (NoSuchFieldException e) {
                    throw new OpenEJBException("field name " + fieldName + " not found in " + properties, (Throwable)e);
                }
            }
            if ((nestedElement = xmlTypeInfo.elements.get(xmlName = new QName("", variableMapping.getXmlElementName()))) == null && (nestedElement = xmlTypeInfo.elements.get(xmlName = new QName(ns = xmlTypeInfo.qname.getNamespaceURI(), variableMapping.getXmlElementName()))) == null) {
                throw new OpenEJBException("element " + xmlName + " not found in schema " + xmlTypeInfo.qname);
            }
            fieldInfo.isNillable = nestedElement.nillable || this.hasEncoded;
            fieldInfo.xmlName = xmlName;
            if (nestedElement.xmlType != null) {
                fieldInfo.xmlType = nestedElement.xmlType;
            } else {
                QName anonymousName = xmlTypeInfo.anonymous ? new QName(xmlTypeInfo.qname.getNamespaceURI(), xmlTypeInfo.qname.getLocalPart() + ">" + nestedElement.qname.getLocalPart()) : new QName(xmlTypeInfo.qname.getNamespaceURI(), ">" + xmlTypeInfo.qname.getLocalPart() + ">" + nestedElement.qname.getLocalPart());
                fieldInfo.xmlType = anonymousName;
            }
            if (javaType.isArray()) {
                fieldInfo.minOccurs = nestedElement.minOccurs;
                fieldInfo.maxOccurs = nestedElement.maxOccurs;
            }
            typeInfo.fields.add(fieldInfo);
        }
    }
}

