/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.xml.namespace.QName;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ServiceEndpointInterfaceMapping;
import org.apache.openejb.jee.ServiceEndpointMethodMapping;
import org.apache.openejb.server.axis.assembler.BindingStyle;
import org.apache.openejb.server.axis.assembler.HeavyweightOperationInfoBuilder;
import org.apache.openejb.server.axis.assembler.HeavyweightTypeInfoBuilder;
import org.apache.openejb.server.axis.assembler.JaxRpcOperationInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcServiceInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcTypeInfo;
import org.apache.openejb.server.axis.assembler.LightweightOperationInfoBuilder;
import org.apache.openejb.server.axis.assembler.LightweightTypeInfoBuilder;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;

public class JaxRpcServiceInfoBuilder {
    private final JavaWsdlMapping javaWsdlMapping;
    private final XmlSchemaInfo schemaInfo;
    private final PortComponent portComponent;
    private final Port port;
    private final String wsdlFile;
    private final ClassLoader classLoader;
    private JaxRpcServiceInfo serviceInfo;

    public JaxRpcServiceInfoBuilder(JavaWsdlMapping javaWsdlMapping, XmlSchemaInfo schemaInfo, PortComponent portComponent, Port port, String wsdlFile, ClassLoader classLoader) {
        this.javaWsdlMapping = javaWsdlMapping;
        this.schemaInfo = schemaInfo;
        this.portComponent = portComponent;
        this.port = port;
        this.wsdlFile = wsdlFile;
        this.classLoader = classLoader;
    }

    public JaxRpcServiceInfo createServiceInfo() throws OpenEJBException {
        List<JaxRpcTypeInfo> types;
        Class<?> serviceEndpointInterface;
        try {
            serviceEndpointInterface = this.classLoader.loadClass(this.portComponent.getServiceEndpointInterface());
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Unable to load the service-endpoint interface for port-component " + this.portComponent.getPortComponentName(), (Throwable)e);
        }
        this.serviceInfo = new JaxRpcServiceInfo();
        this.serviceInfo.name = this.portComponent.getWsdlPort().toString();
        this.serviceInfo.serviceEndpointInterface = this.portComponent.getServiceEndpointInterface();
        this.serviceInfo.endpointURL = this.getAddressLocation(this.port.getExtensibilityElements());
        this.serviceInfo.wsdlFile = this.wsdlFile;
        this.serviceInfo.defaultBindingStyle = this.getStyle(this.port.getBinding());
        boolean isLightweight = this.javaWsdlMapping.getServiceEndpointInterfaceMapping().isEmpty();
        Set<QName> wrapperElementQNames = this.buildOperations(this.port.getBinding(), serviceEndpointInterface, isLightweight);
        if (isLightweight) {
            LightweightTypeInfoBuilder builder = new LightweightTypeInfoBuilder(this.javaWsdlMapping, this.schemaInfo, this.classLoader);
            types = builder.buildTypeInfo();
        } else {
            HeavyweightTypeInfoBuilder builder = new HeavyweightTypeInfoBuilder(this.javaWsdlMapping, this.schemaInfo, this.classLoader, wrapperElementQNames, this.serviceInfo.operations, this.serviceInfo.defaultBindingStyle.isEncoded());
            types = builder.buildTypeInfo();
        }
        this.serviceInfo.types.addAll(types);
        return this.serviceInfo;
    }

    private Set<QName> buildOperations(Binding binding, Class serviceEndpointInterface, boolean lightweight) throws OpenEJBException {
        HashSet<QName> wrappedElementQNames = new HashSet<QName>();
        for (Object op : binding.getBindingOperations()) {
            JaxRpcOperationInfo operationInfo;
            Object operationInfoBuilder;
            BindingOperation bindingOperation = (BindingOperation)op;
            String operationName = bindingOperation.getOperation().getName();
            if (lightweight) {
                Method method = this.getMethodForOperation(operationName, serviceEndpointInterface);
                operationInfoBuilder = new LightweightOperationInfoBuilder(bindingOperation, method);
                operationInfo = ((LightweightOperationInfoBuilder)operationInfoBuilder).buildOperationInfo();
                this.serviceInfo.operations.add(operationInfo);
                continue;
            }
            ServiceEndpointMethodMapping methodMapping = this.getMethodMappingForOperation(operationName, serviceEndpointInterface);
            operationInfoBuilder = new HeavyweightOperationInfoBuilder(bindingOperation, methodMapping, this.javaWsdlMapping, this.schemaInfo);
            operationInfo = ((HeavyweightOperationInfoBuilder)operationInfoBuilder).buildOperationInfo();
            this.serviceInfo.operations.add(operationInfo);
            Set<QName> wrappedElementQNamesForOper = ((HeavyweightOperationInfoBuilder)operationInfoBuilder).getWrapperElementQNames();
            wrappedElementQNames.addAll(wrappedElementQNamesForOper);
        }
        return wrappedElementQNames;
    }

    private BindingStyle getStyle(Binding binding) throws OpenEJBException {
        SOAPBinding soapBinding = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPBinding.class, binding.getExtensibilityElements());
        String styleString = soapBinding.getStyle();
        BindingInput bindingInput = ((BindingOperation)binding.getBindingOperations().get(0)).getBindingInput();
        SOAPBody soapBody = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPBody.class, bindingInput.getExtensibilityElements());
        String useString = soapBody.getUse();
        BindingStyle bindingStyle = BindingStyle.getBindingStyle(styleString, useString);
        return bindingStyle;
    }

    private String getAddressLocation(List extensibilityElements) throws OpenEJBException {
        SOAPAddress soapAddress = JaxRpcServiceInfoBuilder.getExtensibilityElement(SOAPAddress.class, extensibilityElements);
        String locationURIString = soapAddress.getLocationURI();
        return locationURIString;
    }

    private Method getMethodForOperation(String operationName, Class serviceEndpointInterface) throws OpenEJBException {
        Method found = null;
        for (Method method : serviceEndpointInterface.getMethods()) {
            if (!method.getName().equals(operationName)) continue;
            if (found != null) {
                throw new OpenEJBException("Overloaded methods are not allowed in lightweight mappings");
            }
            found = method;
        }
        if (found == null) {
            throw new OpenEJBException("No method found for operation named " + operationName);
        }
        return found;
    }

    private ServiceEndpointMethodMapping getMethodMappingForOperation(String operationName, Class serviceEndpointInterface) throws OpenEJBException {
        ServiceEndpointInterfaceMapping interfaceMapping = (ServiceEndpointInterfaceMapping)this.javaWsdlMapping.getServiceEndpointInterfaceMappingMap().get(serviceEndpointInterface.getName());
        if (interfaceMapping == null) {
            throw new OpenEJBException("No java-wsdl mapping found for the service interface " + serviceEndpointInterface);
        }
        for (ServiceEndpointMethodMapping methodMapping : interfaceMapping.getServiceEndpointMethodMapping()) {
            if (!operationName.equals(methodMapping.getWsdlOperation())) continue;
            return methodMapping;
        }
        StringBuffer availOps = new StringBuffer(128);
        for (ServiceEndpointMethodMapping methodMapping : interfaceMapping.getServiceEndpointMethodMapping()) {
            if (availOps.length() > 0) {
                availOps.append(",");
            }
            availOps.append(methodMapping.getWsdlOperation());
        }
        throw new OpenEJBException("No method found for operation named '" + operationName + "'. Available operations: " + availOps);
    }

    public static <T extends ExtensibilityElement> T getExtensibilityElement(Class<T> clazz, List extensibilityElements) throws OpenEJBException {
        for (Object o : extensibilityElements) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)o;
            if (!clazz.isAssignableFrom(extensibilityElement.getClass())) continue;
            return (T)((ExtensibilityElement)clazz.cast(extensibilityElement));
        }
        throw new OpenEJBException("No element of class " + clazz.getName() + " found");
    }
}

