/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.lang.reflect.Method;
import java.util.List;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.axis.assembler.BindingStyle;
import org.apache.openejb.server.axis.assembler.JaxRpcOperationInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcParameterInfo;

public class LightweightOperationInfoBuilder {
    private final String operationName;
    private final Message inputMessage;
    private final Message outputMessage;
    private final Method method;
    private JaxRpcOperationInfo operationInfo;

    public LightweightOperationInfoBuilder(BindingOperation bindingOperation, Method method) throws OpenEJBException {
        if (bindingOperation == null) {
            throw new OpenEJBException("No BindingOperation supplied for method " + method.getName());
        }
        Operation operation = bindingOperation.getOperation();
        this.operationName = operation.getName();
        this.inputMessage = operation.getInput().getMessage();
        this.outputMessage = operation.getOutput() == null ? null : operation.getOutput().getMessage();
        this.method = method;
    }

    public JaxRpcOperationInfo buildOperationInfo() throws OpenEJBException {
        List inputParts;
        if (this.operationInfo != null) {
            return this.operationInfo;
        }
        this.operationInfo = new JaxRpcOperationInfo();
        this.operationInfo.name = this.operationName;
        this.operationInfo.bindingStyle = BindingStyle.RPC_ENCODED;
        this.operationInfo.javaMethodName = this.method.getName();
        Class<?>[] methodParamTypes = this.method.getParameterTypes();
        if (methodParamTypes.length != (inputParts = this.inputMessage.getOrderedParts(null)).size()) {
            throw new OpenEJBException("mismatch in parameter counts: method has " + methodParamTypes.length + " whereas the input message has " + inputParts.size());
        }
        int i = 0;
        for (Object inputPart : inputParts) {
            Part part = (Part)inputPart;
            JaxRpcParameterInfo parameter = new JaxRpcParameterInfo();
            parameter.qname = new QName("", part.getName());
            parameter.mode = JaxRpcParameterInfo.Mode.IN;
            parameter.xmlType = part.getTypeName() == null ? part.getElementName() : part.getTypeName();
            parameter.javaType = methodParamTypes[i++].getName();
            parameter.soapHeader = false;
            this.operationInfo.parameters.add(parameter);
        }
        if (this.outputMessage != null && this.outputMessage.getParts().size() > 1) {
            throw new OpenEJBException("Lightweight mapping has at most one part in the (optional) output message, not: " + this.outputMessage.getParts().size());
        }
        if (this.outputMessage != null && this.outputMessage.getParts().size() == 1) {
            Part part = (Part)this.outputMessage.getParts().values().iterator().next();
            this.operationInfo.returnQName = part.getElementName() == null ? new QName(part.getName()) : part.getElementName();
            this.operationInfo.returnXmlType = part.getTypeName() == null ? part.getElementName() : part.getTypeName();
            this.operationInfo.returnJavaType = this.method.getReturnType().getName();
        }
        return this.operationInfo;
    }
}

