/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.client;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.naming.NamingException;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastConstructor;
import org.apache.axis.client.Service;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.server.axis.client.NoOverrideCallbackFilter;
import org.apache.openejb.server.axis.client.SeiFactoryImpl;
import org.apache.openejb.server.axis.client.ServiceImpl;
import org.apache.openejb.server.axis.client.ServiceMethodInterceptor;

public class AxisServiceReference
extends Reference {
    private static final Class[] SERVICE_CONSTRUCTOR_TYPES = new Class[]{Map.class, Map.class};
    private String serviceInterfaceClassName;
    private Map seiPortNameToFactoryMap;
    private Map seiClassNameToFactoryMap;
    private ClassLoader classLoader;
    private FastConstructor serviceConstructor;
    private Callback[] methodInterceptors;
    private Class enhancedServiceClass;

    public AxisServiceReference(String serviceInterfaceClassName, Map seiPortNameToFactoryMap, Map seiClassNameToFactoryMap) {
        this.serviceInterfaceClassName = serviceInterfaceClassName;
        this.seiPortNameToFactoryMap = seiPortNameToFactoryMap;
        this.seiClassNameToFactoryMap = seiClassNameToFactoryMap;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object getObject() throws NamingException {
        Object serviceInstance = this.createServiceInterfaceProxy(this.serviceInterfaceClassName, this.seiPortNameToFactoryMap, this.seiClassNameToFactoryMap, this.classLoader);
        return serviceInstance;
    }

    private Object createServiceInterfaceProxy(String serviceInterfaceClassName, Map seiPortNameToFactoryMap, Map seiClassNameToFactoryMap, ClassLoader classLoader) throws NamingException {
        boolean initialize;
        boolean bl = initialize = this.serviceConstructor == null;
        if (initialize) {
            Class<?> serviceInterface;
            try {
                serviceInterface = classLoader.loadClass(serviceInterfaceClassName);
            }
            catch (ClassNotFoundException e) {
                throw (NamingException)new NamingException("Could not load service interface class " + serviceInterfaceClassName).initCause(e);
            }
            ServiceMethodInterceptor callback = new ServiceMethodInterceptor(seiPortNameToFactoryMap);
            this.methodInterceptors = new Callback[]{NoOp.INSTANCE, callback};
            Enhancer enhancer = new Enhancer();
            enhancer.setClassLoader(classLoader);
            enhancer.setSuperclass(ServiceImpl.class);
            enhancer.setInterfaces(new Class[]{serviceInterface});
            enhancer.setCallbackFilter((CallbackFilter)new NoOverrideCallbackFilter(Service.class));
            enhancer.setCallbackTypes(new Class[]{NoOp.class, MethodInterceptor.class});
            enhancer.setUseFactory(false);
            enhancer.setUseCache(false);
            this.enhancedServiceClass = enhancer.createClass();
            this.serviceConstructor = FastClass.create((Class)this.enhancedServiceClass).getConstructor(SERVICE_CONSTRUCTOR_TYPES);
        }
        Enhancer.registerCallbacks((Class)this.enhancedServiceClass, (Callback[])this.methodInterceptors);
        Object[] arguments = new Object[]{seiPortNameToFactoryMap, seiClassNameToFactoryMap};
        Object serviceInstance = null;
        try {
            serviceInstance = this.serviceConstructor.newInstance(arguments);
        }
        catch (InvocationTargetException e) {
            throw (NamingException)new NamingException("Could not construct service instance").initCause(e.getTargetException());
        }
        if (initialize) {
            for (SeiFactoryImpl seiFactory : seiPortNameToFactoryMap.values()) {
                try {
                    seiFactory.initialize(serviceInstance, classLoader);
                }
                catch (ClassNotFoundException e) {
                    throw (NamingException)new NamingException("Could not load service interface class; " + e.getMessage()).initCause(e);
                }
            }
        }
        return serviceInstance;
    }
}

