/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.server.ServerRuntimeException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CommonsSchemaLoader {
    private static final Log log = LogFactory.getLog(CommonsSchemaLoader.class);
    private final URI wsdlUri;
    private final JarFile moduleFile;
    private final XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();

    public CommonsSchemaLoader(URI wsdlUri, JarFile moduleFile) {
        this.wsdlUri = wsdlUri;
        this.moduleFile = moduleFile;
    }

    public XmlSchemaCollection loadSchema() throws OpenEJBException {
        Definition definition = this.readWsdl(this.wsdlUri);
        this.addImportsFromDefinition(definition);
        return this.xmlSchemaCollection;
    }

    private void addImportsFromDefinition(Definition definition) throws OpenEJBException {
        Map imports;
        Types types = definition.getTypes();
        if (types != null) {
            for (Object extensibilityElement : types.getExtensibilityElements()) {
                Schema unknownExtensibilityElement;
                if (extensibilityElement instanceof Schema) {
                    unknownExtensibilityElement = (Schema)extensibilityElement;
                    QName elementType = unknownExtensibilityElement.getElementType();
                    if (!new QName("http://www.w3.org/2001/XMLSchema", "schema").equals(elementType)) continue;
                    Element element = unknownExtensibilityElement.getElement();
                    this.xmlSchemaCollection.read(element);
                    continue;
                }
                if (!(extensibilityElement instanceof UnknownExtensibilityElement)) continue;
                unknownExtensibilityElement = (UnknownExtensibilityElement)extensibilityElement;
                Element element = unknownExtensibilityElement.getElement();
                String elementNamespace = element.getNamespaceURI();
                String elementLocalName = element.getNodeName();
                if (!"http://www.w3.org/2001/XMLSchema".equals(elementNamespace) || !"schema".equals(elementLocalName)) continue;
                this.xmlSchemaCollection.read(element);
            }
        }
        if ((imports = definition.getImports()) != null) {
            for (Map.Entry entry : imports.entrySet()) {
                String namespaceURI = (String)entry.getKey();
                List importList = (List)entry.getValue();
                for (Import anImport : importList) {
                    Definition importedDef = anImport.getDefinition();
                    if (importedDef != null) {
                        this.addImportsFromDefinition(importedDef);
                        continue;
                    }
                    log.warn((Object)("Missing definition in import for namespace " + namespaceURI));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition readWsdl(URI wsdlURI) throws OpenEJBException {
        Definition definition;
        WSDLFactory wsdlFactory;
        try {
            wsdlFactory = WSDLFactory.newInstance();
        }
        catch (WSDLException e) {
            throw new OpenEJBException("Could not create WSDLFactory", (Throwable)e);
        }
        WSDLReader wsdlReaderNoImport = wsdlFactory.newWSDLReader();
        wsdlReaderNoImport.setFeature("javax.wsdl.importDocuments", false);
        PopulatedExtensionRegistry extensionRegistry = new PopulatedExtensionRegistry();
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_1999, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_1999, extensionRegistry.getDefaultSerializer());
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2000, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2000, extensionRegistry.getDefaultSerializer());
        extensionRegistry.mapExtensionTypes(Types.class, SchemaConstants.Q_ELEM_XSD_2001, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, SchemaConstants.Q_ELEM_XSD_2001, extensionRegistry.getDefaultSerializer());
        wsdlReaderNoImport.setExtensionRegistry((ExtensionRegistry)extensionRegistry);
        JarWSDLLocator wsdlLocator = new JarWSDLLocator(wsdlURI);
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                definition = wsdlReader.readWSDL((WSDLLocator)wsdlLocator);
            }
            catch (WSDLException e) {
                throw new OpenEJBException("Failed to read wsdl document", (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new OpenEJBException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            thread.setContextClassLoader(oldCl);
        }
        return definition;
    }

    class JarWSDLLocator
    implements WSDLLocator {
        private final List<InputStream> streams = new ArrayList<InputStream>();
        private final URI wsdlURI;
        private URI latestImportURI;

        public JarWSDLLocator(URI wsdlURI) {
            this.wsdlURI = wsdlURI;
        }

        public InputSource getBaseInputSource() {
            InputStream wsdlInputStream;
            ZipEntry entry = CommonsSchemaLoader.this.moduleFile.getEntry(this.wsdlURI.toString());
            if (entry == null) {
                throw new ServerRuntimeException("The webservices.xml file points to a non-existant WSDL file " + this.wsdlURI.toString());
            }
            try {
                wsdlInputStream = CommonsSchemaLoader.this.moduleFile.getInputStream(entry);
                this.streams.add(wsdlInputStream);
            }
            catch (Exception e) {
                throw new ServerRuntimeException("Could not open stream to wsdl file", (Throwable)e);
            }
            return new InputSource(wsdlInputStream);
        }

        public String getBaseURI() {
            return this.wsdlURI.toString();
        }

        public InputSource getImportInputSource(String parentLocation, String relativeLocation) {
            InputStream importInputStream;
            URI parentURI = URI.create(parentLocation);
            this.latestImportURI = parentURI.resolve(relativeLocation);
            try {
                ZipEntry entry = CommonsSchemaLoader.this.moduleFile.getEntry(this.latestImportURI.toString());
                importInputStream = CommonsSchemaLoader.this.moduleFile.getInputStream(entry);
                this.streams.add(importInputStream);
            }
            catch (Exception e) {
                throw new ServerRuntimeException("Could not open stream to import file", (Throwable)e);
            }
            InputSource inputSource = new InputSource(importInputStream);
            inputSource.setSystemId(this.getLatestImportURI());
            return inputSource;
        }

        public String getLatestImportURI() {
            return this.latestImportURI.toString();
        }

        public void close() {
            for (InputStream inputStream : this.streams) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.streams.clear();
        }
    }
}

