/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis.assembler;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.PackageMapping;
import org.apache.openejb.server.axis.assembler.JaxRpcFieldInfo;
import org.apache.openejb.server.axis.assembler.JaxRpcTypeInfo;
import org.apache.openejb.server.axis.assembler.XmlElementInfo;
import org.apache.openejb.server.axis.assembler.XmlSchemaInfo;
import org.apache.openejb.server.axis.assembler.XmlTypeInfo;

public class LightweightTypeInfoBuilder {
    private final JavaWsdlMapping mapping;
    private final XmlSchemaInfo schemaInfo;
    private final ClassLoader classLoader;

    public LightweightTypeInfoBuilder(JavaWsdlMapping mapping, XmlSchemaInfo schemaInfo, ClassLoader classLoader) {
        this.mapping = mapping;
        this.classLoader = classLoader;
        this.schemaInfo = schemaInfo;
    }

    public List<JaxRpcTypeInfo> buildTypeInfo() throws OpenEJBException {
        ArrayList<JaxRpcTypeInfo> typeInfoList = new ArrayList<JaxRpcTypeInfo>();
        for (XmlTypeInfo xmlTypeInfo : this.schemaInfo.types.values()) {
            if (xmlTypeInfo.anonymous) continue;
            QName typeQName = xmlTypeInfo.qname;
            Class clazz = this.loadClass(typeQName, this.mapping);
            JaxRpcTypeInfo.SerializerType serializerType = JaxRpcTypeInfo.SerializerType.OTHER;
            if (clazz.isArray()) {
                serializerType = JaxRpcTypeInfo.SerializerType.ARRAY;
            }
            JaxRpcTypeInfo typeInfo = new JaxRpcTypeInfo();
            typeInfo.qname = typeQName;
            typeInfo.javaType = clazz.getName();
            typeInfo.serializerType = serializerType;
            typeInfo.simpleBaseType = xmlTypeInfo.simpleBaseType;
            this.mapFields(clazz, xmlTypeInfo, typeInfo);
            typeInfoList.add(typeInfo);
        }
        return typeInfoList;
    }

    private void mapFields(Class javaClass, XmlTypeInfo xmlTypeInfo, JaxRpcTypeInfo typeInfo) throws OpenEJBException {
        HashMap propertyToClass = new HashMap();
        try {
            for (PropertyDescriptor descriptor : Introspector.getBeanInfo(javaClass).getPropertyDescriptors()) {
                propertyToClass.put(descriptor.getName(), descriptor.getPropertyType());
            }
        }
        catch (IntrospectionException e) {
            throw new OpenEJBException("Class " + javaClass + " is not a valid javabean", (Throwable)e);
        }
        for (XmlElementInfo nestedElement : xmlTypeInfo.elements.values()) {
            String fieldName = nestedElement.qname.getLocalPart();
            Class javaType = (Class)propertyToClass.get(fieldName);
            if (javaType == null) {
                throw new OpenEJBException("Field " + fieldName + " is not defined by class " + javaClass.getName());
            }
            JaxRpcFieldInfo fieldInfo = new JaxRpcFieldInfo();
            fieldInfo.name = fieldName;
            fieldInfo.isNillable = nestedElement.nillable;
            fieldInfo.xmlName = nestedElement.qname;
            fieldInfo.xmlType = nestedElement.xmlType;
            if (javaType.isArray()) {
                fieldInfo.minOccurs = nestedElement.minOccurs;
                fieldInfo.maxOccurs = nestedElement.maxOccurs;
            }
            typeInfo.fields.add(fieldInfo);
        }
    }

    private Class loadClass(QName typeQName, JavaWsdlMapping mapping) throws OpenEJBException {
        String namespace = typeQName.getNamespaceURI();
        PackageMapping packageMapping = (PackageMapping)mapping.getPackageMappingMap().get(namespace);
        if (packageMapping == null) {
            throw new OpenEJBException("Namespace " + namespace + " was not mapped in jaxrpc mapping file");
        }
        String packageName = packageMapping.getPackageType();
        String className = packageName + "." + typeQName.getLocalPart();
        try {
            Class<?> clazz = Class.forName(className, false, this.classLoader);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new OpenEJBException("Could not load java type " + className, (Throwable)e);
        }
    }
}

