/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis2;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import javax.naming.Context;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.axis2.Axis2WsContainer;
import org.apache.openejb.server.axis2.ejb.EjbWsContainer;
import org.apache.openejb.server.axis2.pojo.PojoWsContainer;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.webservices.WsService;

public class Axis2Service
extends WsService {
    private final Map<String, Axis2WsContainer> wsContainers = new TreeMap<String, Axis2WsContainer>();

    public String getName() {
        return "axis2";
    }

    protected HttpListener createEjbWsContainer(URL moduleBaseUrl, PortData port, DeploymentInfo deploymentInfo) throws Exception {
        EjbWsContainer container = new EjbWsContainer(port, deploymentInfo);
        container.start();
        this.wsContainers.put(deploymentInfo.getDeploymentID().toString(), container);
        return container;
    }

    protected void destroyEjbWsContainer(String deploymentId) {
        Axis2WsContainer container = this.wsContainers.remove(deploymentId);
        if (container != null) {
            container.destroy();
        }
    }

    protected HttpListener createPojoWsContainer(URL moduleBaseUrl, PortData port, String serviceId, Class target, Context context, String contextRoot) throws Exception {
        PojoWsContainer container = new PojoWsContainer(port, target, context, contextRoot);
        container.start();
        this.wsContainers.put(serviceId, container);
        return container;
    }

    protected void destroyPojoWsContainer(String serviceId) {
        Axis2WsContainer container = this.wsContainers.remove(serviceId);
        if (container != null) {
            container.destroy();
        }
    }
}

