/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis2;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.ws.handler.PortInfo;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManagerFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportReceiver;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.TransportHeaders;
import org.apache.axis2.transport.http.util.RESTUtil;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.openejb.core.webservices.HandlerResolverImpl;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.axis2.Axis2RequestResponseTransport;
import org.apache.openejb.server.axis2.AxisServiceGenerator;
import org.apache.openejb.server.axis2.HandlerLifecycleManagerFactoryImpl;
import org.apache.openejb.server.axis2.WsdlQueryHandler;
import org.apache.openejb.server.axis2.client.Axis2Config;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Axis2WsContainer
implements HttpListener {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.AXIS2, Axis2WsContainer.class);
    public static final String REQUEST = Axis2WsContainer.class.getName() + "@Request";
    public static final String RESPONSE = Axis2WsContainer.class.getName() + "@Response";
    protected String endpointClassName;
    protected PortData port;
    protected ConfigurationContext configurationContext;
    protected final Class<?> endpointClass;
    protected AxisService service;
    protected WsdlQueryHandler wsdlQueryHandler;
    protected Context context;
    private HandlerResolverImpl handlerResolver;

    public Axis2WsContainer(PortData port, Class<?> endpointClass, Context context) {
        this.endpointClass = endpointClass;
        this.port = port;
        this.context = context;
    }

    public void start() throws Exception {
        Axis2Config.initialize();
        this.configurationContext = ConfigurationContextFactory.createBasicConfigurationContext((String)"META-INF/openejb-axis2.xml");
        AxisServiceGenerator serviceGen = this.createServiceGenerator();
        this.service = this.port.getWsdlUrl() != null ? serviceGen.getServiceFromWSDL(this.port, this.endpointClass) : serviceGen.getServiceFromClass(this.endpointClass);
        this.service.setScope("application");
        this.configurationContext.getAxisConfiguration().addService(this.service);
        this.wsdlQueryHandler = new WsdlQueryHandler(this.service);
        FactoryRegistry.setFactory(HandlerLifecycleManagerFactory.class, (Object)((Object)new HandlerLifecycleManagerFactoryImpl()));
    }

    protected AxisServiceGenerator createServiceGenerator() {
        return new AxisServiceGenerator();
    }

    public void getWsdl(HttpRequest request, HttpResponse response) throws Exception {
        this.doService(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(HttpRequest request, HttpResponse response) throws Exception {
        SaajUniverse universe = new SaajUniverse();
        universe.set(SaajUniverse.AXIS2);
        try {
            this.doService(request, response);
        }
        finally {
            universe.unset();
        }
    }

    protected void doService(HttpRequest request, HttpResponse response) throws Exception {
        block8: {
            if (logger.isDebugEnabled()) {
                logger.debug("Target URI: " + request.getURI());
            }
            MessageContext msgContext = new MessageContext();
            msgContext.setIncomingTransportName("http");
            msgContext.setProperty("REMOTE_ADDR", (Object)request.getRemoteAddr());
            try {
                TransportOutDescription transportOut = this.configurationContext.getAxisConfiguration().getTransportOut("http");
                TransportInDescription transportIn = this.configurationContext.getAxisConfiguration().getTransportIn("http");
                msgContext.setConfigurationContext(this.configurationContext);
                msgContext.setTransportIn(transportIn);
                msgContext.setTransportOut(transportOut);
                msgContext.setServiceGroupContextId(UUIDGenerator.getUUID());
                msgContext.setServerSide(true);
                msgContext.setAxisService(this.service);
                this.doService2(request, response, msgContext);
            }
            catch (Throwable e) {
                String msg = "Exception occurred while trying to invoke service method doService()";
                logger.error(msg, e);
                try {
                    msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
                    msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatusCode(202);
                    } else {
                        response.setStatusCode(500);
                    }
                    AxisEngine.sendFault((MessageContext)faultContext);
                }
                catch (Exception ex) {
                    if (AddressingHelper.isFaultRedirected((MessageContext)msgContext)) {
                        response.setStatusCode(202);
                        break block8;
                    }
                    response.setStatusCode(500);
                    response.setHeader("Content-Type", "text/plain");
                    PrintWriter pw = new PrintWriter(response.getOutputStream());
                    ex.printStackTrace(pw);
                    pw.flush();
                    logger.error(msg, (Throwable)ex);
                }
            }
        }
    }

    protected String getServicePath(String contextRoot) {
        String location = this.port.getLocation();
        if (location != null && location.startsWith(contextRoot)) {
            return location.substring(contextRoot.length());
        }
        return null;
    }

    public static String trimContext(String contextPath) {
        if (contextPath != null) {
            if (contextPath.startsWith("/")) {
                contextPath = contextPath.substring(1);
            }
            if (contextPath.endsWith("/")) {
                contextPath = contextPath.substring(0, contextPath.length() - 1);
            }
        }
        return contextPath;
    }

    public void doService2(HttpRequest request, HttpResponse response, MessageContext msgContext) throws Exception {
        if (request.getMethod() == HttpRequest.Method.GET) {
            this.processGETRequest(request, response, this.service, msgContext);
        } else if (request.getMethod() == HttpRequest.Method.POST) {
            this.processPOSTRequest(request, response, this.service, msgContext);
        } else {
            throw new UnsupportedOperationException("[" + request.getMethod() + " ] method not supported");
        }
        OperationContext operationContext = msgContext.getOperationContext();
        Object contextWritten = null;
        Object isTwoChannel = null;
        if (operationContext != null) {
            contextWritten = operationContext.getProperty("RESPONSE_WRITTEN");
            isTwoChannel = operationContext.getProperty("DIFFERENT_EPR");
        }
        if (contextWritten != null && "true".equals(contextWritten)) {
            if (isTwoChannel != null && "true".equals(isTwoChannel)) {
                response.setStatusCode(202);
                return;
            }
            response.setStatusCode(200);
        } else {
            response.setStatusCode(202);
        }
    }

    public void destroy() {
    }

    protected void processGETRequest(HttpRequest request, HttpResponse response, AxisService service, MessageContext msgContext) throws Exception {
        if (request.getURI().getQuery() != null && (request.getURI().getQuery().startsWith("wsdl") || request.getURI().getQuery().startsWith("xsd"))) {
            if (this.port.getWsdlUrl() != null) {
                URL wsdlURL = this.port.getWsdlUrl();
                this.wsdlQueryHandler.writeResponse(request.getURI().toString(), wsdlURL.toString(), response.getOutputStream());
            } else {
                service.printWSDL(response.getOutputStream());
            }
        } else if (AxisServiceGenerator.isSOAP11(service)) {
            response.setContentType("text/html");
            PrintWriter pw = new PrintWriter(response.getOutputStream());
            pw.write("<html><title>Web Service</title><body>");
            pw.write("Hi, this is '" + service.getName() + "' web service.");
            pw.write("</body></html>");
            pw.flush();
        } else {
            this.setMsgContextProperties(request, response, service, msgContext);
            String contentType = request.getHeader("Content-Type");
            msgContext.setTo(new EndpointReference(request.getURI().toString()));
            msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
            msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
            Handler.InvocationResponse processed = RESTUtil.processURLRequest((MessageContext)msgContext, (OutputStream)response.getOutputStream(), (String)contentType);
            if (!processed.equals(Handler.InvocationResponse.CONTINUE)) {
                response.setStatusCode(200);
                String s = HTTPTransportReceiver.getServicesHTML((ConfigurationContext)this.configurationContext);
                PrintWriter pw = new PrintWriter(response.getOutputStream());
                pw.write(s);
                pw.flush();
            }
        }
    }

    protected void setMsgContextProperties(HttpRequest request, HttpResponse response, AxisService service, MessageContext msgContext) {
        msgContext.setProperty("TRANSPORT_OUT", (Object)response.getOutputStream());
        msgContext.setProperty("OutTransportInfo", (Object)new Axis2TransportInfo(response));
        msgContext.setProperty("RequestResponseTransportControl", (Object)new Axis2RequestResponseTransport(response));
        msgContext.setProperty("TransportInURL", (Object)request.getURI().toString());
        msgContext.setIncomingTransportName("http");
        HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute(HttpRequest.SERVLET_REQUEST);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, (Object)servletRequest);
        HttpServletResponse servletResponse = (HttpServletResponse)request.getAttribute(HttpRequest.SERVLET_RESPONSE);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, (Object)servletResponse);
        ServletContext servletContext = (ServletContext)request.getAttribute(HttpRequest.SERVLET_CONTEXT);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, (Object)servletContext);
        if (servletRequest != null) {
            msgContext.setProperty("TRANSPORT_HEADERS", (Object)new TransportHeaders(servletRequest));
        }
    }

    protected void processPOSTRequest(HttpRequest request, HttpResponse response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType, (String)soapAction, (String)request.getURI().getPath());
    }

    protected void configureHandlers() throws Exception {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(this.service);
        if (desc != null) {
            this.handlerResolver = new HandlerResolverImpl(this.port.getHandlerChains(), this.port.getInjections(), this.context);
            List handlers = this.handlerResolver.getHandlerChain((PortInfo)this.port);
            DescriptionUtils.registerHandlerHeaders((AxisService)desc.getAxisService(), (List)handlers);
        }
    }

    protected void destroyHandlers() {
        if (this.handlerResolver != null) {
            this.handlerResolver.destroyHandlers();
            this.handlerResolver = null;
        }
    }

    public static class Axis2TransportInfo
    implements OutTransportInfo {
        private HttpResponse response;

        public Axis2TransportInfo(HttpResponse response) {
            this.response = response;
        }

        public void setContentType(String contentType) {
            this.response.setHeader("Content-Type", contentType);
        }
    }
}

