/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderComposite;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;
import org.apache.axis2.jaxws.description.builder.converter.JavaClassToDBCConverter;
import org.apache.axis2.jaxws.server.JAXWSMessageReceiver;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.openejb.core.webservices.JaxWsUtils;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.axis2.util.SimpleWsdlLocator;
import org.apache.ws.commons.schema.utils.NamespaceMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisServiceGenerator {
    private MessageReceiver messageReceiver = new JAXWSMessageReceiver();

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    public AxisService getServiceFromClass(Class endpointClass) throws Exception {
        ServiceDescription serviceDescription = DescriptionFactory.createServiceDescription((Class)endpointClass);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        AxisService service = edArray[0].getAxisService();
        if (service.getNameSpacesMap() == null) {
            NamespaceMap map = new NamespaceMap();
            map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
            map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            service.setNameSpacesMap(map);
        }
        String endpointClassName = endpointClass.getName();
        ClassLoader classLoader = endpointClass.getClassLoader();
        service.addParameter(new Parameter("ServiceClass", (Object)endpointClassName));
        service.setClassLoader(classLoader);
        Iterator opIterator = service.getOperations();
        while (opIterator.hasNext()) {
            AxisOperation operation = (AxisOperation)opIterator.next();
            operation.setMessageReceiver(this.messageReceiver);
        }
        Parameter serviceDescriptionParam = new Parameter("org.apache.axis2.jaxws.description.EndpointDescription", (Object)edArray[0]);
        service.addParameter(serviceDescriptionParam);
        return service;
    }

    public AxisService getServiceFromWSDL(PortData portData, Class endpointClass) throws Exception {
        BindingTypeAnnot bindingAnnot;
        Definition wsdlDefinition;
        Service wsdlService;
        QName portQName;
        if (portData.getWsdlUrl() == null) {
            throw new Exception("WSDL file is required.");
        }
        String endpointClassName = endpointClass.getName();
        ClassLoader classLoader = endpointClass.getClassLoader();
        QName serviceQName = portData.getWsdlService();
        if (serviceQName == null) {
            serviceQName = JaxWsUtils.getServiceQName((Class)endpointClass);
        }
        if ((portQName = portData.getWsdlPort()) == null) {
            portQName = JaxWsUtils.getPortQName((Class)endpointClass);
        }
        if ((wsdlService = (wsdlDefinition = this.readWSDL(portData.getWsdlUrl())).getService(serviceQName)) == null) {
            throw new Exception("Service '" + serviceQName + "' not found in WSDL");
        }
        Port port = wsdlService.getPort(portQName.getLocalPart());
        if (port == null) {
            throw new Exception("Port '" + portQName.getLocalPart() + "' not found in WSDL");
        }
        Binding binding = port.getBinding();
        List extElements = binding.getExtensibilityElements();
        Iterator extElementsIterator = extElements.iterator();
        String bindingS = "http://schemas.xmlsoap.org/wsdl/soap/http";
        while (extElementsIterator.hasNext()) {
            SOAPBinding sp;
            Object o = extElementsIterator.next();
            if (o instanceof SOAPBinding) {
                sp = (SOAPBinding)o;
                if (!sp.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap/")) continue;
                bindingS = "http://schemas.xmlsoap.org/wsdl/soap/http";
                continue;
            }
            if (o instanceof SOAP12Binding) {
                sp = (SOAP12Binding)o;
                if (!sp.getElementType().getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/")) continue;
                bindingS = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
                continue;
            }
            if (!(o instanceof HTTPBinding) || !(sp = (HTTPBinding)o).getElementType().getNamespaceURI().equals("http://www.w3.org/2004/08/wsdl/http")) continue;
            bindingS = "http://www.w3.org/2004/08/wsdl/http";
        }
        Class<?> endPointClass = classLoader.loadClass(endpointClassName);
        JavaClassToDBCConverter converter = new JavaClassToDBCConverter(endPointClass);
        HashMap dbcMap = converter.produceDBC();
        DescriptionBuilderComposite dbc = (DescriptionBuilderComposite)dbcMap.get(endpointClassName);
        dbc.setClassLoader(classLoader);
        dbc.setWsdlDefinition(wsdlDefinition);
        dbc.setClassName(endpointClassName);
        dbc.setCustomWsdlGenerator((WsdlGenerator)new WSDLGeneratorImpl(wsdlDefinition));
        if (dbc.getWebServiceAnnot() != null) {
            WebServiceAnnot serviceAnnot = dbc.getWebServiceAnnot();
            serviceAnnot.setPortName(portQName.getLocalPart());
            serviceAnnot.setServiceName(serviceQName.getLocalPart());
            serviceAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
            if (dbc.getBindingTypeAnnot() != null && bindingS != null && !bindingS.equals("")) {
                bindingAnnot = dbc.getBindingTypeAnnot();
                bindingAnnot.setValue(bindingS);
            }
        } else if (dbc.getWebServiceProviderAnnot() != null) {
            WebServiceProviderAnnot serviceProviderAnnot = dbc.getWebServiceProviderAnnot();
            serviceProviderAnnot.setPortName(portQName.getLocalPart());
            serviceProviderAnnot.setServiceName(serviceQName.getLocalPart());
            serviceProviderAnnot.setTargetNamespace(serviceQName.getNamespaceURI());
            if (dbc.getBindingTypeAnnot() != null && bindingS != null && !bindingS.equals("")) {
                bindingAnnot = dbc.getBindingTypeAnnot();
                bindingAnnot.setValue(bindingS);
            }
        }
        AxisService service = this.getService(dbcMap);
        service.setName(serviceQName.getLocalPart());
        service.setEndpointName(portQName.getLocalPart());
        Iterator opIterator = service.getOperations();
        while (opIterator.hasNext()) {
            AxisOperation operation = (AxisOperation)opIterator.next();
            operation.setMessageReceiver(this.messageReceiver);
            String MEP = operation.getMessageExchangePattern();
            if (WSDLUtil.isOutputPresentForMEP((String)MEP)) continue;
            List mdcList = dbc.getMethodDescriptionComposite(operation.getName().toString());
            for (MethodDescriptionComposite mdc : mdcList) {
                mdc.setOneWayAnnot(true);
            }
        }
        return service;
    }

    private AxisService getService(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        return this.getEndpointDescription(dbcMap).getAxisService();
    }

    private EndpointDescription getEndpointDescription(HashMap<String, DescriptionBuilderComposite> dbcMap) {
        List serviceDescList = DescriptionFactory.createServiceDescriptionFromDBCMap(dbcMap);
        if (serviceDescList == null || serviceDescList.isEmpty()) {
            throw new RuntimeException("No service");
        }
        ServiceDescription serviceDescription = (ServiceDescription)serviceDescList.get(0);
        EndpointDescription[] edArray = serviceDescription.getEndpointDescriptions();
        if (edArray == null || edArray.length == 0) {
            throw new RuntimeException("No endpoint");
        }
        return edArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Definition readWSDL(URL wsdlUrl) throws IOException, WSDLException {
        Definition wsdlDefinition = null;
        InputStream wsdlStream = null;
        try {
            wsdlStream = wsdlUrl.openStream();
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            reader.setFeature("javax.wsdl.verbose", false);
            SimpleWsdlLocator wsdlLocator = new SimpleWsdlLocator(wsdlUrl.toString());
            wsdlDefinition = reader.readWSDL((WSDLLocator)wsdlLocator);
        }
        finally {
            if (wsdlStream != null) {
                wsdlStream.close();
            }
        }
        return wsdlDefinition;
    }

    public static EndpointDescription getEndpointDescription(AxisService service) {
        Parameter param = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
        return param == null ? null : (EndpointDescription)param.getValue();
    }

    public static boolean isSOAP11(AxisService service) {
        EndpointDescription desc = AxisServiceGenerator.getEndpointDescription(service);
        return "http://schemas.xmlsoap.org/wsdl/soap/http".equals(desc.getBindingType()) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(desc.getBindingType());
    }

    private static class WSDLGeneratorImpl
    implements WsdlGenerator {
        private Definition def;

        public WSDLGeneratorImpl(Definition def) {
            this.def = def;
        }

        public WsdlComposite generateWsdl(String implClass, String bindingType) throws WebServiceException {
            WsdlComposite composite = new WsdlComposite();
            composite.setWsdlFileName(implClass);
            HashMap<String, Definition> testMap = new HashMap<String, Definition>();
            testMap.put(composite.getWsdlFileName(), this.def);
            composite.setWsdlDefinition(testMap);
            return composite;
        }
    }
}

