/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis2.pojo;

import java.io.InputStream;
import java.io.OutputStream;
import javax.naming.Context;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.factory.EndpointLifecycleManagerFactory;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.core.webservices.PortData;
import org.apache.openejb.server.axis2.Axis2WsContainer;
import org.apache.openejb.server.axis2.pojo.PojoEndpointLifecycleManagerFactory;
import org.apache.openejb.server.axis2.pojo.PojoWsContext;
import org.apache.openejb.server.httpd.HttpRequest;
import org.apache.openejb.server.httpd.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoWsContainer
extends Axis2WsContainer {
    private Object endpointInstance;
    private String contextRoot;
    private InjectionProcessor<Object> injectionProcessor;

    public PojoWsContainer(PortData port, Class<?> endpointClass, Context context, String contextRoot) {
        super(port, endpointClass, context);
        this.contextRoot = contextRoot;
    }

    @Override
    public void start() throws Exception {
        super.start();
        FactoryRegistry.setFactory(EndpointLifecycleManagerFactory.class, (Object)((Object)new PojoEndpointLifecycleManagerFactory()));
        String servicePath = PojoWsContainer.trimContext(this.getServicePath(this.contextRoot));
        this.configurationContext.setServicePath(servicePath);
        String rootContext = PojoWsContainer.trimContext(this.contextRoot);
        this.configurationContext.setContextRoot(rootContext);
        try {
            this.injectionProcessor = new InjectionProcessor(this.endpointClass, this.port.getInjections(), null, null, InjectionProcessor.unwrap((Context)this.context));
            this.injectionProcessor.createInstance();
            this.injectionProcessor.postConstruct();
            this.endpointInstance = this.injectionProcessor.getInstance();
        }
        catch (Exception e) {
            throw new WebServiceException("Service resource injection failed", (Throwable)e);
        }
        try {
            this.configureHandlers();
        }
        catch (Exception e) {
            throw new WebServiceException("Error configuring handlers", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPOSTRequest(HttpRequest request, HttpResponse response, AxisService service, MessageContext msgContext) throws Exception {
        String contentType = request.getHeader("Content-Type");
        String soapAction = request.getHeader("SOAPAction");
        if (soapAction == null) {
            soapAction = "\"\"";
        }
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        configurationContext.fillServiceContextAndServiceGroupContext(msgContext);
        this.setMsgContextProperties(request, response, service, msgContext);
        ServiceContext serviceContext = msgContext.getServiceContext();
        serviceContext.setProperty("serviceObject", this.endpointInstance);
        try {
            HTTPTransportUtils.processHTTPPostRequest((MessageContext)msgContext, (InputStream)request.getInputStream(), (OutputStream)response.getOutputStream(), (String)contentType, (String)soapAction, (String)request.getURI().getPath());
        }
        finally {
            PojoWsContext.clear();
        }
    }

    @Override
    public void destroy() {
        this.destroyHandlers();
        if (this.injectionProcessor != null) {
            this.injectionProcessor.preDestroy();
        }
        super.destroy();
    }
}

