/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.axis2.util;

import java.io.IOException;
import javax.wsdl.xml.WSDLLocator;
import org.apache.openejb.server.axis2.util.SimpleUriResolver;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.xml.sax.InputSource;

public class SimpleWsdlLocator
implements WSDLLocator {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.AXIS2, SimpleWsdlLocator.class);
    private String baseURI;
    private String lastImportLocation;
    private SimpleUriResolver resolver;

    public SimpleWsdlLocator(String baseURI) {
        this.baseURI = baseURI;
        this.resolver = new SimpleUriResolver();
    }

    public InputSource getBaseInputSource() {
        return this.resolve("", this.baseURI);
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public InputSource getImportInputSource(String parentLocation, String importLocation) {
        return this.resolve(parentLocation, importLocation);
    }

    protected InputSource resolve(String parentLocation, String importLocation) {
        if (logger.isDebugEnabled()) {
            logger.debug("Resolving '" + importLocation + "' relative to '" + parentLocation + "'");
        }
        try {
            this.resolver.resolve(parentLocation, importLocation);
            if (this.resolver.isResolved()) {
                this.lastImportLocation = this.resolver.getURI().toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("Resolved location '" + this.lastImportLocation + "'");
                }
                return new InputSource(this.resolver.getInputStream());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getLatestImportURI() {
        return this.lastImportLocation;
    }

    public void close() {
    }
}

