/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class TomcatEjbFactory
implements ObjectFactory {
    private static final String OPENEJB_PREFIX = "openejb.";
    private static final String JAVA_PREFIX = "java.";
    private static final String OPENEJB_EJB_LINK = "openejb.ejb-link";
    private static final int OPENEJB_PREFIX_LENGTH = "openejb.".length();

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object beanObj = null;
        Class<?> ejbRefClass = Class.forName("org.apache.naming.EjbRef");
        if (ejbRefClass.isAssignableFrom(obj.getClass())) {
            Properties env = new Properties();
            String bean = null;
            Reference ref = (Reference)obj;
            Enumeration<RefAddr> addresses = ref.getAll();
            while (addresses.hasMoreElements()) {
                RefAddr refAddr = addresses.nextElement();
                String addrType = refAddr.getType();
                if (!addrType.startsWith(OPENEJB_PREFIX)) continue;
                String value = refAddr.getContent().toString();
                if (addrType.equals(OPENEJB_EJB_LINK)) {
                    bean = value;
                    continue;
                }
                String key = addrType.substring(OPENEJB_PREFIX_LENGTH);
                key = JAVA_PREFIX + key;
                env.put(key, value);
            }
            if (bean != null) {
                beanObj = new InitialContext(env).lookup(bean);
            }
        }
        return beanObj;
    }
}

