/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cli.command;

import java.io.File;
import org.apache.openejb.server.cli.command.Command;
import org.apache.openejb.server.cli.command.PathCommand;

@Command(name="ls", usage="ls [<path>]", description="list files (in tomee directories only)")
public class LsCommand
extends PathCommand {
    @Override
    public void execute(String cmd) {
        File file;
        try {
            file = this.resolve(cmd);
        }
        catch (IllegalArgumentException iae) {
            this.streamManager.writeErr(iae.getMessage());
            return;
        }
        if (file.isDirectory() && file.exists()) {
            this.list(file.getAbsolutePath(), file);
        } else if (file.exists()) {
            this.streamManager.writeOut("file " + file.getPath() + " exists");
        } else {
            this.streamManager.writeOut("file " + file.getPath() + " doesn't exist");
        }
    }

    private void list(String base, File dir) {
        File[] files;
        String removed = base;
        if (!base.endsWith("/")) {
            removed = removed + "/";
        }
        if ((files = dir.listFiles()) != null) {
            for (File file : files) {
                this.streamManager.writeOut(LsCommand.type(file) + " " + file.getAbsolutePath().replace(removed, ""));
            }
        }
    }

    private static String type(File file) {
        if (file.isDirectory()) {
            return "D";
        }
        return "F";
    }
}

