/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Constructor;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.MessageListener;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.JndiNameInfo;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ivm.naming.BusinessLocalReference;
import org.apache.openejb.core.ivm.naming.BusinessRemoteReference;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.ObjectReference;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.StringTemplate;
import org.apache.openejb.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, JndiBuilder.class.getPackage().getName());
    private final Context context;
    private static final String JNDINAME_STRATEGY_CLASS = "openejb.jndiname.strategy.class";
    private static final String JNDINAME_FAILONCOLLISION = "openejb.jndiname.failoncollision";
    private final boolean failOnCollision;

    public JndiBuilder(Context context) {
        this.context = context;
        this.failOnCollision = SystemInstance.get().getOptions().get(JNDINAME_FAILONCOLLISION, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(EjbJarInfo ejbJar, HashMap<String, DeploymentInfo> deployments) {
        JndiNameStrategy strategy = JndiBuilder.createStrategy(ejbJar, deployments);
        for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
            DeploymentInfo deploymentInfo = deployments.get(beanInfo.ejbDeploymentId);
            strategy.begin(deploymentInfo);
            try {
                this.bind(ejbJar, deploymentInfo, beanInfo, strategy);
            }
            finally {
                strategy.end();
            }
        }
    }

    public static JndiNameStrategy createStrategy(EjbJarInfo ejbJar, Map<String, DeploymentInfo> deployments) {
        Options options = new Options(ejbJar.properties, SystemInstance.get().getOptions());
        Class strategyClass = options.get(JNDINAME_STRATEGY_CLASS, TemplatedStrategy.class);
        String strategyClassName = strategyClass.getName();
        try {
            try {
                Constructor constructor = strategyClass.getConstructor(EjbJarInfo.class, Map.class);
                return (JndiNameStrategy)constructor.newInstance(ejbJar, deployments);
            }
            catch (NoSuchMethodException e) {
                Constructor constructor = strategyClass.getConstructor(new Class[0]);
                return (JndiNameStrategy)constructor.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate JndiNameStrategy: " + strategyClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access JndiNameStrategy: " + strategyClassName, e);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not create JndiNameStrategy: " + strategyClassName, t);
        }
    }

    public void bind(EjbJarInfo ejbJarInfo, DeploymentInfo deploymentInfo, EnterpriseBeanInfo beanInfo, JndiNameStrategy strategy) {
        String internalName;
        org.apache.openejb.core.ivm.naming.Reference ref;
        Object home;
        List<Class> interfaces;
        Class beanClass;
        String name;
        ObjectReference ref2;
        CoreDeploymentInfo deployment = (CoreDeploymentInfo)deploymentInfo;
        Bindings bindings = new Bindings();
        deployment.set(Bindings.class, bindings);
        Object id = deployment.getDeploymentID();
        try {
            Class homeInterface = deployment.getHomeInterface();
            if (homeInterface != null) {
                ref2 = new ObjectReference(deployment.getEJBHome());
                name = strategy.getName(homeInterface, JndiNameStrategy.Interface.REMOTE_HOME);
                this.bind("openejb/local/" + name, (Reference)((Object)ref2), bindings, beanInfo, homeInterface);
                this.bind("openejb/remote/" + name, (Reference)((Object)ref2), bindings, beanInfo, homeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), deployment.getRemoteInterface().getName());
                this.bind(name, (Reference)((Object)ref2), bindings, beanInfo, homeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), deployment.getRemoteInterface().getName(), InterfaceType.EJB_OBJECT);
                this.bind(name, (Reference)((Object)ref2), bindings, beanInfo, homeInterface);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind remote home interface for deployment " + id, e);
        }
        try {
            Class localHomeInterface = deployment.getLocalHomeInterface();
            if (localHomeInterface != null) {
                ref2 = new ObjectReference(deployment.getEJBLocalHome());
                name = strategy.getName(deploymentInfo.getLocalHomeInterface(), JndiNameStrategy.Interface.LOCAL_HOME);
                this.bind("openejb/local/" + name, (Reference)((Object)ref2), bindings, beanInfo, localHomeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), deployment.getLocalInterface().getName());
                this.bind(name, (Reference)((Object)ref2), bindings, beanInfo, localHomeInterface);
                name = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), deployment.getLocalInterface().getName(), InterfaceType.EJB_LOCAL);
                this.bind(name, (Reference)((Object)ref2), bindings, beanInfo, localHomeInterface);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind local home interface for deployment " + id, e);
        }
        try {
            List<Class> localInterfaces = deployment.getBusinessLocalInterfaces();
            beanClass = deployment.getBeanClass();
            for (Class interfce : deployment.getBusinessLocalInterfaces()) {
                interfaces = ProxyInterfaceResolver.getInterfaces(beanClass, interfce, localInterfaces);
                home = deployment.getBusinessLocalHome(interfaces);
                ref = new BusinessLocalReference((DeploymentInfo.BusinessLocalHome)home);
                this.optionalBind(bindings, (Reference)((Object)ref), "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), interfce.getName()));
                internalName = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), interfce.getName(), InterfaceType.BUSINESS_LOCAL);
                this.bind(internalName, (Reference)((Object)ref), bindings, beanInfo, interfce);
                String externalName = "openejb/local/" + strategy.getName(interfce, JndiNameStrategy.Interface.BUSINESS_LOCAL);
                this.bind(externalName, (Reference)((Object)ref), bindings, beanInfo, interfce);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind business local interface for deployment " + id, e);
        }
        try {
            List<Class> remoteInterfaces = deployment.getBusinessRemoteInterfaces();
            beanClass = deployment.getBeanClass();
            for (Class interfce : deployment.getBusinessRemoteInterfaces()) {
                interfaces = ProxyInterfaceResolver.getInterfaces(beanClass, interfce, remoteInterfaces);
                home = deployment.getBusinessRemoteHome(interfaces);
                ref = new BusinessRemoteReference((DeploymentInfo.BusinessRemoteHome)home);
                this.optionalBind(bindings, (Reference)((Object)ref), "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), interfce.getName(), null));
                internalName = "openejb/Deployment/" + JndiBuilder.format(deployment.getDeploymentID(), interfce.getName(), InterfaceType.BUSINESS_REMOTE);
                this.bind(internalName, (Reference)((Object)ref), bindings, beanInfo, interfce);
                String name2 = strategy.getName(interfce, JndiNameStrategy.Interface.BUSINESS_REMOTE);
                this.bind("openejb/local/" + name2, (Reference)((Object)ref), bindings, beanInfo, interfce);
                this.bind("openejb/remote/" + name2, (Reference)((Object)ref), bindings, beanInfo, interfce);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind business remote deployment in jndi.", e);
        }
        try {
            if (MessageListener.class.equals((Object)deployment.getMdbInterface())) {
                String destinationId = deployment.getDestinationId();
                String jndiName = "openejb/Resource/" + destinationId;
                IntraVmJndiReference reference = new IntraVmJndiReference(jndiName);
                String deploymentId = deployment.getDeploymentID().toString();
                this.bind("openejb/local/" + deploymentId, (Reference)((Object)reference), bindings, beanInfo, MessageListener.class);
                this.bind("openejb/remote/" + deploymentId, (Reference)((Object)reference), bindings, beanInfo, MessageListener.class);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to bind mdb destination in jndi.", e);
        }
    }

    private void optionalBind(Bindings bindings, Reference ref, String name) throws NamingException {
        try {
            this.context.bind(name, (Object)ref);
            bindings.add(name);
        }
        catch (NamingException okIfBindFails) {
            // empty catch block
        }
    }

    public static String format(Object deploymentId, String interfaceClassName) {
        return JndiBuilder.format((String)deploymentId, interfaceClassName, null);
    }

    public static String format(Object deploymentId, String interfaceClassName, InterfaceType interfaceType) {
        return JndiBuilder.format((String)deploymentId, interfaceClassName, interfaceType);
    }

    public static String format(String deploymentId, String interfaceClassName, InterfaceType interfaceType) {
        return deploymentId + "/" + interfaceClassName + (interfaceType == null ? "" : "!" + interfaceType.getSpecName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bind(String name, Reference ref, Bindings bindings, EnterpriseBeanInfo beanInfo, Class intrface) throws NamingException {
        if (name.startsWith("openejb/local/") || name.startsWith("openejb/remote/")) {
            String externalName = name.replaceFirst("openejb/[^/]+/", "");
            if (bindings.contains(name)) {
                if (!name.startsWith("openejb/local/")) return;
                logger.debug("Duplicate: Jndi(name=" + externalName + ")");
                return;
            }
            try {
                this.context.bind(name, (Object)ref);
                bindings.add(name);
                if (beanInfo.jndiNames.contains(externalName)) return;
                beanInfo.jndiNames.add(externalName);
                JndiNameInfo nameInfo = new JndiNameInfo();
                nameInfo.intrface = intrface.getName();
                nameInfo.name = externalName;
                beanInfo.jndiNamess.add(nameInfo);
                logger.info("Jndi(name=" + externalName + ") --> Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ")");
                return;
            }
            catch (NameAlreadyBoundException e) {
                DeploymentInfo deployment = this.findNameOwner(name);
                if (deployment != null) {
                    logger.error("Jndi(name=" + externalName + ") cannot be bound to Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ").  Name already taken by Ejb(deployment-id=" + deployment.getDeploymentID() + ")");
                } else {
                    logger.error("Jndi(name=" + externalName + ") cannot be bound to Ejb(deployment-id=" + beanInfo.ejbDeploymentId + ").  Name already taken by another object in the system.");
                }
                if (!this.failOnCollision) return;
                throw new NameAlreadyBoundException(externalName);
            }
        }
        try {
            this.context.bind(name, (Object)ref);
            bindings.add(name);
            return;
        }
        catch (NameAlreadyBoundException e) {
            logger.error("Jndi name could not be bound; it may be taken by another ejb.  Jndi(name=" + name + ")");
            throw new NameAlreadyBoundException(name);
        }
    }

    private DeploymentInfo findNameOwner(String name) {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (DeploymentInfo deploymentInfo : containerSystem.deployments()) {
            Bindings bindings = deploymentInfo.get(Bindings.class);
            if (bindings == null || !bindings.getBindings().contains(name)) continue;
            return deploymentInfo;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoteInterfaceComparator
    implements Comparator<Class> {
        @Override
        public int compare(Class a, Class b) {
            boolean bIsRmote;
            boolean aIsRmote = Remote.class.isAssignableFrom(a);
            if (aIsRmote == (bIsRmote = Remote.class.isAssignableFrom(b))) {
                return 0;
            }
            return aIsRmote ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Bindings {
        private final List<String> bindings = new ArrayList<String>();

        protected Bindings() {
        }

        public List<String> getBindings() {
            return this.bindings;
        }

        public boolean add(String o) {
            return this.bindings.add(o);
        }

        public boolean contains(String o) {
            return this.bindings.contains(o);
        }
    }

    public static class LegacyAddedSuffixStrategy
    implements JndiNameStrategy {
        private DeploymentInfo deploymentInfo;

        public void begin(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void end() {
        }

        public String getName(Class interfce, JndiNameStrategy.Interface type) {
            String id = this.deploymentInfo.getDeploymentID() + "";
            if (id.charAt(0) == '/') {
                id = id.substring(1);
            }
            switch (type) {
                case REMOTE_HOME: {
                    return id;
                }
                case LOCAL_HOME: {
                    return id + "Local";
                }
                case BUSINESS_LOCAL: {
                    return id + "BusinessLocal";
                }
                case BUSINESS_REMOTE: {
                    return id + "BusinessRemote";
                }
            }
            return id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplatedStrategy
    implements JndiNameStrategy {
        private static final String JNDINAME_FORMAT = "openejb.jndiname.format";
        private StringTemplate template;
        private HashMap<String, EnterpriseBeanInfo> beanInfos;
        private DeploymentInfo deploymentInfo;
        private Map<String, StringTemplate> templates;
        private String format;

        public TemplatedStrategy(EjbJarInfo ejbJarInfo, Map<String, DeploymentInfo> deployments) {
            Options options = new Options(ejbJarInfo.properties, SystemInstance.get().getOptions());
            this.format = options.get(JNDINAME_FORMAT, "{deploymentId}{interfaceType.annotationName}");
            int index = this.format.indexOf(":");
            if (index > -1) {
                logger.error("Illegal openejb.jndiname.format contains a colon ':'.  Everything before the colon will be removed, '" + this.format + "' ");
                this.format = this.format.substring(index + 1);
            }
            this.template = new StringTemplate(this.format);
            this.beanInfos = new HashMap();
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                this.beanInfos.put(beanInfo.ejbDeploymentId, beanInfo);
            }
        }

        @Override
        public void begin(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
            EnterpriseBeanInfo beanInfo = this.beanInfos.get(deploymentInfo.getDeploymentID());
            this.templates = new HashMap<String, StringTemplate>();
            this.templates.put("", this.template);
            for (JndiNameInfo nameInfo : beanInfo.jndiNamess) {
                String intrface = nameInfo.intrface;
                if (intrface == null) {
                    intrface = "";
                }
                this.templates.put(intrface, new StringTemplate(nameInfo.name));
            }
            beanInfo.jndiNames.clear();
            beanInfo.jndiNamess.clear();
        }

        @Override
        public void end() {
        }

        @Override
        public String getName(Class interfce, JndiNameStrategy.Interface type) {
            StringTemplate template = this.templates.get(interfce.getName());
            if (template == null) {
                template = this.templates.get(type.getAnnotationName());
            }
            if (template == null) {
                template = this.templates.get("");
            }
            HashMap<String, String> contextData = new HashMap<String, String>();
            contextData.put("moduleId", this.deploymentInfo.getModuleID());
            contextData.put("ejbType", this.deploymentInfo.getComponentType().name());
            contextData.put("ejbClass", this.deploymentInfo.getBeanClass().getName());
            contextData.put("ejbClass.simpleName", this.deploymentInfo.getBeanClass().getSimpleName());
            contextData.put("ejbClass.packageName", Classes.packageName(this.deploymentInfo.getBeanClass()));
            contextData.put("ejbName", this.deploymentInfo.getEjbName());
            contextData.put("deploymentId", this.deploymentInfo.getDeploymentID().toString());
            contextData.put("interfaceType", type.getAnnotationName());
            contextData.put("interfaceType.annotationName", type.getAnnotationName());
            contextData.put("interfaceType.annotationNameLC", type.getAnnotationName().toLowerCase());
            contextData.put("interfaceType.xmlName", type.getXmlName());
            contextData.put("interfaceType.xmlNameCc", type.getXmlNameCc());
            contextData.put("interfaceType.openejbLegacyName", type.getOpenejbLegacy());
            contextData.put("interfaceClass", interfce.getName());
            contextData.put("interfaceClass.simpleName", interfce.getSimpleName());
            contextData.put("interfaceClass.packageName", Classes.packageName(interfce));
            return template.apply(contextData);
        }
    }

    public static interface JndiNameStrategy {
        public void begin(DeploymentInfo var1);

        public String getName(Class var1, Interface var2);

        public void end();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Interface {
            REMOTE_HOME(InterfaceType.EJB_HOME, "RemoteHome", "home", ""),
            LOCAL_HOME(InterfaceType.EJB_LOCAL_HOME, "LocalHome", "local-home", "Local"),
            BUSINESS_LOCAL(InterfaceType.BUSINESS_LOCAL, "Local", "business-local", "BusinessLocal"),
            BUSINESS_REMOTE(InterfaceType.BUSINESS_REMOTE, "Remote", "business-remote", "BusinessRemote"),
            SERVICE_ENDPOINT(InterfaceType.SERVICE_ENDPOINT, "Endpoint", "service-endpoint", "ServiceEndpoint");

            private final InterfaceType type;
            private final String annotatedName;
            private final String xmlName;
            private final String xmlNameCc;
            private final String openejbLegacy;

            private Interface(InterfaceType type, String annotatedName, String xmlName, String openejbLegacy) {
                this.type = type;
                this.annotatedName = annotatedName;
                this.xmlName = xmlName;
                this.xmlNameCc = Strings.camelCase(xmlName);
                this.openejbLegacy = openejbLegacy;
            }

            public InterfaceType getType() {
                return this.type;
            }

            public String getAnnotationName() {
                return this.annotatedName;
            }

            public String getXmlName() {
                return this.xmlName;
            }

            public String getXmlNameCc() {
                return this.xmlNameCc;
            }

            public String getOpenejbLegacy() {
                return this.openejbLegacy;
            }
        }
    }
}

