/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.MethodScheduleInfo;
import org.apache.openejb.assembler.classic.ScheduleInfo;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.timer.MethodSchedule;
import org.apache.openejb.core.timer.ScheduleData;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SetAccessible;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodScheduleBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, MethodScheduleBuilder.class.getPackage().getName());
    private final List<MethodScheduleInfo> methodSchedules;

    public MethodScheduleBuilder(ClassLoader cl, EjbJarInfo ejbJarInfo) throws OpenEJBException {
        this.methodSchedules = ejbJarInfo.methodSchedules;
    }

    public void build(CoreDeploymentInfo deploymentInfo) {
        Class clazz = deploymentInfo.getBeanClass();
        String ejbName = deploymentInfo.getEjbName();
        ArrayList<MethodSchedule> schedules = new ArrayList<MethodSchedule>();
        for (MethodScheduleInfo info : this.methodSchedules) {
            Method method;
            if (!ejbName.equals(info.ejbName)) continue;
            try {
                method = this.getMethod(clazz, info.method.methodName, this.toClasses(info.method.methodParams, clazz.getClassLoader()));
            }
            catch (NoSuchMethodException e) {
                logger.warning("Schedule method does not exist: " + info.method.methodName, e);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.warning("Schedule method param cannot be loaded.", e);
                continue;
            }
            if (info.method.className != null && !method.getDeclaringClass().getName().equals(info.method.className)) continue;
            ArrayList<ScheduleData> data = new ArrayList<ScheduleData>();
            for (ScheduleInfo scheduleInfo : info.schedules) {
                ScheduleExpression expr = new ScheduleExpression();
                expr.second(scheduleInfo.second);
                expr.minute(scheduleInfo.minute);
                expr.hour(scheduleInfo.hour);
                expr.dayOfWeek(scheduleInfo.dayOfWeek);
                expr.dayOfMonth(scheduleInfo.dayOfMonth);
                expr.month(scheduleInfo.month);
                expr.year(scheduleInfo.year);
                TimerConfig config = new TimerConfig();
                config.setInfo((Serializable)((Object)scheduleInfo.info));
                config.setPersistent(scheduleInfo.persistent);
                data.add(new ScheduleData(config, expr));
            }
            schedules.add(new MethodSchedule(method, data));
        }
        deploymentInfo.setMethodSchedules(schedules);
    }

    private Class[] toClasses(List<String> params, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] paramsArray = new Class[params.size()];
        for (int j = 0; j < paramsArray.length; ++j) {
            String methodParam = params.get(j);
            paramsArray[j] = Classes.forName(methodParam, classLoader);
        }
        return paramsArray;
    }

    private Method getMethod(Class clazz, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
                return SetAccessible.on(method);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }
}

