/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic.cmd;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.cmd.ConfigurationInfo;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;

public class Info2Properties {
    private static Messages messages = new Messages(Info2Properties.class);
    private static final String defaultServerUrl = "ejbd://localhost:4201";

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(Info2Properties.option("v", "version", "cmd.properties.opt.version"));
        options.addOption(Info2Properties.option("h", "help", "cmd.properties.opt.help"));
        options.addOption(Info2Properties.option("s", "server-url", "url", "cmd.properties.opt.server"));
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            Info2Properties.help(options);
            System.exit(-1);
        }
        if (line.hasOption("help")) {
            Info2Properties.help(options);
            System.exit(0);
        } else if (line.hasOption("version")) {
            OpenEjbVersion.get().print(System.out);
            System.exit(0);
        }
        Properties p = new Properties();
        p.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        String serverUrl = line.getOptionValue("server-url", defaultServerUrl);
        p.put("java.naming.provider.url", serverUrl);
        ConfigurationInfo configInfo = null;
        try {
            InitialContext ctx = new InitialContext(p);
            configInfo = (ConfigurationInfo)ctx.lookup("openejb/ConfigurationInfoBusinessRemote");
        }
        catch (ServiceUnavailableException e) {
            System.out.println(e.getCause().getMessage());
            System.out.println(messages.format("cmd.deploy.serverOffline"));
            System.exit(1);
        }
        catch (NamingException e) {
            System.out.println("ConfigurationInfo does not exist in server '" + serverUrl + "', check the server logs to ensure it exists and has not been removed.");
            System.exit(2);
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("configrequest", "txt");
            if (!tempFile.exists()) {
                throw new IllegalStateException("Failed to create tmp file: " + tempFile.getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.err.println("Temp file creation failed.");
            e.printStackTrace();
            System.exit(1);
        }
        OpenEjbConfiguration configuration = null;
        try {
            configuration = configInfo.getOpenEjbConfiguration(tempFile);
        }
        catch (ConfigurationInfo.UnauthorizedException e) {
            System.err.println("This tool is currently crippled to only work with server's on the same physical machine.  See this JIRA issue for details: http://issues.apache.org/jira/browse/OPENEJB-621");
            System.exit(10);
        }
        Info2Properties.printConfig(configuration);
    }

    public static void printLocalConfig() {
        OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
        if (configuration != null) {
            Info2Properties.printConfig(configuration);
        }
    }

    public static void printConfig(OpenEjbConfiguration configuration) {
        Info2Properties.comment(Info2Properties.i18n("cmd.properties.header"));
        Info2Properties.comment("");
        Info2Properties.comment("");
        Info2Properties.comment("Generated by OpenEJB " + OpenEjbVersion.get().getVersion());
        Info2Properties.comment("On " + new Date().toString());
        Info2Properties.comment("");
        Info2Properties.comment("");
        Info2Properties.println("");
        Info2Properties.println("");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.comment(" Components configurable via openejb.xml");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.println("");
        Info2Properties.println("");
        for (ContainerInfo containerInfo : configuration.containerSystem.containers) {
            Info2Properties.print(containerInfo);
        }
        for (ConnectionManagerInfo connectionManagerInfo : configuration.facilities.connectionManagers) {
            Info2Properties.print(connectionManagerInfo);
        }
        for (ResourceInfo resourceInfo : configuration.facilities.resources) {
            Info2Properties.print(resourceInfo);
        }
        Info2Properties.print(configuration.facilities.securityService);
        Info2Properties.print(configuration.facilities.transactionService);
        Info2Properties.println("");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.comment(" Services configured via conf/<id>.properties");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.println("");
        Info2Properties.println("");
        for (ServiceInfo serviceInfo : configuration.facilities.services) {
            Info2Properties.print(serviceInfo);
        }
        Info2Properties.println("");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.comment(" Misc OpenEJB flags and properties");
        Info2Properties.comment("-------------------------------------------------");
        Info2Properties.println("");
        Info2Properties.printSystemProperties();
    }

    private static void printSystemProperties() {
        try {
            String[] misc;
            SuperProperties p = new SuperProperties();
            p.setSpaceBetweenProperties(false);
            p.setKeyValueSeparator(" = ");
            Info2Properties.copyOpenEjbProperties(System.getProperties(), p);
            Info2Properties.copyOpenEjbProperties(SystemInstance.get().getProperties(), p);
            p.store(System.out, null);
            Properties p2 = System.getProperties();
            for (String prop : misc = new String[]{"os.version", "os.name", "os.arch", "java.version", "java.vendor"}) {
                Info2Properties.comment(prop + "=" + p2.get(prop));
            }
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(new CommentsFilter(System.out)));
        }
    }

    private static void copyOpenEjbProperties(Properties source, Properties dest) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith("openejb.")) continue;
            dest.put(entry.getKey(), entry.getValue());
        }
    }

    private static void comment(String text) {
        text = text.replaceAll("\n", "\n# ");
        Info2Properties.print("# ");
        Info2Properties.println(text);
    }

    private static void print(String text) {
        System.out.print(text);
    }

    private static void println(String text) {
        System.out.println(text);
    }

    private static void print(ServiceInfo info) {
        try {
            Info2Properties.println("");
            Info2Properties.comment(info.service + "(id=" + info.id + ")");
            Info2Properties.comment("className: " + info.className);
            Info2Properties.comment("");
            SuperProperties p = new SuperProperties();
            p.setSpaceBetweenProperties(false);
            p.setKeyValueSeparator(" = ");
            String uri = "new://" + info.service;
            if (info.service.matches("Container|Resource|Connector")) {
                try {
                    HashMap<String, String> query = new HashMap<String, String>();
                    query.put("type", info.types.get(0));
                    uri = uri + "?" + URISupport.createQueryString(query);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            p.put(info.id, uri);
            for (Map.Entry<Object, Object> entry : info.properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                if ("password".equalsIgnoreCase((String)entry.getKey())) {
                    p.put(info.id + "." + entry.getKey(), "xxxx");
                    continue;
                }
                p.put(info.id + "." + entry.getKey(), entry.getValue());
            }
            p.store(System.out, null);
        }
        catch (IOException e) {
            System.out.println("# Printing service(id=" + info.id + ") failed.");
            e.printStackTrace(new PrintWriter(new CommentsFilter(System.out)));
        }
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("properties [options]", "\n" + Info2Properties.i18n("cmd.properties.description"), options, "\n");
    }

    private static Option option(String shortOpt, String longOpt, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withDescription((String)Info2Properties.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static Option option(String shortOpt, String longOpt, String argName, String description) {
        OptionBuilder.withLongOpt((String)longOpt);
        OptionBuilder.withArgName((String)argName);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Info2Properties.i18n(description));
        return OptionBuilder.create((String)shortOpt);
    }

    private static String i18n(String key) {
        return messages.format(key);
    }

    static class CommentsFilter
    extends FilterOutputStream {
        public CommentsFilter(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            super.write(b);
            if (b == 10) {
                super.write(35);
            }
        }
    }

    static class Filter
    extends FilterOutputStream {
        private boolean pastFirstLine;

        public Filter(OutputStream out) {
            super(out);
        }

        public void write(int b) throws IOException {
            if (this.pastFirstLine) {
                super.write(b);
            } else {
                this.pastFirstLine = b == 10;
            }
        }
    }
}

