/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.openejb.loader.OpenEJBInstance;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.OptionsLog;

public class LocalInitialContextFactory
implements InitialContextFactory {
    private static OpenEJBInstance openejb;
    private boolean bootedOpenEJB;

    public Context getInitialContext(Hashtable env) throws NamingException {
        this.init(env);
        return this.getLocalInitialContext(env);
    }

    private void init(Hashtable env) throws NamingException {
        if (openejb != null) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)env);
            this.init(properties);
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Attempted to load OpenEJB. " + e.getMessage()).initCause(e);
        }
    }

    boolean bootedOpenEJB() {
        return this.bootedOpenEJB;
    }

    public void init(Properties properties) throws Exception {
        if (openejb != null) {
            return;
        }
        openejb = new OpenEJBInstance();
        if (openejb.isInitialized()) {
            return;
        }
        this.bootedOpenEJB = true;
        SystemInstance.init((Properties)properties);
        OptionsLog.install();
        SystemInstance.get().setProperty("openejb.embedded", "true");
        openejb.init(properties);
    }

    public void close() {
        openejb = null;
    }

    private Context getLocalInitialContext(Hashtable env) throws NamingException {
        Context context = null;
        try {
            ClassLoader cl = SystemInstance.get().getClassLoader();
            Class<?> localInitialContext = Class.forName("org.apache.openejb.client.LocalInitialContext", true, cl);
            Constructor<?> constructor = localInitialContext.getConstructor(Hashtable.class, LocalInitialContextFactory.class);
            context = (Context)constructor.newInstance(env, this);
        }
        catch (Throwable e) {
            InvocationTargetException ite;
            if (e instanceof InvocationTargetException && (ite = (InvocationTargetException)e).getTargetException() != null) {
                e = ite.getTargetException();
            }
            if (e instanceof NamingException) {
                throw (NamingException)e;
            }
            throw (NamingException)new NamingException("Cannot instantiate a LocalInitialContext. Exception: " + e.getClass().getName() + " " + e.getMessage()).initCause(e);
        }
        return context;
    }
}

