/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.HandlerChainInfo;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PortInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbJarInfoBuilder;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.JndiEncInfoBuilder;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReportValidationResults;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.ConfigProperty;
import org.apache.openejb.jee.ConnectionDefinition;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.InboundResource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.MessageListener;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.JpaJaxbUtil;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.jpa.unit.Property;
import org.apache.openejb.jee.oejb2.EnterpriseBean;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.SessionBeanType;
import org.apache.openejb.jee.oejb2.WebServiceSecurityType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.util.CircularReferencesException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.References;
import org.apache.openejb.util.URLs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppInfoBuilder {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    private static final Messages messages = new Messages("org.apache.openejb.util.resources");
    private final ConfigurationFactory configFactory;
    private EjbJarInfoBuilder ejbJarInfoBuilder = new EjbJarInfoBuilder();

    public AppInfoBuilder(ConfigurationFactory configFactory) {
        this.configFactory = configFactory;
    }

    public AppInfo build(AppModule appModule) throws OpenEJBException {
        AppInfo appInfo = new AppInfo();
        this.buildConnectorModules(appModule, appInfo);
        this.buildPersistenceModules(appModule, appInfo);
        List<String> containerIds = this.configFactory.getContainerIds();
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (MdbContainerInfo containerInfo : connectorInfo.inbound) {
                containerIds.add(containerInfo.id);
            }
        }
        TreeMap<String, EjbJarInfo> ejbJarInfos = new TreeMap<String, EjbJarInfo>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            try {
                EjbJarInfo ejbJarInfo = this.ejbJarInfoBuilder.buildInfo(ejbModule);
                Map deploymentsByEjbName = ejbModule.getOpenejbJar().getDeploymentsByEjbName();
                for (EnterpriseBeanInfo bean : ejbJarInfo.enterpriseBeans) {
                    EjbDeployment d = (EjbDeployment)deploymentsByEjbName.get(bean.ejbName);
                    if (!containerIds.contains(d.getContainerId()) && !AppInfoBuilder.skipMdb(bean)) {
                        String msg = messages.format("config.noContainerFound", d.getContainerId(), d.getEjbName());
                        logger.fatal(msg);
                        throw new OpenEJBException(msg);
                    }
                    bean.containerId = d.getContainerId();
                }
                ejbJarInfo.portInfos.addAll(this.configureWebservices(ejbModule.getWebservices()));
                this.configureWebserviceSecurity(ejbJarInfo, ejbModule);
                ejbJarInfos.put(ejbJarInfo.jarPath, ejbJarInfo);
                appInfo.ejbJars.add(ejbJarInfo);
            }
            catch (OpenEJBException e) {
                ConfigUtils.logger.warning("conf.0004", ejbModule.getJarLocation(), e.getMessage());
                throw e;
            }
        }
        JndiEncInfoBuilder jndiEncInfoBuilder = new JndiEncInfoBuilder(appInfo);
        ArrayList<EnterpriseBeanInfo> beans = new ArrayList<EnterpriseBeanInfo>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJarInfo ejbJar = (EjbJarInfo)ejbJarInfos.get(ejbModule.getJarLocation());
            Map beanData = ejbModule.getEjbJar().getEnterpriseBeansByEjbName();
            for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
                JndiEncInfo jndi;
                beans.add(beanInfo);
                org.apache.openejb.jee.EnterpriseBean enterpriseBean = (org.apache.openejb.jee.EnterpriseBean)beanData.get(beanInfo.ejbName);
                beanInfo.jndiEnc = jndi = jndiEncInfoBuilder.build((JndiConsumer)enterpriseBean, beanInfo.ejbName, ejbJar.moduleId);
                jndiEncInfoBuilder.buildDependsOnRefs(ejbModule, enterpriseBean, beanInfo, ejbJar.moduleId);
            }
        }
        try {
            References.sort(beans, new References.Visitor<EnterpriseBeanInfo>(){

                @Override
                public String getName(EnterpriseBeanInfo bean) {
                    return bean.ejbDeploymentId;
                }

                @Override
                public Set<String> getReferences(EnterpriseBeanInfo bean) {
                    return new LinkedHashSet<String>(bean.dependsOn);
                }
            });
        }
        catch (CircularReferencesException e) {
            List<List> circuits = e.getCircuits();
        }
        this.buildClientModules(appModule, appInfo, jndiEncInfoBuilder);
        this.buildWebModules(appModule, jndiEncInfoBuilder, appInfo);
        appInfo.jarPath = appModule.getJarLocation();
        appInfo.watchedResources.addAll(appModule.getWatchedResources());
        List<URL> additionalLibraries = appModule.getAdditionalLibraries();
        for (URL url : additionalLibraries) {
            File file = URLs.toFile(url);
            try {
                appInfo.libs.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                throw new OpenEJBException("Invalid application lib path " + file.getAbsolutePath());
            }
        }
        if (appModule.getCmpMappings() != null) {
            try {
                String cmpMappingsXml;
                appInfo.cmpMappingsXml = cmpMappingsXml = JpaJaxbUtil.marshal(EntityMappings.class, (Object)appModule.getCmpMappings());
            }
            catch (JAXBException e) {
                throw new OpenEJBException("Unable to marshal cmp entity mappings", e);
            }
        }
        ReportValidationResults reportValidationResults = new ReportValidationResults();
        reportValidationResults.deploy(appModule);
        logger.info("config.appLoaded", appInfo.jarPath);
        return appInfo;
    }

    private void buildClientModules(AppModule appModule, AppInfo appInfo, JndiEncInfoBuilder jndiEncInfoBuilder) throws OpenEJBException {
        for (ClientModule clientModule : appModule.getClientModules()) {
            ApplicationClient applicationClient = clientModule.getApplicationClient();
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.description = applicationClient.getDescription();
            clientInfo.displayName = applicationClient.getDisplayName();
            clientInfo.codebase = clientModule.getJarLocation();
            clientInfo.mainClass = clientModule.getMainClass();
            clientInfo.localClients.addAll(clientModule.getLocalClients());
            clientInfo.remoteClients.addAll(clientModule.getRemoteClients());
            clientInfo.callbackHandler = applicationClient.getCallbackHandler();
            clientInfo.moduleId = AppInfoBuilder.getClientModuleId(clientModule);
            clientInfo.watchedResources.addAll(clientModule.getWatchedResources());
            clientInfo.jndiEnc = jndiEncInfoBuilder.build((JndiConsumer)applicationClient, clientModule.getJarLocation(), clientInfo.moduleId);
            appInfo.clients.add(clientInfo);
        }
    }

    private void buildWebModules(AppModule appModule, JndiEncInfoBuilder jndiEncInfoBuilder, AppInfo appInfo) throws OpenEJBException {
        for (WebModule webModule : appModule.getWebModules()) {
            WebApp webApp = webModule.getWebApp();
            WebAppInfo webAppInfo = new WebAppInfo();
            webAppInfo.description = webApp.getDescription();
            webAppInfo.displayName = webApp.getDisplayName();
            webAppInfo.codebase = webModule.getJarLocation();
            webAppInfo.moduleId = webModule.getModuleId();
            webAppInfo.watchedResources.addAll(webModule.getWatchedResources());
            webAppInfo.host = webModule.getHost();
            webAppInfo.contextRoot = webModule.getContextRoot();
            webAppInfo.jndiEnc = jndiEncInfoBuilder.build((JndiConsumer)webApp, webModule.getJarLocation(), webAppInfo.moduleId);
            webAppInfo.portInfos.addAll(this.configureWebservices(webModule.getWebservices()));
            this.configureWebserviceSecurity(webAppInfo, webModule);
            for (Servlet servlet : webModule.getWebApp().getServlet()) {
                ServletInfo servletInfo = new ServletInfo();
                servletInfo.servletName = servlet.getServletName();
                servletInfo.servletClass = servlet.getServletClass();
                webAppInfo.servlets.add(servletInfo);
            }
            appInfo.webApps.add(webAppInfo);
        }
    }

    private void buildConnectorModules(AppModule appModule, AppInfo appInfo) throws OpenEJBException {
        String appId = appModule.getModuleId();
        for (ConnectorModule connectorModule : appModule.getResourceModules()) {
            InboundResource inbound;
            ResourceInfo resourceInfo;
            String value;
            String name;
            Properties properties;
            Resource resource;
            ServiceProvider provider;
            String type;
            String className;
            String id;
            OutboundResourceAdapter outbound;
            Connector connector = connectorModule.getConnector();
            ConnectorInfo connectorInfo = new ConnectorInfo();
            connectorInfo.description = connector.getDescription();
            connectorInfo.displayName = connector.getDisplayName();
            connectorInfo.codebase = connectorModule.getJarLocation();
            connectorInfo.moduleId = connectorModule.getModuleId();
            connectorInfo.watchedResources.addAll(connectorModule.getWatchedResources());
            List<URL> libraries = connectorModule.getLibraries();
            for (URL url : libraries) {
                File file = URLs.toFile(url);
                try {
                    connectorInfo.libs.add(file.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid application lib path " + file.getAbsolutePath());
                }
            }
            ResourceAdapter resourceAdapter = connector.getResourceAdapter();
            if (resourceAdapter.getResourceAdapterClass() != null) {
                String id2 = this.getId(connectorModule);
                String className2 = resourceAdapter.getResourceAdapterClass();
                ServiceProvider provider2 = new ServiceProvider(className2, id2, "Resource");
                provider2.getTypes().add(className2);
                ServiceUtils.registerServiceProvider(appId, provider2);
                Resource resource2 = new Resource(id2, className2, appId + "#" + id2);
                for (ConfigProperty property : resourceAdapter.getConfigProperty()) {
                    String name2 = property.getConfigPropertyName();
                    String value2 = property.getConfigPropertyValue();
                    if (value2 == null) continue;
                    resource2.getProperties().setProperty(name2, value2);
                }
                connectorInfo.resourceAdapter = this.configFactory.configureService(resource2, ResourceInfo.class);
            }
            if ((outbound = resourceAdapter.getOutboundResourceAdapter()) != null) {
                String transactionSupport = "none";
                switch (outbound.getTransactionSupport()) {
                    case LOCAL_TRANSACTION: {
                        transactionSupport = "local";
                        break;
                    }
                    case NO_TRANSACTION: {
                        transactionSupport = "none";
                        break;
                    }
                    case XA_TRANSACTION: {
                        transactionSupport = "xa";
                    }
                }
                for (ConnectionDefinition connection : outbound.getConnectionDefinition()) {
                    id = this.getId(connection, outbound, connectorModule);
                    className = connection.getManagedConnectionFactoryClass();
                    type = connection.getConnectionFactoryInterface();
                    provider = new ServiceProvider(className, id, "Resource");
                    provider.getTypes().add(type);
                    ServiceUtils.registerServiceProvider(appId, provider);
                    resource = new Resource(id, type, appId + "#" + id);
                    properties = resource.getProperties();
                    for (ConfigProperty property : connection.getConfigProperty()) {
                        name = property.getConfigPropertyName();
                        value = property.getConfigPropertyValue();
                        if (value == null) continue;
                        properties.setProperty(name, value);
                    }
                    properties.setProperty("TransactionSupport", transactionSupport);
                    properties.setProperty("ResourceAdapter", connectorInfo.resourceAdapter.id);
                    resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
                    connectorInfo.outbound.add(resourceInfo);
                }
            }
            if ((inbound = resourceAdapter.getInboundResourceAdapter()) != null) {
                for (MessageListener messageListener : inbound.getMessageAdapter().getMessageListener()) {
                    id = this.getId(messageListener, inbound, connectorModule);
                    Container container = new Container(id, "MESSAGE", null);
                    Properties properties2 = container.getProperties();
                    properties2.setProperty("ResourceAdapter", connectorInfo.resourceAdapter.id);
                    properties2.setProperty("MessageListenerInterface", messageListener.getMessageListenerType());
                    properties2.setProperty("ActivationSpecClass", messageListener.getActivationSpec().getActivationSpecClass());
                    MdbContainerInfo mdbContainerInfo = this.configFactory.configureService(container, MdbContainerInfo.class);
                    connectorInfo.inbound.add(mdbContainerInfo);
                }
            }
            for (AdminObject adminObject : resourceAdapter.getAdminObject()) {
                id = this.getId(adminObject, resourceAdapter, connectorModule);
                className = adminObject.getAdminObjectClass();
                type = adminObject.getAdminObjectInterface();
                provider = new ServiceProvider(className, id, "Resource");
                provider.getTypes().add(type);
                ServiceUtils.registerServiceProvider(appId, provider);
                resource = new Resource(id, type, appId + "#" + id);
                properties = resource.getProperties();
                for (ConfigProperty property : adminObject.getConfigProperty()) {
                    name = property.getConfigPropertyName();
                    value = property.getConfigPropertyValue();
                    if (value == null) continue;
                    properties.setProperty(name, value);
                }
                resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
                connectorInfo.adminObject.add(resourceInfo);
            }
            appInfo.connectors.add(connectorInfo);
        }
    }

    private String getId(AdminObject adminObject, ResourceAdapter resourceAdapter, ConnectorModule connectorModule) {
        String id = adminObject.getId() != null ? adminObject.getId() : (resourceAdapter.getAdminObject().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + adminObject.getAdminObjectInterface());
        return id;
    }

    private String getId(MessageListener messageListener, InboundResource inbound, ConnectorModule connectorModule) {
        String id = messageListener.getId() != null ? messageListener.getId() : (inbound.getMessageAdapter().getMessageListener().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + messageListener.getMessageListenerType());
        return id;
    }

    private String getId(ConnectionDefinition connection, OutboundResourceAdapter outbound, ConnectorModule connectorModule) {
        String id = connection.getId() != null ? connection.getId() : (outbound.getConnectionDefinition().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + connection.getConnectionFactoryInterface());
        return id;
    }

    private String getId(ConnectorModule connectorModule) {
        String id = connectorModule.getConnector().getResourceAdapter().getId();
        if (id == null) {
            id = connectorModule.getModuleId() + "RA";
        }
        return id;
    }

    private void buildPersistenceModules(AppModule appModule, AppInfo appInfo) {
        for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
            String rootUrl = persistenceModule.getRootUrl();
            Persistence persistence = persistenceModule.getPersistence();
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                PersistenceUnitInfo info = new PersistenceUnitInfo();
                info.id = persistenceUnit.getName() + " " + rootUrl.hashCode();
                info.name = persistenceUnit.getName();
                info.watchedResources.addAll(persistenceModule.getWatchedResources());
                info.persistenceUnitRootUrl = rootUrl;
                info.provider = persistenceUnit.getProvider();
                info.transactionType = persistenceUnit.getTransactionType().toString();
                Boolean excludeUnlistedClasses = persistenceUnit.isExcludeUnlistedClasses();
                info.excludeUnlistedClasses = excludeUnlistedClasses != null && excludeUnlistedClasses != false;
                info.jtaDataSource = persistenceUnit.getJtaDataSource();
                info.nonJtaDataSource = persistenceUnit.getNonJtaDataSource();
                info.jarFiles.addAll(persistenceUnit.getJarFile());
                info.classes.addAll(persistenceUnit.getClazz());
                info.mappingFiles.addAll(persistenceUnit.getMappingFile());
                org.apache.openejb.jee.jpa.unit.Properties puiProperties = persistenceUnit.getProperties();
                if (puiProperties != null) {
                    for (Property property : puiProperties.getProperty()) {
                        info.properties.put(property.getName(), property.getValue());
                    }
                }
                Properties overrides = ConfigurationFactory.getSystemProperties(info.name, "PersistenceUnit");
                for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                    Object property = entry.getKey();
                    Object value = entry.getValue();
                    if (info.properties.contains(property)) {
                        logger.debug("Overriding persistence-unit " + info.name + " property " + property + "=" + value);
                    } else {
                        logger.debug("Adding persistence-unit " + info.name + " property " + property + "=" + value);
                    }
                    info.properties.put(property, value);
                }
                PersistenceProviderProperties.apply(info);
                appInfo.persistenceUnits.add(info);
            }
        }
    }

    private static String getClientModuleId(ClientModule clientModule) {
        String jarLocation = clientModule.getJarLocation();
        File file = new File(jarLocation);
        String name = file.getName();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            name = name.replaceFirst("....$", "");
        }
        return name;
    }

    private List<PortInfo> configureWebservices(Webservices webservices) {
        ArrayList<PortInfo> portMap = new ArrayList<PortInfo>();
        if (webservices == null) {
            return portMap;
        }
        for (WebserviceDescription desc : webservices.getWebserviceDescription()) {
            String wsdlFile = desc.getWsdlFile();
            String serviceName = desc.getWebserviceDescriptionName();
            for (PortComponent port : desc.getPortComponent()) {
                PortInfo portInfo = new PortInfo();
                ServiceImplBean serviceImplBean = port.getServiceImplBean();
                portInfo.serviceId = desc.getId();
                portInfo.portId = port.getId();
                portInfo.serviceLink = serviceImplBean.getEjbLink();
                if (portInfo.serviceLink == null) {
                    portInfo.serviceLink = serviceImplBean.getServletLink();
                }
                portInfo.seiInterfaceName = port.getServiceEndpointInterface();
                portInfo.portName = port.getPortComponentName();
                portInfo.binding = port.getProtocolBinding();
                portInfo.serviceName = serviceName;
                portInfo.wsdlFile = wsdlFile;
                portInfo.mtomEnabled = port.isEnableMtom();
                portInfo.wsdlPort = port.getWsdlPort();
                portInfo.wsdlService = port.getWsdlService();
                portInfo.location = port.getLocation();
                List<HandlerChainInfo> handlerChains = ConfigurationFactory.toHandlerChainInfo(port.getHandlerChains());
                portInfo.handlerChains.addAll(handlerChains);
                portMap.add(portInfo);
            }
        }
        return portMap;
    }

    void configureWebserviceSecurity(WebAppInfo info, WebModule module) {
        Object altDD = module.getAltDDs().get("openejb-jar.xml");
        List<PortInfo> infoList = info.portInfos;
        this.configureWebserviceScurity(infoList, altDD);
    }

    void configureWebserviceSecurity(EjbJarInfo ejbJarInfo, EjbModule ejbModule) {
        Object altDD = ejbModule.getAltDDs().get("openejb-jar.xml");
        List<PortInfo> infoList = ejbJarInfo.portInfos;
        this.configureWebserviceScurity(infoList, altDD);
    }

    private void configureWebserviceScurity(List<PortInfo> infoList, Object altDD) {
        if (altDD == null || !(altDD instanceof OpenejbJarType)) {
            return;
        }
        OpenejbJarType openejbJarType = (OpenejbJarType)altDD;
        HashMap<String, EnterpriseBean> beans = new HashMap<String, EnterpriseBean>();
        for (EnterpriseBean enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            beans.put(enterpriseBean.getEjbName(), enterpriseBean);
        }
        for (PortInfo portInfo : infoList) {
            SessionBeanType sessionBean;
            WebServiceSecurityType webServiceSecurityType;
            EnterpriseBean bean = (EnterpriseBean)beans.get(portInfo.serviceLink);
            if (bean == null || !(bean instanceof SessionBeanType) || (webServiceSecurityType = (sessionBean = (SessionBeanType)bean).getWebServiceSecurity()) == null) continue;
            portInfo.realmName = webServiceSecurityType.getRealmName();
            portInfo.securityRealmName = webServiceSecurityType.getSecurityRealmName();
            portInfo.transportGuarantee = webServiceSecurityType.getTransportGuarantee() != null ? webServiceSecurityType.getTransportGuarantee().value() : "NONE";
            portInfo.authMethod = webServiceSecurityType.getAuthMethod() != null ? webServiceSecurityType.getAuthMethod().value() : "NONE";
            portInfo.properties = webServiceSecurityType.getProperties();
        }
    }

    private static boolean skipMdb(EnterpriseBeanInfo bean) {
        return bean instanceof MessageDrivenBeanInfo && System.getProperty("duct tape") != null;
    }

    public static class PersistenceProviderProperties {
        private static void apply(PersistenceUnitInfo info) {
            if ("org.hibernate.ejb.HibernatePersistence".equals(info.provider)) {
                String lookupProperty = "hibernate.transaction.manager_lookup_class";
                String openejbLookupClass = "org.apache.openejb.hibernate.TransactionManagerLookup";
                String className = info.properties.getProperty(lookupProperty);
                if (className == null || className.startsWith("org.hibernate.transaction")) {
                    info.properties.setProperty(lookupProperty, openejbLookupClass);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + lookupProperty + "=" + openejbLookupClass);
                }
            } else if ("oracle.toplink.essentials.PersistenceProvider".equals(info.provider) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(info.provider)) {
                String lookupProperty = "toplink.target-server";
                String openejbLookupClass = "org.apache.openejb.toplink.JTATransactionController";
                String className = info.properties.getProperty(lookupProperty);
                if (className == null || className.startsWith("oracle.toplink.transaction")) {
                    info.properties.setProperty(lookupProperty, openejbLookupClass);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + lookupProperty + "=" + openejbLookupClass);
                }
            } else if ("org.eclipse.persistence.jpa.PersistenceProvider".equals(info.provider) || "org.eclipse.persistence.jpa.osgi.PersistenceProvider".equals(info.provider)) {
                String lookupProperty = "eclipselink.target-server";
                String openejbLookupClass = "org.apache.openejb.eclipselink.JTATransactionController";
                String className = info.properties.getProperty(lookupProperty);
                if (className == null || className.startsWith("org.eclipse.persistence.transaction")) {
                    info.properties.setProperty(lookupProperty, openejbLookupClass);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + lookupProperty + "=" + openejbLookupClass);
                }
            }
        }
    }
}

