/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.xbean.finder.ClassFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientModule
implements DeploymentModule {
    private final ValidationContext validation;
    private ApplicationClient applicationClient;
    private String jarLocation;
    private ClassLoader classLoader;
    private String mainClass;
    private boolean ejbModuleGenerated;
    private AtomicReference<ClassFinder> finder;
    private final Set<String> localClients = new HashSet<String>();
    private final Set<String> remoteClients = new HashSet<String>();
    private final Map<String, Object> altDDs = new HashMap<String, Object>();
    private final String moduleId;
    private final Set<String> watchedResources = new TreeSet<String>();

    public ClientModule(ApplicationClient applicationClient, ClassLoader classLoader, String jarLocation, String mainClass, String moduleId) {
        this.applicationClient = applicationClient;
        this.classLoader = classLoader;
        this.jarLocation = jarLocation;
        this.mainClass = mainClass;
        if (moduleId == null) {
            if (applicationClient != null && applicationClient.getId() != null) {
                moduleId = applicationClient.getId();
            } else {
                File file = new File(jarLocation);
                moduleId = file.getName();
            }
        }
        this.moduleId = moduleId;
        this.validation = new ValidationContext(ClientModule.class, jarLocation);
    }

    public boolean isEjbModuleGenerated() {
        return this.ejbModuleGenerated;
    }

    public void setEjbModuleGenerated(boolean ejbModuleGenerated) {
        this.ejbModuleGenerated = ejbModuleGenerated;
    }

    public ClassFinder getFinder() {
        return this.finder != null ? this.finder.get() : null;
    }

    public void setFinderReference(AtomicReference<ClassFinder> finder) {
        this.finder = finder;
    }

    public AtomicReference<ClassFinder> getFinderReference() {
        return this.finder;
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public Map<String, Object> getAltDDs() {
        return this.altDDs;
    }

    public ApplicationClient getApplicationClient() {
        return this.applicationClient;
    }

    public void setApplicationClient(ApplicationClient applicationClient) {
        this.applicationClient = applicationClient;
    }

    public Set<String> getLocalClients() {
        return this.localClients;
    }

    public Set<String> getRemoteClients() {
        return this.remoteClients;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    public void setJarLocation(String jarLocation) {
        this.jarLocation = jarLocation;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }
}

