/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EnvEntry;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvEntriesPropertiesDeployer
implements DynamicDeployer {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, EnvEntriesPropertiesDeployer.class);

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        EnvEntry envEntry;
        for (ClientModule clientModule : appModule.getClientModules()) {
            if (clientModule.getApplicationClient() == null) continue;
            for (Map.Entry<String, String> entry : this.getEnvEntries(clientModule).entrySet()) {
                envEntry = new EnvEntry(entry.getKey(), "java.lang.String", entry.getValue());
                this.apply((JndiConsumer)clientModule.getApplicationClient(), envEntry, "AppClient");
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.deploy(webModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            for (Map.Entry<String, String> entry : this.getEnvEntries(ejbModule).entrySet()) {
                envEntry = new EnvEntry(entry.getKey(), "java.lang.String", entry.getValue());
                if (envEntry.getName().contains(".")) {
                    String name = envEntry.getName();
                    String ejbName = name.substring(0, name.indexOf(46));
                    name = name.substring(name.indexOf(46) + 1);
                    EnterpriseBean bean = ejbModule.getEjbJar().getEnterpriseBean(ejbName);
                    if (bean != null) {
                        envEntry.setName(name);
                        this.apply((JndiConsumer)bean, envEntry, bean.getEjbName());
                        continue;
                    }
                }
                for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                    this.apply((JndiConsumer)bean, envEntry, bean.getEjbName());
                }
            }
        }
        return appModule;
    }

    public WebModule deploy(WebModule webModule) {
        for (Map.Entry<String, String> entry : this.getEnvEntries(webModule).entrySet()) {
            EnvEntry envEntry = new EnvEntry(entry.getKey(), "java.lang.String", entry.getValue());
            this.apply((JndiConsumer)webModule.getWebApp(), envEntry, "WebApp");
        }
        return webModule;
    }

    private void apply(JndiConsumer bean, EnvEntry newEntry, String componentName) {
        EnvEntry entry = (EnvEntry)bean.getEnvEntryMap().get(newEntry.getName());
        if (entry != null) {
            log.debug("envprops.override", componentName, entry.getName(), entry.getEnvEntryValue(), newEntry.getEnvEntryValue());
            entry.setEnvEntryValue(newEntry.getEnvEntryValue());
            return;
        }
        log.debug("envprops.add", componentName, newEntry.getName(), newEntry.getEnvEntryValue());
        bean.getEnvEntry().add(newEntry);
    }

    private Map<String, String> getEnvEntries(DeploymentModule module) {
        URL propsUrl = (URL)module.getAltDDs().get("env-entries.properties");
        if (propsUrl == null) {
            propsUrl = (URL)module.getAltDDs().get("env-entry.properties");
        }
        if (propsUrl == null) {
            return Collections.emptyMap();
        }
        try {
            InputStream in = propsUrl.openStream();
            Properties envEntriesProps = new Properties();
            envEntriesProps.load(in);
            return new HashMap<Object, Object>(envEntriesProps);
        }
        catch (IOException e) {
            log.error("envprops.notLoaded", e, module.getModuleId(), propsUrl.toExternalForm());
            return Collections.emptyMap();
        }
    }
}

