/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.JpaJaxbUtil;
import org.apache.openejb.jee.oejb3.JaxbOpenejbJar3;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class OutputGeneratedDescriptors
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    private static final String OUTPUT_DESCRIPTORS = "openejb.descriptors.output";

    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        boolean output = SystemInstance.get().getOptions().get(OUTPUT_DESCRIPTORS, false);
        if (output && appModule.getCmpMappings() != null) {
            this.writeGenratedCmpMappings(appModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            Options options = new Options(ejbModule.getOpenejbJar().getProperties(), SystemInstance.get().getOptions());
            output = options.get(OUTPUT_DESCRIPTORS, false);
            if (!output) continue;
            if (ejbModule.getEjbJar() != null) {
                this.writeEjbJar(ejbModule);
            }
            if (ejbModule.getOpenejbJar() == null) continue;
            this.writeOpenejbJar(ejbModule);
        }
        return appModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeGenratedCmpMappings(AppModule appModule) {
        try {
            File tempFile = File.createTempFile("openejb-cmp-generated-orm-", ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                try {
                    JpaJaxbUtil.marshal(EntityMappings.class, (Object)appModule.getCmpMappings(), (OutputStream)out);
                }
                catch (JAXBException e) {
                    Object var7_7 = null;
                    out.close();
                    return;
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeOpenejbJar(EjbModule ejbModule) {
        try {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            File tempFile = File.createTempFile("openejb-jar-", ejbModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                try {
                    JaxbOpenejbJar3.marshal(OpenejbJar.class, (Object)openejbJar, (OutputStream)out);
                    logger.info("Dumping Generated openejb-jar.xml to: " + tempFile.getAbsolutePath());
                }
                catch (JAXBException e) {
                    Object var8_8 = null;
                    out.close();
                    return;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeEjbJar(EjbModule ejbModule) {
        try {
            EjbJar ejbJar = ejbModule.getEjbJar();
            File tempFile = File.createTempFile("ejb-jar-", ejbModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                try {
                    JaxbJavaee.marshal(EjbJar.class, (Object)ejbJar, (OutputStream)out);
                    logger.info("Dumping Generated ejb-jar.xml to: " + tempFile.getAbsolutePath());
                }
                catch (JAXBException e) {
                    Object var8_8 = null;
                    out.close();
                    return;
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

