/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.util.Collection;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.TransactionType;

public class CheckUserTransactionRefs
extends ValidationBase {
    public void validate(EjbModule ejbModule) {
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            if (bean.getTransactionType() != TransactionType.CONTAINER) continue;
            Collection resRefs = bean.getResourceRef();
            for (ResourceRef resRef : resRefs) {
                if (!"javax.transaction.UserTransaction".equals(resRef.getResType())) continue;
                this.error(bean, "userResourceRef.forbiddenForCmtdBeans", resRef.getName());
            }
        }
    }
}

