/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Transaction;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.PojoSerialization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instance
implements Serializable {
    private static final long serialVersionUID = 2862563626506556542L;
    public final CoreDeploymentInfo deploymentInfo;
    public final Object primaryKey;
    public final Object bean;
    public final Map<String, Object> interceptors;
    private boolean inUse;
    private BeanTransactionPolicy.SuspendedTransaction beanTransaction;
    private Stack<Transaction> transaction = new Stack();
    private final Lock lock = new ReentrantLock();
    private Map<EntityManagerFactory, EntityManager> entityManagers;
    private final EntityManager[] entityManagerArray;

    public Instance(CoreDeploymentInfo deploymentInfo, Object primaryKey, Object bean, Map<String, Object> interceptors, Map<EntityManagerFactory, EntityManager> entityManagers) {
        this.deploymentInfo = deploymentInfo;
        this.primaryKey = primaryKey;
        this.bean = bean;
        this.interceptors = interceptors;
        this.entityManagers = entityManagers;
        this.entityManagerArray = null;
    }

    public Instance(Object deploymentId, Object primaryKey, Object bean, Map<String, Object> interceptors, EntityManager[] entityManagerArray) {
        this.deploymentInfo = (CoreDeploymentInfo)((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getDeploymentInfo(deploymentId);
        if (this.deploymentInfo == null) {
            throw new IllegalArgumentException("Unknown deployment " + deploymentId);
        }
        this.primaryKey = primaryKey;
        this.bean = bean;
        this.interceptors = interceptors;
        this.entityManagerArray = entityManagerArray;
    }

    public synchronized boolean isInUse() {
        return this.inUse;
    }

    public synchronized void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public synchronized BeanTransactionPolicy.SuspendedTransaction getBeanTransaction() {
        return this.beanTransaction;
    }

    public synchronized void setBeanTransaction(BeanTransactionPolicy.SuspendedTransaction beanTransaction) {
        this.beanTransaction = beanTransaction;
    }

    public synchronized Transaction getTransaction() {
        return this.transaction.size() > 0 ? this.transaction.peek() : null;
    }

    public Lock getLock() {
        return this.lock;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (this.transaction.size() == 0 && transaction != null) {
            this.lock.lock();
            this.transaction.push(transaction);
        } else if (this.transaction.size() != 0 && transaction == null) {
            this.transaction.pop();
            this.lock.unlock();
        } else if (transaction != null) {
            this.transaction.push(transaction);
        }
    }

    public synchronized Map<EntityManagerFactory, EntityManager> getEntityManagers(Index<EntityManagerFactory, Map> factories) {
        if (this.entityManagers == null && this.entityManagerArray != null) {
            this.entityManagers = new HashMap<EntityManagerFactory, EntityManager>();
            for (int i = 0; i < this.entityManagerArray.length; ++i) {
                EntityManagerFactory entityManagerFactory = factories.getKey(i);
                EntityManager entityManager = this.entityManagerArray[i];
                this.entityManagers.put(entityManagerFactory, entityManager);
            }
        }
        return this.entityManagers;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.inUse) {
            throw new IllegalStateException("Bean is still in use");
        }
        if (this.beanTransaction != null) {
            throw new IllegalStateException("Bean is associated with a bean-managed transaction");
        }
        return new Serialization(this);
    }

    private static class Serialization
    implements Serializable {
        private static final long serialVersionUID = 6002078080752564395L;
        public final Object deploymentId;
        public final Object primaryKey;
        public final Object bean;
        public final Map<String, Object> interceptors;
        public final EntityManager[] entityManagerArray;

        public Serialization(Instance i) {
            this.deploymentId = i.deploymentInfo.getDeploymentID();
            this.primaryKey = i.primaryKey;
            this.bean = i.bean instanceof Serializable ? i.bean : new PojoSerialization(i.bean);
            this.interceptors = new HashMap<String, Object>(i.interceptors.size());
            for (Map.Entry<String, Object> e : i.interceptors.entrySet()) {
                if (e.getValue() == i.bean) {
                    this.interceptors.put(e.getKey(), this.bean);
                    continue;
                }
                if (e.getValue() instanceof Serializable) continue;
                this.interceptors.put(e.getKey(), new PojoSerialization(e.getValue()));
            }
            this.entityManagerArray = i.entityManagerArray != null ? i.entityManagerArray : (i.entityManagers != null ? i.entityManagers.values().toArray(new EntityManager[i.entityManagers.values().size()]) : null);
        }

        protected Object readResolve() throws ObjectStreamException {
            return new Instance(this.deploymentId, this.primaryKey, this.bean, this.interceptors, this.entityManagerArray);
        }
    }
}

