/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateless;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateless.EjbWsContext;
import org.apache.openejb.core.stateless.Instance;
import org.apache.openejb.core.stateless.StatelessContext;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LinkedListStack;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.Stack;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class StatelessInstanceManager {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    protected int poolLimit = 0;
    protected Duration timeout;
    protected int beanCount = 0;
    protected boolean strictPooling = false;
    protected final SafeToolkit toolkit = SafeToolkit.getToolkit("StatefulInstanceManager");
    private SecurityService securityService;

    public StatelessInstanceManager(SecurityService securityService, Duration timeout, int poolSize, boolean strictPooling) {
        this.securityService = securityService;
        this.poolLimit = poolSize;
        this.strictPooling = strictPooling;
        this.timeout = timeout;
        if (strictPooling && poolSize < 1) {
            throw new IllegalArgumentException("Cannot use strict pooling with a pool size less than one.  Strict pooling blocks threads till an instance in the pool is available.  Please increase the pool size or set strict pooling to false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Object getInstance(ThreadContext callContext) throws OpenEJBException {
        Object bean;
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Stack pool = data.getPool();
        if (this.strictPooling) {
            boolean acquired;
            try {
                if (this.timeout.getTime() <= 0L) {
                    data.getSemaphore().acquire();
                    acquired = true;
                } else {
                    acquired = data.getSemaphore().tryAcquire(this.timeout.getTime(), this.timeout.getUnit());
                }
            }
            catch (InterruptedException e2) {
                throw new OpenEJBException("Unexpected Interruption of current thread: ", e2);
            }
            if (!acquired) {
                throw new IllegalStateException("An invocation of the Stateless Session Bean " + deploymentInfo.getEjbName() + " has timed-out");
            }
        }
        if ((bean = pool.pop()) != null) return bean;
        Class beanClass = deploymentInfo.getBeanClass();
        ObjectRecipe objectRecipe = new ObjectRecipe(beanClass);
        objectRecipe.allow(Option.FIELD_INJECTION);
        objectRecipe.allow(Option.PRIVATE_PROPERTIES);
        objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        objectRecipe.allow(Option.NAMED_PARAMETERS);
        Operation originalOperation = callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
        try {
            try {
                SessionContext sessionContext;
                Context ctx = deploymentInfo.getJndiEnc();
                StatelessInstanceManager statelessInstanceManager = this;
                // MONITORENTER : statelessInstanceManager
                try {
                    sessionContext = (SessionContext)ctx.lookup("java:comp/EJBContext");
                }
                catch (NamingException e1) {
                    sessionContext = this.createSessionContext();
                    ctx.bind("java:comp/EJBContext", (Object)sessionContext);
                }
                if (SessionBean.class.isAssignableFrom(beanClass) || this.hasSetSessionContext(beanClass)) {
                    callContext.setCurrentOperation(Operation.INJECTION);
                    callContext.setCurrentAllowedStates(StatelessContext.getStates());
                    objectRecipe.setProperty("sessionContext", (Object)sessionContext);
                }
                statelessInstanceManager = this;
                // MONITORENTER : statelessInstanceManager
                try {
                    ctx.lookup("java:comp/WebServiceContext");
                }
                catch (NamingException e) {
                    EjbWsContext wsContext = new EjbWsContext(sessionContext);
                    ctx.bind("java:comp/WebServiceContext", (Object)wsContext);
                }
                StatelessInstanceManager.fillInjectionProperties(objectRecipe, beanClass, deploymentInfo, ctx);
                bean = objectRecipe.create(beanClass.getClassLoader());
                Map unsetProperties = objectRecipe.getUnsetProperties();
                if (unsetProperties.size() > 0) {
                    for (Object property : unsetProperties.keySet()) {
                        logger.warning("Injection: No such property '" + property + "' in class " + beanClass.getName());
                    }
                }
                HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
                for (InterceptorData interceptorData : deploymentInfo.getAllInterceptors()) {
                    if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                    Class clazz = interceptorData.getInterceptorClass();
                    ObjectRecipe interceptorRecipe = new ObjectRecipe(clazz);
                    interceptorRecipe.allow(Option.FIELD_INJECTION);
                    interceptorRecipe.allow(Option.PRIVATE_PROPERTIES);
                    interceptorRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                    interceptorRecipe.allow(Option.NAMED_PARAMETERS);
                    StatelessInstanceManager.fillInjectionProperties(interceptorRecipe, clazz, deploymentInfo, ctx);
                    try {
                        Object interceptorInstance = interceptorRecipe.create(clazz.getClassLoader());
                        interceptorInstances.put(clazz.getName(), interceptorInstance);
                    }
                    catch (ConstructionException e) {
                        throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                    }
                }
                interceptorInstances.put(beanClass.getName(), bean);
                callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
                callContext.setCurrentAllowedStates(StatelessContext.getStates());
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(bean, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
                interceptorStack.invoke(new Object[0]);
                if (bean instanceof SessionBean) {
                    callContext.setCurrentOperation(Operation.CREATE);
                    callContext.setCurrentAllowedStates(StatelessContext.getStates());
                    Method create = deploymentInfo.getCreateMethod();
                    interceptorStack = new InterceptorStack(bean, create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                    interceptorStack.invoke(new Object[0]);
                }
                bean = new Instance(bean, interceptorInstances);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                String t = "The bean instance " + bean + " threw a system exception:" + e;
                logger.error(t, e);
                throw new ApplicationException(new RemoteException("Cannot obtain a free instance.", e));
            }
            Object var20_27 = null;
            callContext.setCurrentOperation(originalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            return bean;
        }
        catch (Throwable throwable) {
            Object var20_28 = null;
            callContext.setCurrentOperation(originalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            throw throwable;
        }
    }

    private static void fillInjectionProperties(ObjectRecipe objectRecipe, Class clazz, CoreDeploymentInfo deploymentInfo, Context context) {
        boolean usePrefix = true;
        try {
            clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            usePrefix = false;
        }
        for (Injection injection : deploymentInfo.getInjections()) {
            if (!injection.getTarget().isAssignableFrom(clazz)) continue;
            try {
                String jndiName = injection.getJndiName();
                Object object = context.lookup("java:comp/env/" + jndiName);
                String prefix = usePrefix ? injection.getTarget().getName() + "/" : "";
                if (object instanceof String) {
                    String string = (String)object;
                    objectRecipe.setProperty(prefix + injection.getName(), (Object)string);
                    continue;
                }
                objectRecipe.setProperty(prefix + injection.getName(), object);
            }
            catch (NamingException e) {
                logger.warning("Injection data not found in enc: jndiName='" + injection.getJndiName() + "', target=" + injection.getTarget() + "/" + injection.getName());
            }
        }
    }

    private boolean hasSetSessionContext(Class beanClass) {
        try {
            beanClass.getMethod("setSessionContext", SessionContext.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private SessionContext createSessionContext() {
        return new StatelessContext(this.securityService);
    }

    public void poolInstance(ThreadContext callContext, Object bean) throws OpenEJBException {
        if (bean == null) {
            throw new SystemException("Invalid arguments");
        }
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Data data = (Data)deploymentInfo.getContainerData();
        Stack pool = data.getPool();
        if (this.strictPooling) {
            pool.push(bean);
            data.getSemaphore().release();
        } else if (pool.size() >= this.poolLimit) {
            this.freeInstance(callContext, (Instance)bean);
        } else {
            pool.push(bean);
        }
    }

    public void discardInstance(ThreadContext callContext) {
        if (this.strictPooling) {
            CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
            Data data = (Data)deploymentInfo.getContainerData();
            data.getSemaphore().release();
        }
    }

    private void freeInstance(ThreadContext callContext, Instance instance) {
        try {
            callContext.setCurrentOperation(Operation.PRE_DESTROY);
            callContext.setCurrentAllowedStates(StatelessContext.getStates());
            CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
            Method remove = instance.bean instanceof SessionBean ? deploymentInfo.getCreateMethod() : null;
            List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
            interceptorStack.invoke(new Object[0]);
        }
        catch (Throwable re) {
            logger.error("The bean instance " + instance + " threw a system exception:" + re, re);
        }
    }

    public void deploy(CoreDeploymentInfo deploymentInfo) {
        Data data = new Data(this.poolLimit, this.strictPooling);
        deploymentInfo.setContainerData(data);
    }

    public void undeploy(CoreDeploymentInfo deploymentInfo) {
        Data data = (Data)deploymentInfo.getContainerData();
        if (data == null) {
            return;
        }
        Stack pool = data.getPool();
        deploymentInfo.setContainerData(null);
    }

    private static final class Data {
        private final Stack pool;
        private Semaphore semaphore;

        public Data(int poolLimit, boolean strictPooling) {
            this.pool = new LinkedListStack(poolLimit);
            if (strictPooling) {
                this.semaphore = new Semaphore(poolLimit);
            }
        }

        public Stack getPool() {
            return this.pool;
        }

        public Semaphore getSemaphore() {
            return this.semaphore;
        }
    }
}

