/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class DirectoryMonitor {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_DEPLOY, DirectoryMonitor.class.getPackage().getName());
    private boolean run;
    private int pollIntervalMillis;
    private File directory;
    private Listener listener;
    private Map files = new HashMap();

    public DirectoryMonitor(File directory, Listener listener, int pollIntervalMillis, Logger logger) {
        assert (listener == null) : "No listener specified";
        assert (directory.isDirectory()) : "File specified is not a directory. " + directory.getAbsolutePath();
        assert (directory.canRead()) : "Directory specified cannot be read. " + directory.getAbsolutePath();
        assert (pollIntervalMillis > 0) : "Poll Interval must be above zero.";
        this.directory = directory;
        this.listener = listener;
        this.pollIntervalMillis = pollIntervalMillis;
    }

    public Logger getLogger() {
        return logger;
    }

    public int getPollIntervalMillis() {
        return this.pollIntervalMillis;
    }

    public File getDirectory() {
        return this.directory;
    }

    public Listener getListener() {
        return this.listener;
    }

    public synchronized boolean isRunning() {
        return this.run;
    }

    public synchronized void stop() {
        this.run = false;
    }

    public void run() {
        this.run = true;
        this.initialize();
        this.getLogger().debug("Scanner running.  Polling every " + this.pollIntervalMillis + " milliseconds.");
        while (this.run) {
            try {
                this.scanDirectory();
            }
            catch (Exception e) {
                this.getLogger().error("Scan failed.", e);
            }
            try {
                Thread.sleep(this.pollIntervalMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void initialize() {
        this.getLogger().debug("Doing initial scan of " + this.directory.getAbsolutePath());
        File parent = this.directory;
        File[] children = parent.listFiles();
        for (int i = 0; children != null && i < children.length; ++i) {
            File child = children[i];
            if (!child.canRead()) continue;
            FileInfo now = this.newInfo(child);
            now.setChanging(false);
        }
    }

    private FileInfo newInfo(File child) {
        FileInfo fileInfo = child.isDirectory() ? new DirectoryInfo(child) : new FileInfo(child);
        this.files.put(fileInfo.getPath(), fileInfo);
        return fileInfo;
    }

    public void scanDirectory() {
        File parent = this.directory;
        File[] children = parent.listFiles();
        HashSet missingFilesList = new HashSet(this.files.keySet());
        for (int i = 0; children != null && i < children.length; ++i) {
            File child = children[i];
            missingFilesList.remove(child.getAbsolutePath());
            if (!child.canRead()) {
                this.getLogger().debug("not readable " + child.getName());
                continue;
            }
            FileInfo oldStatus = this.oldInfo(child);
            FileInfo newStatus = this.newInfo(child);
            newStatus.diff(oldStatus);
            if (oldStatus == null) {
                this.getLogger().debug("File Discovered: " + newStatus);
                continue;
            }
            if (newStatus.isChanging()) {
                this.getLogger().debug("File Changing: " + newStatus);
                continue;
            }
            if (oldStatus.isNewFile()) {
                this.getLogger().info("New File: " + newStatus);
                newStatus.setNewFile(!this.listener.fileAdded(child));
                continue;
            }
            if (!oldStatus.isChanging()) continue;
            this.getLogger().info("Updated File: " + newStatus);
            this.listener.fileUpdated(child);
            missingFilesList.remove(oldStatus.getPath());
        }
        for (String path : missingFilesList) {
            this.getLogger().info("File removed: " + path);
            if (!this.listener.fileRemoved(new File(path))) continue;
            this.files.remove(path);
        }
    }

    private FileInfo oldInfo(File file) {
        return (FileInfo)this.files.get(file.getAbsolutePath());
    }

    private static class FileInfo
    implements Serializable {
        private String path;
        private long size;
        private long modified;
        private boolean newFile;
        private boolean changing;

        public FileInfo(File file) {
            this(file.getAbsolutePath(), file.length(), file.lastModified());
        }

        public FileInfo(String path, long size, long modified) {
            assert (path != null);
            this.path = path;
            this.size = size;
            this.modified = modified;
            this.newFile = true;
            this.changing = true;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getModified() {
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }

        public boolean isNewFile() {
            return this.newFile;
        }

        public void setNewFile(boolean newFile) {
            this.newFile = newFile;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public boolean isSame(FileInfo info) {
            assert (info != null);
            if (!this.path.equals(info.path)) {
                throw new IllegalArgumentException("Should only be used to compare two files representing the same path!");
            }
            return this.size == info.size && this.modified == info.modified;
        }

        public String toString() {
            return this.path;
        }

        public void diff(FileInfo old) {
            if (old != null) {
                this.changing = !this.isSame(old);
                this.newFile = old.newFile;
            }
        }
    }

    private static class DirectoryInfo
    extends FileInfo {
        public DirectoryInfo(File dir) {
            super(dir.getAbsolutePath(), 0L, DirectoryInfo.getLastModifiedInDir(dir));
        }

        private static long getLastModifiedInDir(File dir) {
            assert (dir != null);
            long value = dir.lastModified();
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                long test;
                File child = children[i];
                if (!child.canRead() || (test = child.isDirectory() ? DirectoryInfo.getLastModifiedInDir(child) : child.lastModified()) <= value) continue;
                value = test;
            }
            return value;
        }
    }

    public static interface Listener {
        public boolean fileAdded(File var1);

        public boolean fileRemoved(File var1);

        public void fileUpdated(File var1);
    }
}

