/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.beans.PropertyEditorManager;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.util.DurationEditor;
import org.apache.openejb.util.Join;

public class Duration {
    private long time;
    private TimeUnit unit;

    public Duration() {
    }

    public Duration(long time, TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    public Duration(String string) {
        Duration.parse(string, this);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public void setUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        if (this.time != duration.time) {
            return false;
        }
        return this.unit == duration.unit;
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 29 * result + (this.unit != null ? this.unit.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.unit == null) {
            return this.time + "";
        }
        return this.time + " " + (Object)((Object)this.unit);
    }

    public static Duration parse(String text) {
        Duration d = new Duration();
        Duration.parse(text, d);
        return d;
    }

    private static void parse(String text, Duration d) {
        char c;
        int i;
        text = text.trim();
        StringBuilder t = new StringBuilder();
        StringBuilder u = new StringBuilder();
        for (i = 0; i < text.length() && (Character.isDigit(c = text.charAt(i)) || i == 0 && c == '-'); ++i) {
            t.append(c);
        }
        if (t.length() == 0) {
            Duration.invalidFormat(text);
        }
        while (i < text.length() && Character.isWhitespace(c = text.charAt(i))) {
            ++i;
        }
        while (i < text.length()) {
            c = text.charAt(i);
            if (Character.isLetter(c)) {
                u.append(c);
            } else {
                Duration.invalidFormat(text);
            }
            ++i;
        }
        d.time = Integer.parseInt(t.toString());
        Unit unit = Duration.parseUnit(u.toString());
        if (unit != null) {
            switch (unit) {
                case days: {
                    d.time *= 86400L;
                    d.unit = TimeUnit.SECONDS;
                    break;
                }
                case hours: {
                    d.time *= 3600L;
                    d.unit = TimeUnit.SECONDS;
                    break;
                }
                case minutes: {
                    d.time *= 60L;
                    d.unit = TimeUnit.SECONDS;
                    break;
                }
                case seconds: {
                    d.unit = TimeUnit.SECONDS;
                    break;
                }
                case milliseconds: {
                    d.unit = TimeUnit.MILLISECONDS;
                    break;
                }
                case microseconds: {
                    d.unit = TimeUnit.MICROSECONDS;
                    break;
                }
                case nanoseconds: {
                    d.unit = TimeUnit.NANOSECONDS;
                }
            }
        }
    }

    private static void invalidFormat(String text) {
        throw new IllegalArgumentException("Illegal duration format: '" + text + "'.  Valid examples are '10s' or '10 seconds'.");
    }

    private static Unit parseUnit(String u) {
        if (u.length() == 0) {
            return null;
        }
        if (u.equalsIgnoreCase("NANOSECONDS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANOSECOND")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANOS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NANO")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("NS")) {
            return Unit.nanoseconds;
        }
        if (u.equalsIgnoreCase("MICROSECONDS")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICROSECOND")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICROS")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MICRO")) {
            return Unit.microseconds;
        }
        if (u.equalsIgnoreCase("MILLISECONDS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLISECOND")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLIS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MILLI")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("MS")) {
            return Unit.milliseconds;
        }
        if (u.equalsIgnoreCase("SECONDS")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("SECOND")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("SEC")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("S")) {
            return Unit.seconds;
        }
        if (u.equalsIgnoreCase("MINUTES")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("MINUTE")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("MIN")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("M")) {
            return Unit.minutes;
        }
        if (u.equalsIgnoreCase("HOURS")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HOUR")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HRS")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("HR")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("H")) {
            return Unit.hours;
        }
        if (u.equalsIgnoreCase("DAYS")) {
            return Unit.days;
        }
        if (u.equalsIgnoreCase("DAY")) {
            return Unit.days;
        }
        if (u.equalsIgnoreCase("D")) {
            return Unit.days;
        }
        throw new IllegalArgumentException("Unknown time unit '" + u + "'.  Supported units " + Join.join(", ", (Object[])Unit.values()));
    }

    static {
        PropertyEditorManager.registerEditor(Duration.class, DurationEditor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        nanoseconds,
        microseconds,
        milliseconds,
        seconds,
        minutes,
        hours,
        days;

    }
}

