/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlCache {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, UrlCache.class);
    public static final boolean antiJarLocking;
    public static final File cacheDir;
    private final Map<String, Map<URL, File>> cache = new TreeMap<String, Map<URL, File>>();

    public synchronized URL[] cacheUrls(String appId, URL[] urls) {
        if (!antiJarLocking) {
            return urls;
        }
        LinkedHashSet<URL> cachedUrls = new LinkedHashSet<URL>();
        LinkedList<URL> locationStack = new LinkedList<URL>(Arrays.asList(urls));
        while (!locationStack.isEmpty()) {
            URL url = locationStack.removeFirst();
            if (cachedUrls.contains(url)) continue;
            File file = this.cacheUrl(appId, url);
            if (file != null) {
                try {
                    cachedUrls.add(file.toURL());
                    List<URL> manifestClassPath = this.getManifestClassPath(url, file);
                    locationStack.addAll(0, manifestClassPath);
                }
                catch (MalformedURLException e) {
                    logger.error("Error caching url. Original jar file will be used which may result in a file lock: url=" + url, e);
                    cachedUrls.add(url);
                }
                continue;
            }
            cachedUrls.add(url);
        }
        return cachedUrls.toArray(new URL[cachedUrls.size()]);
    }

    public synchronized void releaseUrls(String appId) {
        logger.debug("Releasing URLs for application " + appId);
        Map<URL, File> urlFileMap = this.cache.remove(appId);
        if (urlFileMap != null) {
            for (File file : urlFileMap.values()) {
                if (file.delete()) {
                    logger.debug("Deleted cached file " + file);
                    continue;
                }
                logger.debug("Unable to delete cached file " + file);
            }
        }
    }

    private synchronized File cacheUrl(String appId, URL url) {
        boolean success;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        File sourceFile = URLs.toFile(url);
        if (!sourceFile.exists()) {
            return null;
        }
        if (!sourceFile.canRead()) {
            return null;
        }
        if (sourceFile.isDirectory()) {
            return sourceFile;
        }
        sourceFile = sourceFile.getAbsoluteFile();
        try {
            url = sourceFile.toURL();
        }
        catch (MalformedURLException ignored) {
            // empty catch block
        }
        Map<URL, File> appCache = this.getAppCache(appId);
        if (appCache.containsKey(url)) {
            return appCache.get(url);
        }
        if (sourceFile.getParentFile().equals(cacheDir)) {
            appCache.put(url, sourceFile);
            return sourceFile;
        }
        String name = sourceFile.getName();
        int dot = name.lastIndexOf(".");
        String prefix = name;
        String suffix = "";
        if (dot > 0) {
            prefix = name.substring(0, dot) + "-";
            suffix = name.substring(dot, name.length());
        }
        File cacheFile = null;
        try {
            cacheFile = File.createTempFile(prefix, suffix, cacheDir);
            cacheFile.deleteOnExit();
            success = JarExtractor.copy(sourceFile, cacheFile);
        }
        catch (IOException e) {
            success = false;
        }
        if (success) {
            appCache.put(url, cacheFile);
            logger.debug("Coppied jar file to " + cacheFile);
            return cacheFile;
        }
        JarExtractor.delete(cacheFile);
        logger.error("Unable to copy jar into URL cache directory. Original jar file will be used which may result in a file lock: file=" + sourceFile);
        return null;
    }

    private synchronized Map<URL, File> getAppCache(String appId) {
        Map<URL, File> urlFileMap = this.cache.get(appId);
        if (urlFileMap == null) {
            urlFileMap = new LinkedHashMap<URL, File>();
            this.cache.put(appId, urlFileMap);
        }
        return urlFileMap;
    }

    private List<URL> getManifestClassPath(URL codeSource, File location) {
        try {
            Manifest manifest = this.loadManifest(location);
            if (manifest == null) {
                return Collections.emptyList();
            }
            String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (manifestClassPath == null) {
                return Collections.emptyList();
            }
            LinkedList<URL> classPathUrls = new LinkedList<URL>();
            StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
            while (tokenizer.hasMoreTokens()) {
                String entry = tokenizer.nextToken();
                try {
                    URL entryUrl = new URL(codeSource, entry);
                    classPathUrls.addLast(entryUrl);
                }
                catch (MalformedURLException ignored) {}
            }
            return classPathUrls;
        }
        catch (IOException ignored) {
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest loadManifest(File location) throws IOException {
        if (location.isDirectory()) {
            File manifestFile = new File(location, "META-INF/MANIFEST.MF");
            if (manifestFile.isFile() && manifestFile.canRead()) {
                Manifest manifest;
                FileInputStream in = null;
                try {
                    Manifest manifest2;
                    in = new FileInputStream(manifestFile);
                    manifest = manifest2 = new Manifest(in);
                }
                catch (Throwable throwable) {
                    UrlCache.close(in);
                    throw throwable;
                }
                UrlCache.close(in);
                return manifest;
            }
        } else {
            JarFile jarFile = new JarFile(location);
            try {
                Manifest manifest;
                Manifest manifest3 = manifest = jarFile.getManifest();
                return manifest3;
            }
            finally {
                UrlCache.close(jarFile);
            }
        }
        return null;
    }

    private static File createCacheDir() {
        try {
            FileUtils openejbBase = SystemInstance.get().getBase();
            File cacheDir = null;
            if (openejbBase.getDirectory("conf").exists()) {
                try {
                    cacheDir = openejbBase.getDirectory("temp");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (cacheDir == null) {
                cacheDir = File.createTempFile("OpenEJB-temp-", "");
            }
            if (cacheDir.exists()) {
                UrlCache.deleteDir(cacheDir);
            }
            cacheDir.mkdirs();
            return cacheDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteDir(File dir) {
        if (dir == null) {
            return;
        }
        File[] fileNames = dir.listFiles();
        if (fileNames != null) {
            for (File file : fileNames) {
                if (file.isDirectory()) {
                    UrlCache.deleteDir(file);
                    continue;
                }
                if (file.delete()) {
                    logger.debug("Deleted file " + file);
                    continue;
                }
                logger.debug("Unable to delete file " + file);
            }
        }
        if (dir.delete()) {
            logger.debug("Deleted file " + dir);
        } else {
            logger.debug("Unable to delete file " + dir);
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(JarFile closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        String value = null;
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !"antiJarLocking".equalsIgnoreCase((String)entry.getKey())) continue;
            value = (String)entry.getValue();
            break;
        }
        if (value != null) {
            antiJarLocking = Boolean.valueOf(value);
        } else {
            boolean embedded = false;
            try {
                FileUtils openejbBase = SystemInstance.get().getBase();
                embedded = !openejbBase.getDirectory("conf").exists();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            boolean bl = antiJarLocking = !embedded && System.getProperty("os.name", "unknown").toLowerCase().startsWith("windows");
        }
        if (antiJarLocking) {
            cacheDir = UrlCache.createCacheDir();
            logger.info("AntiJarLocking enabled. Using URL cache dir " + cacheDir);
        } else {
            cacheDir = null;
        }
    }
}

