/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.beans.Introspector;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import org.apache.openejb.core.TempClassLoader;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.UrlCache;

public class ClassLoaderUtil {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, ClassLoaderUtil.class);
    private static final Map<String, List<ClassLoader>> classLoadersByApp = new HashMap<String, List<ClassLoader>>();
    private static final Map<ClassLoader, Set<String>> appsByClassLoader = new HashMap<ClassLoader, Set<String>>();
    private static final UrlCache urlCache = new UrlCache();

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static URLClassLoader createClassLoader(String appId, URL[] urls, ClassLoader parent) {
        urls = urlCache.cacheUrls(appId, urls);
        URLClassLoader classLoader = new URLClassLoader(urls, parent);
        List<ClassLoader> classLoaders = classLoadersByApp.get(appId);
        if (classLoaders == null) {
            classLoaders = new ArrayList<ClassLoader>(2);
            classLoadersByApp.put(appId, classLoaders);
        }
        classLoaders.add(classLoader);
        Set<String> apps = appsByClassLoader.get(classLoader);
        if (apps == null) {
            apps = new LinkedHashSet<String>(1);
            appsByClassLoader.put(classLoader, apps);
        }
        apps.add(appId);
        return classLoader;
    }

    public static void destroyClassLoader(ClassLoader classLoader) {
        logger.debug("Destroying classLoader " + ClassLoaderUtil.toString(classLoader));
        Set<String> apps = appsByClassLoader.remove(classLoader);
        if (apps != null) {
            for (String appId : apps) {
                List<ClassLoader> classLoaders = classLoadersByApp.get(appId);
                if (classLoaders == null) continue;
                classLoaders.remove(classLoader);
                if (!classLoaders.isEmpty()) continue;
                ClassLoaderUtil.destroyClassLoader(appId);
            }
        }
        ClassLoaderUtil.cleanOpenJPACache(classLoader);
    }

    public static void destroyClassLoader(String appId) {
        logger.debug("Destroying classLoaders for application " + appId);
        List<ClassLoader> classLoaders = classLoadersByApp.remove(appId);
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                Set<String> apps = appsByClassLoader.get(classLoader);
                if (apps == null) {
                    apps = Collections.emptySet();
                }
                apps.remove(appId);
                if (apps.isEmpty()) {
                    appsByClassLoader.remove(classLoader);
                    ClassLoaderUtil.destroyClassLoader(classLoader);
                    continue;
                }
                logger.debug("ClassLoader " + ClassLoaderUtil.toString(classLoader) + " held open by the applications" + apps);
            }
        }
        urlCache.releaseUrls(appId);
        ClassLoaderUtil.clearSunJarFileFactoryCache(appId);
    }

    public static URLClassLoader createTempClassLoader(ClassLoader parent) {
        return new TempClassLoader(parent);
    }

    public static URLClassLoader createTempClassLoader(String appId, URL[] urls, ClassLoader parent) {
        URLClassLoader classLoader = ClassLoaderUtil.createClassLoader(appId, urls, parent);
        TempClassLoader tempClassLoader = new TempClassLoader(classLoader);
        return tempClassLoader;
    }

    public static void clearClassLoaderCaches() {
        ClassLoaderUtil.clearSunSoftCache(ObjectInputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectOutputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "localDescs");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
    }

    public static void clearSunJarFileFactoryCache(String jarLocation) {
        logger.debug("Clearing Sun JarFileFactory cache for directory " + jarLocation);
        try {
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCacheField = jarFileFactory.getDeclaredField("fileCache");
            fileCacheField.setAccessible(true);
            Map fileCache = (Map)fileCacheField.get(null);
            Field urlCacheField = jarFileFactory.getDeclaredField("urlCache");
            urlCacheField.setAccessible(true);
            Map urlCache = (Map)urlCacheField.get(null);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object item : fileCache.keySet()) {
                URL url = null;
                if (item instanceof URL) {
                    url = (URL)item;
                } else if (item instanceof String) {
                    url = new URI((String)item).toURL();
                } else {
                    logger.warning("Don't know how to handle object: " + item.toString() + " of type: " + item.getClass().getCanonicalName() + " in Sun JarFileFactory cache, skipping");
                }
                File file = null;
                try {
                    file = URLs.toFile(url);
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                if (url == null || !ClassLoaderUtil.isParent(jarLocation, file)) continue;
                urls.add(url);
            }
            for (URL url : urls) {
                JarFile jarFile = (JarFile)fileCache.remove(url);
                if (jarFile == null) continue;
                urlCache.remove(jarFile);
                jarFile.close();
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (Throwable e) {
            logger.error("Unable to clear Sun JarFileFactory cache", e);
        }
    }

    private static boolean isParent(String jarLocation, File file) {
        File dir = new File(jarLocation);
        while (file != null) {
            if (file.equals(dir)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSunSoftCache(Class clazz, String fieldName) {
        Map cache = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            cache = (Map)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cache != null) {
            Map map = cache;
            synchronized (map) {
                cache.clear();
            }
        }
    }

    public static void cleanOpenJPACache(ClassLoader classLoader) {
        try {
            Class<?> pcRegistryClass = ClassLoaderUtil.class.getClassLoader().loadClass("org.apache.openjpa.enhance.PCRegistry");
            Method deRegisterMethod = pcRegistryClass.getMethod("deRegister", ClassLoader.class);
            deRegisterMethod.invoke(null, classLoader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String toString(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        return classLoader.getClass().getSimpleName() + "@" + System.identityHashCode(classLoader);
    }
}

