/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodPermissionInfo;
import org.apache.openejb.assembler.classic.MethodTransactionInfo;
import org.apache.openejb.util.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfoUtil {
    public static List<Method> matchingMethods(Method signature, Class clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        block0: for (Method method : clazz.getMethods()) {
            Class<?>[] signatureTypes;
            Class<?>[] methodTypes;
            if (!method.getName().equals(signature.getName()) || (methodTypes = method.getParameterTypes()).length != (signatureTypes = signature.getParameterTypes()).length) continue;
            for (int i = 0; i < methodTypes.length; ++i) {
                if (!methodTypes[i].equals(signatureTypes[i])) continue block0;
            }
            list.add(method);
        }
        return list;
    }

    public static List<Method> matchingMethods(MethodInfo mi, Class clazz) {
        Method[] methods = clazz.getMethods();
        return MethodInfoUtil.matchingMethods(mi, methods);
    }

    public static List<Method> matchingMethods(MethodInfo mi, Method[] methods) {
        List<Method> filtered = MethodInfoUtil.filterByLevel(mi, methods);
        filtered = MethodInfoUtil.filterByView(mi, filtered);
        return filtered;
    }

    private static List<Method> filterByView(MethodInfo mi, List<Method> filtered) {
        View view = MethodInfoUtil.view(mi);
        switch (view) {
            case CLASS: {
                return MethodInfoUtil.filterByClass(mi, filtered);
            }
        }
        return filtered;
    }

    private static List<Method> filterByClass(MethodInfo mi, List<Method> methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            String className = method.getDeclaringClass().getName();
            if (!mi.className.equals(className)) continue;
            list.add(method);
        }
        return list;
    }

    private static List<Method> filterByLevel(MethodInfo mi, Method[] methods) {
        Level level = MethodInfoUtil.level(mi);
        switch (level) {
            case BEAN: 
            case PACKAGE: {
                return Arrays.asList(methods);
            }
            case OVERLOADED_METHOD: {
                return MethodInfoUtil.filterByName(methods, mi.methodName);
            }
            case EXACT_METHOD: {
                return MethodInfoUtil.filterByNameAndParams(methods, mi);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static Method getMethod(Class clazz, MethodInfo info) {
        ClassLoader cl = clazz.getClassLoader();
        ArrayList<Class> params = new ArrayList<Class>();
        for (String methodParam : info.methodParams) {
            try {
                params.add(MethodInfoUtil.getClassForParam(methodParam, cl));
            }
            catch (ClassNotFoundException cnfe) {}
        }
        Method method = null;
        try {
            method = clazz.getMethod(info.methodName, params.toArray(new Class[params.size()]));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!info.className.equals("*") && !method.getDeclaringClass().getName().equals(info.className)) {
            return null;
        }
        return method;
    }

    private static List<Method> filterByName(Method[] methods, String methodName) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            list.add(method);
        }
        return list;
    }

    private static List<Method> filterByNameAndParams(Method[] methods, MethodInfo mi) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (!MethodInfoUtil.matches(method, mi)) continue;
            list.add(method);
        }
        return list;
    }

    public static List<MethodPermissionInfo> normalizeMethodPermissionInfos(List<MethodPermissionInfo> infos) {
        ArrayList<MethodPermissionInfo> normalized = new ArrayList<MethodPermissionInfo>();
        for (MethodPermissionInfo oldInfo : infos) {
            for (MethodInfo methodInfo : oldInfo.methods) {
                MethodPermissionInfo newInfo = new MethodPermissionInfo();
                newInfo.description = oldInfo.description;
                newInfo.methods.add(methodInfo);
                newInfo.roleNames.addAll(oldInfo.roleNames);
                newInfo.unchecked = oldInfo.unchecked;
                newInfo.excluded = oldInfo.excluded;
                normalized.add(newInfo);
            }
        }
        Collections.sort(normalized, new MethodPermissionComparator());
        return normalized;
    }

    private static Class getClassForParam(String className, ClassLoader cl) throws ClassNotFoundException {
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        return Class.forName(className, false, cl);
    }

    public static Map<Method, MethodAttributeInfo> resolveAttributes(List<? extends MethodAttributeInfo> infos, DeploymentInfo deploymentInfo) {
        LinkedHashMap<Method, MethodAttributeInfo> attributes = new LinkedHashMap<Method, MethodAttributeInfo>();
        Method[] wildCardView = MethodInfoUtil.getWildCardView(deploymentInfo).toArray(new Method[0]);
        for (MethodAttributeInfo methodAttributeInfo : infos) {
            for (MethodInfo methodInfo : methodAttributeInfo.methods) {
                if (methodInfo.ejbName != null && !methodInfo.ejbName.equals("*") && !methodInfo.ejbName.equals(deploymentInfo.getEjbName())) continue;
                ArrayList<Method> methods = new ArrayList<Method>();
                if (methodInfo.methodIntf == null) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, wildCardView));
                } else if (methodInfo.methodIntf.equals("Home")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, deploymentInfo.getHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Remote")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, deploymentInfo.getRemoteInterface()));
                    for (Class intf : deploymentInfo.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("LocalHome")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, deploymentInfo.getLocalHomeInterface()));
                } else if (methodInfo.methodIntf.equals("Local")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, deploymentInfo.getLocalInterface()));
                    for (Class intf : deploymentInfo.getBusinessRemoteInterfaces()) {
                        methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, intf));
                    }
                } else if (methodInfo.methodIntf.equals("ServiceEndpoint")) {
                    methods.addAll(MethodInfoUtil.matchingMethods(methodInfo, deploymentInfo.getServiceEndpointInterface()));
                }
                for (Method method : methods) {
                    if ((method.getDeclaringClass() == EJBObject.class || method.getDeclaringClass() == EJBHome.class) && !method.getName().equals("remove")) continue;
                    attributes.put(method, methodAttributeInfo);
                }
            }
        }
        return attributes;
    }

    private static List<Method> getWildCardView(DeploymentInfo info) {
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Method> beanMethods = Arrays.asList(info.getBeanClass().getMethods());
        methods.addAll(beanMethods);
        if (info.getRemoteInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getRemoteInterface().getMethods()));
        }
        if (info.getHomeInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getHomeInterface().getMethods()));
        }
        if (info.getLocalInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getLocalInterface().getMethods()));
        }
        if (info.getLocalHomeInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getLocalHomeInterface().getMethods()));
        }
        if (info.getMdbInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getMdbInterface().getMethods()));
        }
        if (info.getServiceEndpointInterface() != null) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, info.getServiceEndpointInterface().getMethods()));
        }
        for (Class intf : info.getBusinessRemoteInterfaces()) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, intf.getMethods()));
        }
        for (Class intf : info.getBusinessLocalInterfaces()) {
            methods.addAll(MethodInfoUtil.exclude(beanMethods, intf.getMethods()));
        }
        return methods;
    }

    private static List<Method> exclude(List<Method> excludes, Method[] methods) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method method : methods) {
            if (MethodInfoUtil.matches(excludes, method)) continue;
            list.add(method);
        }
        return list;
    }

    private static boolean matches(List<Method> excludes, Method method) {
        for (Method excluded : excludes) {
            boolean match = MethodInfoUtil.match(method, excluded);
            if (!match) continue;
            return true;
        }
        return false;
    }

    public static boolean match(Method methodA, Method methodB) {
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        if (methodA.getParameterTypes().length != methodB.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < methodA.getParameterTypes().length; ++i) {
            Class<?> b;
            Class<?> a = methodA.getParameterTypes()[i];
            if (a.equals(b = methodB.getParameterTypes()[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(Method method, MethodInfo methodInfo) {
        if (!methodInfo.methodName.equals(method.getName())) {
            return false;
        }
        List<String> methodParams = methodInfo.methodParams;
        if (methodParams == null) {
            return true;
        }
        if (methodParams.size() != method.getParameterTypes().length) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            String methodParam = methodParams.get(i);
            if (methodParam.equals(MethodInfoUtil.getName(parameterType))) continue;
            return false;
        }
        return true;
    }

    private static String getName(Class<?> type) {
        if (type.isArray()) {
            return MethodInfoUtil.getName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    public static View view(MethodInfo methodInfo) {
        if (!methodInfo.className.equals("*")) {
            return View.CLASS;
        }
        if (methodInfo.methodIntf != null && !methodInfo.methodIntf.equals("*")) {
            return View.INTERFACE;
        }
        return View.ANY;
    }

    public static Level level(MethodInfo methodInfo) {
        if (methodInfo.ejbName.equals("*")) {
            return Level.PACKAGE;
        }
        if (methodInfo.methodName.equals("*")) {
            return Level.BEAN;
        }
        if (methodInfo.methodParams == null) {
            return Level.OVERLOADED_METHOD;
        }
        return Level.EXACT_METHOD;
    }

    public static String toString(MethodInfo i) {
        String s = i.ejbName;
        s = s + " : ";
        s = s + (i.methodIntf == null ? "*" : i.methodIntf);
        s = s + " : ";
        s = s + i.className;
        s = s + " : ";
        s = s + i.methodName;
        s = s + "(";
        s = i.methodParams != null ? s + Join.join(", ", i.methodParams) : s + "*";
        s = s + ")";
        return s;
    }

    public static String toString(MethodPermissionInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = i.unchecked ? s + " Unchecked" : (i.excluded ? s + " Excluded" : s + " " + Join.join(", ", i.roleNames));
        return s;
    }

    public static String toString(MethodTransactionInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = s + " " + i.transAttribute;
        return s;
    }

    public static String toString(MethodConcurrencyInfo i) {
        String s = MethodInfoUtil.toString((MethodInfo)i.methods.get(0));
        s = s + " " + i.concurrencyAttribute;
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BaseComparator<T>
    implements Comparator<T> {
        @Override
        public int compare(MethodInfo am, MethodInfo bm) {
            Level levelB;
            Level levelA = MethodInfoUtil.level(am);
            if (levelA != (levelB = MethodInfoUtil.level(bm))) {
                return levelA.ordinal() - levelB.ordinal();
            }
            return MethodInfoUtil.view(am).ordinal() - MethodInfoUtil.view(bm).ordinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodPermissionComparator
    extends BaseComparator<MethodPermissionInfo> {
        @Override
        public int compare(MethodPermissionInfo a, MethodPermissionInfo b) {
            return this.compare((MethodInfo)a.methods.get(0), (MethodInfo)b.methods.get(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum View {
        CLASS,
        ANY,
        INTERFACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        PACKAGE,
        BEAN,
        OVERLOADED_METHOD,
        EXACT_METHOD;

    }
}

