/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.xbean.finder.ResourceFinder;

public class ConfigUtils {
    public static Messages messages = new Messages("org.apache.openejb.util.resources");
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");

    public static String searchForConfiguration() throws OpenEJBException {
        return ConfigUtils.searchForConfiguration(SystemInstance.get().getProperty("openejb.configuration"));
    }

    public static String searchForConfiguration(String path) throws OpenEJBException {
        return ConfigUtils.searchForConfiguration(path, SystemInstance.get().getProperties());
    }

    public static String searchForConfiguration(String path, Properties props) throws OpenEJBException {
        File file = null;
        if (path != null) {
            file = new File(path);
            if (file != null && file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            try {
                file = SystemInstance.get().getBase().getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                file = SystemInstance.get().getHome().getFile(path);
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException ignored) {
                // empty catch block
            }
            try {
                new URL(path);
                return path;
            }
            catch (MalformedURLException ignored) {
                logger.warning("Cannot find the configuration file [" + path + "], Trying conf/openejb.xml instead.");
            }
        }
        try {
            try {
                file = SystemInstance.get().getBase().getFile("conf/openejb.xml");
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            try {
                file = SystemInstance.get().getBase().getFile("conf/openejb.conf");
                if (file != null && file.exists() && file.isFile()) {
                    return file.getAbsolutePath();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            File confDir = SystemInstance.get().getBase().getDirectory("conf", false);
            if (confDir.exists()) {
                File config = new File(confDir, "openejb.xml");
                logger.info("Cannot find the configuration file [conf/openejb.xml].  Creating one at " + config.getAbsolutePath());
                file = ConfigUtils.createConfig(config);
            } else {
                logger.info("Cannot find the configuration file [conf/openejb.xml].  Will attempt to create one for the beans deployed.");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OpenEJBException("Could not locate config file: ", e);
        }
        return file == null ? null : file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createConfig(File config) throws IOException {
        OutputStream out;
        block6: {
            InputStream in = null;
            out = null;
            try {
                int b;
                ResourceFinder finder = new ResourceFinder("");
                URL defaultConfig = finder.find("default.openejb.conf");
                in = defaultConfig.openStream();
                out = new FileOutputStream(config);
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                Object var7_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
        return config;
    }

    public static boolean addDeploymentEntryToConfig(String jarLocation, Openejb config) {
        File jar = new File(jarLocation);
        for (Deployments d : config.getDeployments()) {
            File target;
            if (d.getJar() != null) {
                try {
                    target = SystemInstance.get().getBase().getFile(d.getJar(), false);
                    if (!jar.equals(target)) continue;
                    return false;
                }
                catch (IOException e) {
                    continue;
                }
            }
            if (d.getDir() == null) continue;
            try {
                target = SystemInstance.get().getBase().getFile(d.getDir(), false);
                File jarDir = jar.getAbsoluteFile().getParentFile();
                if (jarDir == null || !jarDir.equals(target)) continue;
                return false;
            }
            catch (IOException e) {
            }
        }
        Deployments dep = JaxbOpenejb.createDeployments();
        dep.setJar(jarLocation);
        config.getDeployments().add(dep);
        return true;
    }
}

