/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ListIterator;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.InfoObject;
import org.apache.openejb.assembler.classic.InjectableInfo;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodPermissionInfo;
import org.apache.openejb.assembler.classic.MethodTransactionInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.SecurityRoleInfo;

public class ConfigurationPrinter {
    public static String[] tabs = new String[]{"", " ", "    ", "      ", "        ", "          "};

    public static void printConf(OpenEjbConfiguration conf) {
        ConfigurationPrinter.out(0, "CONFIGURATION");
        ConfigurationPrinter.out(1, conf.containerSystem.containers.size());
        for (ContainerInfo container : conf.containerSystem.containers) {
            ConfigurationPrinter.out(1, "className    ", container.className);
            ConfigurationPrinter.out(1, "codebase     ", container.codebase);
            ConfigurationPrinter.out(1, "containerName", container.id);
            ConfigurationPrinter.out(1, "description  ", container.description);
            ConfigurationPrinter.out(1, "displayName  ", container.displayName);
            ConfigurationPrinter.out(1, "properties   ");
            container.properties.list(System.out);
        }
        for (AppInfo app : conf.containerSystem.applications) {
            for (EjbJarInfo ejbJar : app.ejbJars) {
                String methodParam;
                ListIterator<String> paramIterator;
                ListIterator<InfoObject> iterator;
                ConfigurationPrinter.out(1, "ejbeans      ", ejbJar.enterpriseBeans.size());
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    ConfigurationPrinter.out(2, "codebase       ", bean.codebase);
                    ConfigurationPrinter.out(2, "description    ", bean.description);
                    ConfigurationPrinter.out(2, "displayName    ", bean.displayName);
                    ConfigurationPrinter.out(2, "ejbClass       ", bean.ejbClass);
                    ConfigurationPrinter.out(2, "ejbDeploymentId", bean.ejbDeploymentId);
                    ConfigurationPrinter.out(2, "ejbName        ", bean.ejbName);
                    ConfigurationPrinter.out(2, "home           ", bean.home);
                    ConfigurationPrinter.out(2, "largeIcon      ", bean.largeIcon);
                    ConfigurationPrinter.out(2, "remote         ", bean.remote);
                    ConfigurationPrinter.out(2, "smallIcon      ", bean.smallIcon);
                    ConfigurationPrinter.out(2, "transactionType", bean.transactionType);
                    ConfigurationPrinter.out(2, "type           ", bean.type);
                    JndiEncInfo jndiEnc = bean.jndiEnc;
                    ConfigurationPrinter.out(2, "jndiEnc        ", jndiEnc);
                    ConfigurationPrinter.out(2, "envEntries     ", jndiEnc.envEntries.size());
                    ListIterator<InjectableInfo> iterator2 = jndiEnc.envEntries.listIterator();
                    while (iterator2.hasNext()) {
                        EnvEntryInfo envEntry = iterator2.next();
                        ConfigurationPrinter.out(3, "--[" + iterator2.previousIndex() + "]----------------------");
                        ConfigurationPrinter.out(3, "name  ", envEntry.name);
                        ConfigurationPrinter.out(3, "type  ", envEntry.type);
                        ConfigurationPrinter.out(3, "value ", envEntry.value);
                    }
                    ConfigurationPrinter.out(2, "ejbReferences  ", jndiEnc.ejbReferences.size());
                    iterator2 = jndiEnc.ejbReferences.listIterator();
                    while (iterator2.hasNext()) {
                        EjbReferenceInfo ejbReference = (EjbReferenceInfo)iterator2.next();
                        ConfigurationPrinter.out(3, "--[" + iterator2.previousIndex() + "]----------------------");
                        ConfigurationPrinter.out(3, "homeType        ", ejbReference.homeClassName);
                        ConfigurationPrinter.out(3, "referenceName   ", ejbReference.referenceName);
                        ConfigurationPrinter.out(3, "ejbDeploymentId ", ejbReference.ejbDeploymentId);
                        if (ejbReference.location == null) continue;
                        ConfigurationPrinter.out(3, "location        ", ejbReference.location);
                        ConfigurationPrinter.out(3, "jndiContextId   ", ejbReference.location.jndiProviderId);
                        ConfigurationPrinter.out(3, "remoteRefName   ", ejbReference.location.jndiName);
                    }
                    ConfigurationPrinter.out(2, "resourceRefs   ", jndiEnc.resourceRefs.size());
                    iterator2 = jndiEnc.resourceRefs.listIterator();
                    while (iterator2.hasNext()) {
                        ResourceReferenceInfo resourceRef = (ResourceReferenceInfo)iterator2.next();
                        ConfigurationPrinter.out(3, "--[" + iterator2.previousIndex() + "]----------------------");
                        ConfigurationPrinter.out(3, "referenceAuth   ", resourceRef.referenceAuth);
                        ConfigurationPrinter.out(3, "referenceName   ", resourceRef.referenceName);
                        ConfigurationPrinter.out(3, "referenceType   ", resourceRef.referenceType);
                        if (resourceRef.location == null) continue;
                        ConfigurationPrinter.out(3, "location        ", resourceRef.location);
                        ConfigurationPrinter.out(3, "jndiContextId   ", resourceRef.location.jndiName);
                        ConfigurationPrinter.out(3, "remoteRefName   ", resourceRef.location.jndiProviderId);
                    }
                }
                if (!ejbJar.securityRoles.isEmpty()) {
                    ConfigurationPrinter.out(0, "--Security Roles------------");
                    iterator = ejbJar.securityRoles.listIterator();
                    while (iterator.hasNext()) {
                        SecurityRoleInfo securityRole = iterator.next();
                        ConfigurationPrinter.out(1, "--[" + iterator.previousIndex() + "]----------------------");
                        ConfigurationPrinter.out(1, "            ", securityRole);
                        ConfigurationPrinter.out(1, "description ", securityRole.description);
                        ConfigurationPrinter.out(1, "roleName    ", securityRole.roleName);
                    }
                }
                if (!ejbJar.methodPermissions.isEmpty()) {
                    ConfigurationPrinter.out(0, "--Method Permissions--------");
                    iterator = ejbJar.methodPermissions.listIterator();
                    while (iterator.hasNext()) {
                        MethodPermissionInfo methodPermission = (MethodPermissionInfo)iterator.next();
                        ConfigurationPrinter.out(1, "--[" + iterator.previousIndex() + "]----------------------");
                        ConfigurationPrinter.out(1, "            ", methodPermission);
                        ConfigurationPrinter.out(1, "description ", methodPermission.description);
                        ConfigurationPrinter.out(1, "roleNames   ", methodPermission.roleNames);
                        if (methodPermission.roleNames != null) {
                            ListIterator<String> roleNameIterator = methodPermission.roleNames.listIterator();
                            while (roleNameIterator.hasNext()) {
                                String roleName = roleNameIterator.next();
                                ConfigurationPrinter.out(1, "roleName[" + roleNameIterator.previousIndex() + "]   ", roleName);
                            }
                        }
                        ConfigurationPrinter.out(1, "methods     ", methodPermission.methods);
                        if (methodPermission.methods == null) continue;
                        for (MethodInfo methodInfo : methodPermission.methods) {
                            ConfigurationPrinter.out(2, "description    ", methodInfo.description);
                            ConfigurationPrinter.out(2, "ejbDeploymentId", methodInfo.ejbDeploymentId);
                            ConfigurationPrinter.out(2, "methodIntf     ", methodInfo.methodIntf);
                            ConfigurationPrinter.out(2, "methodName     ", methodInfo.methodName);
                            if (methodInfo.methodParams == null) continue;
                            ConfigurationPrinter.out(2, "methodParams   ", methodInfo.methodParams);
                            paramIterator = methodInfo.methodParams.listIterator();
                            while (paramIterator.hasNext()) {
                                methodParam = paramIterator.next();
                                ConfigurationPrinter.out(3, "param[" + paramIterator.previousIndex() + "]", methodParam);
                            }
                        }
                    }
                }
                if (ejbJar.methodTransactions.isEmpty()) continue;
                ConfigurationPrinter.out(0, "--Method Transactions-------");
                iterator = ejbJar.methodTransactions.listIterator();
                while (iterator.hasNext()) {
                    MethodTransactionInfo methodTransaction = (MethodTransactionInfo)iterator.next();
                    ConfigurationPrinter.out(1, "--[" + iterator.previousIndex() + "]----------------------");
                    ConfigurationPrinter.out(1, "               ", methodTransaction);
                    ConfigurationPrinter.out(1, "description    ", methodTransaction.description);
                    ConfigurationPrinter.out(1, "transAttribute ", methodTransaction.transAttribute);
                    ConfigurationPrinter.out(1, "methods        ", methodTransaction.methods);
                    for (MethodInfo methodInfo : methodTransaction.methods) {
                        ConfigurationPrinter.out(2, "description    ", methodInfo.description);
                        ConfigurationPrinter.out(2, "ejbDeploymentId", methodInfo.ejbDeploymentId);
                        ConfigurationPrinter.out(2, "methodIntf     ", methodInfo.methodIntf);
                        ConfigurationPrinter.out(2, "methodName     ", methodInfo.methodName);
                        if (methodInfo.methodParams == null) continue;
                        ConfigurationPrinter.out(2, "methodParams   ", methodInfo.methodParams);
                        paramIterator = methodInfo.methodParams.listIterator();
                        while (paramIterator.hasNext()) {
                            methodParam = paramIterator.next();
                            ConfigurationPrinter.out(3, "param[" + paramIterator.previousIndex() + "]", methodParam);
                        }
                    }
                }
            }
        }
    }

    private static void out(int t, String m) {
        System.out.println(tabs[t] + m);
    }

    private static void out(int t, String m, String n) {
        System.out.println(tabs[t] + m + " = " + n);
    }

    private static void out(int t, String m, boolean n) {
        System.out.println(tabs[t] + m + " = " + n);
    }

    private static void out(int t, String m, int n) {
        System.out.println(tabs[t] + m + " = " + n);
    }

    private static void out(int t, String m, Object n) {
        System.out.println(tabs[t] + m + " = " + n);
    }

    private static void out(int t, int m) {
        System.out.println(tabs[t] + m);
    }
}

