/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.apache.xbean.finder.ResourceFinder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DTDResolver
implements EntityResolver {
    public static HashMap dtds = new HashMap();

    public static byte[] getDtd(String dtdName) {
        try {
            int count;
            ResourceFinder finder = new ResourceFinder("schema/");
            URL dtd = finder.find(dtdName);
            InputStream in = dtd.openStream();
            if (in == null) {
                return null;
            }
            byte[] buf = new byte[512];
            in = new BufferedInputStream(in);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((count = in.read(buf)) > -1) {
                out.write(buf, 0, count);
            }
            in.close();
            out.close();
            return out.toByteArray();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        byte[] data;
        int pos = systemId.lastIndexOf(47);
        if (pos != -1) {
            systemId = systemId.substring(pos + 1);
        }
        if ((data = (byte[])dtds.get(systemId)) != null) {
            return new InputSource(new ByteArrayInputStream(data));
        }
        return null;
    }

    static {
        byte[] bytes = DTDResolver.getDtd("ejb-jar_1_1.dtd");
        if (bytes != null) {
            dtds.put("ejb-jar.dtd", bytes);
            dtds.put("ejb-jar_1_1.dtd", bytes);
        }
        if ((bytes = DTDResolver.getDtd("ejb-jar_2_0.dtd")) != null) {
            dtds.put("ejb-jar_2_0.dtd", bytes);
        }
    }
}

