/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.bind.JAXBException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.Module;
import org.apache.openejb.jee.ParamValue;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AnnotationFinder;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.UrlCache;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentLoader {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    private static final String OPENEJB_ALTDD_PREFIX = "openejb.altdd.prefix";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppModule load(File jarFile) throws OpenEJBException {
        AppModule appModule6;
        URLClassLoader doNotUseClassLoader;
        block22: {
            AppModule appModule;
            block21: {
                block20: {
                    block19: {
                        block18: {
                            AppModule e4222;
                            block17: {
                                String jarPath;
                                try {
                                    jarPath = jarFile.getCanonicalPath();
                                }
                                catch (IOException e2) {
                                    throw new OpenEJBException("Invalid application file path " + jarFile);
                                }
                                URL baseUrl = DeploymentLoader.getFileUrl(jarFile);
                                doNotUseClassLoader = ClassLoaderUtil.createClassLoader(jarPath, new URL[]{baseUrl}, OpenEJB.class.getClassLoader());
                                try {
                                    String jarLocation;
                                    URLClassLoader classLoader;
                                    Class<? extends DeploymentModule> moduleClass;
                                    File tmpFile = null;
                                    try {
                                        try {
                                            URL tempURL = baseUrl;
                                            if (jarFile.isFile() && UrlCache.cacheDir != null && !jarFile.getName().endsWith(".ear") && !jarFile.getName().endsWith(".war") && !jarFile.getName().endsWith(".rar")) {
                                                try {
                                                    tmpFile = File.createTempFile("AppModule-", "", UrlCache.cacheDir);
                                                    JarExtractor.copy(URLs.toFile(baseUrl), tmpFile);
                                                    tempURL = tmpFile.toURI().toURL();
                                                }
                                                catch (Exception e3) {
                                                    throw new OpenEJBException(e3);
                                                }
                                            }
                                            moduleClass = DeploymentLoader.discoverModuleType(tempURL, (ClassLoader)ClassLoaderUtil.createTempClassLoader(doNotUseClassLoader), true);
                                        }
                                        catch (Exception e4222) {
                                            throw new UnknownModuleTypeException("Unable to determine module type for jar: " + baseUrl.toExternalForm(), e4222);
                                        }
                                        appModule = null;
                                        if (tmpFile != null) {
                                            tmpFile.delete();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var10_17 = null;
                                        if (tmpFile == null) throw throwable;
                                        tmpFile.delete();
                                        throw throwable;
                                    }
                                    if (AppModule.class.equals(moduleClass)) {
                                        e4222 = DeploymentLoader.createAppModule(jarFile, jarPath);
                                        Object var12_24 = null;
                                        break block17;
                                    }
                                    if (EjbModule.class.equals(moduleClass)) {
                                        classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, OpenEJB.class.getClassLoader());
                                        EjbModule ejbModule = DeploymentLoader.createEjbModule(baseUrl, jarPath, classLoader, null);
                                        AppModule appModule2 = new AppModule(ejbModule.getClassLoader(), ejbModule.getJarLocation());
                                        appModule2.getEjbModules().add(ejbModule);
                                        DeploymentLoader.addPersistenceUnits(appModule2, baseUrl);
                                        appModule = appModule2;
                                        break block18;
                                    }
                                    if (ClientModule.class.equals(moduleClass)) {
                                        jarLocation = URLs.toFilePath(baseUrl);
                                        ClientModule clientModule = DeploymentLoader.createClientModule(baseUrl, jarLocation, OpenEJB.class.getClassLoader(), null);
                                        AppModule appModule3 = new AppModule(clientModule.getClassLoader(), jarLocation);
                                        appModule3.getClientModules().add(clientModule);
                                        appModule = appModule3;
                                        break block19;
                                    }
                                    if (ConnectorModule.class.equals(moduleClass)) {
                                        jarLocation = URLs.toFilePath(baseUrl);
                                        ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, OpenEJB.class.getClassLoader(), null);
                                        AppModule appModule4 = new AppModule(connectorModule.getClassLoader(), jarLocation);
                                        appModule4.getResourceModules().add(connectorModule);
                                        appModule = appModule4;
                                        break block20;
                                    }
                                    if (WebModule.class.equals(moduleClass)) {
                                        String moduleId = URLs.toFile(baseUrl).getName();
                                        String warPath = URLs.toFilePath(baseUrl);
                                        AppModule appModule5 = new AppModule(OpenEJB.class.getClassLoader(), warPath);
                                        DeploymentLoader.addWebModule(appModule5, warPath, OpenEJB.class.getClassLoader(), null, moduleId);
                                        appModule = appModule5;
                                        break block21;
                                    }
                                    if (!PersistenceModule.class.equals(moduleClass)) throw new UnsupportedModuleTypeException("Unsupported module type: " + moduleClass.getSimpleName());
                                    classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, OpenEJB.class.getClassLoader());
                                    AppModule appModule2 = new AppModule(classLoader, jarPath);
                                    DeploymentLoader.addPersistenceUnits(appModule2, baseUrl);
                                    appModule6 = appModule2;
                                    break block22;
                                }
                                catch (Throwable throwable) {
                                    Object var12_30 = null;
                                    ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                    throw throwable;
                                }
                            }
                            ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                            return e4222;
                        }
                        Object var12_25 = null;
                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                        return appModule;
                    }
                    Object var12_26 = null;
                    ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                    return appModule;
                }
                Object var12_27 = null;
                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                return appModule;
            }
            Object var12_28 = null;
            ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
            return appModule;
        }
        Object var12_29 = null;
        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
        return appModule6;
    }

    protected static AppModule createAppModule(File jarFile, String jarPath) throws OpenEJBException {
        File appDir = DeploymentLoader.unpack(jarFile);
        try {
            appDir = appDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new OpenEJBException("Invalid application directory " + appDir.getAbsolutePath());
        }
        URL appUrl = DeploymentLoader.getFileUrl(appDir);
        String appId = appDir.getAbsolutePath();
        URLClassLoader tmpClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{appUrl}, OpenEJB.class.getClassLoader());
        ResourceFinder finder = new ResourceFinder("", (ClassLoader)tmpClassLoader, new URL[]{appUrl});
        Map<String, URL> appDescriptors = DeploymentLoader.getDescriptors(finder);
        try {
            String absolutePath;
            Map libs;
            Application application;
            HashMap<String, URL> ejbModules = new HashMap<String, URL>();
            HashMap<String, URL> clientModules = new HashMap<String, URL>();
            HashMap<String, URL> resouceModules = new HashMap<String, URL>();
            HashMap<String, URL> webModules = new HashMap<String, URL>();
            HashMap<String, String> webContextRoots = new HashMap<String, String>();
            URL applicationXmlUrl = appDescriptors.get("application.xml");
            if (applicationXmlUrl != null) {
                application = DeploymentLoader.unmarshal(Application.class, "application.xml", applicationXmlUrl);
                for (Module module : application.getModule()) {
                    try {
                        URL url;
                        if (module.getEjb() != null) {
                            url = finder.find(module.getEjb().trim());
                            ejbModules.put(module.getEjb(), url);
                            continue;
                        }
                        if (module.getJava() != null) {
                            url = finder.find(module.getJava().trim());
                            clientModules.put(module.getConnector(), url);
                            continue;
                        }
                        if (module.getConnector() != null) {
                            url = finder.find(module.getConnector().trim());
                            resouceModules.put(module.getConnector(), url);
                            continue;
                        }
                        if (module.getWeb() == null) continue;
                        url = finder.find(module.getWeb().getWebUri().trim());
                        webModules.put(module.getWeb().getWebUri(), url);
                        webContextRoots.put(module.getWeb().getWebUri(), module.getWeb().getContextRoot());
                    }
                    catch (IOException e) {
                        throw new OpenEJBException("Invalid path to module " + e.getMessage(), e);
                    }
                }
            } else {
                application = new Application();
                HashMap<String, URL> files = new HashMap<String, URL>();
                DeploymentLoader.scanDir(appDir, files, "");
                files.remove("META-INF/MANIFEST.MF");
                for (Map.Entry<String, URL> entry : files.entrySet()) {
                    if (entry.getKey().startsWith("lib/") || !entry.getKey().matches(".*\\.(jar|war|rar|ear)")) continue;
                    try {
                        URLClassLoader uRLClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{entry.getValue()}, tmpClassLoader);
                        Class<? extends DeploymentModule> moduleType = DeploymentLoader.discoverModuleType(entry.getValue(), (ClassLoader)uRLClassLoader, true);
                        if (EjbModule.class.equals(moduleType)) {
                            ejbModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ClientModule.class.equals(moduleType)) {
                            clientModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ConnectorModule.class.equals(moduleType)) {
                            resouceModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!WebModule.class.equals(moduleType)) continue;
                        webModules.put(entry.getKey(), entry.getValue());
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                    }
                    catch (Exception exception) {
                        throw new OpenEJBException("Unable to determine the module type of " + entry.getKey() + ": Exception: " + exception.getMessage(), exception);
                    }
                }
            }
            if (application.getLibraryDirectory() == null) {
                application.setLibraryDirectory("lib/");
            } else {
                String dir = application.getLibraryDirectory();
                if (!dir.endsWith("/")) {
                    application.setLibraryDirectory(dir + "/");
                }
            }
            ArrayList extraLibs = new ArrayList();
            try {
                libs = finder.getResourcesMap(application.getLibraryDirectory());
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from '" + application.getLibraryDirectory() + "' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("APP-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'APP-INF/lib/' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("META-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'META-INF/lib/' : " + e.getMessage(), e);
            }
            HashMap<String, URL> rarLibs = new HashMap<String, URL>();
            for (Map.Entry entry : resouceModules.entrySet()) {
                try {
                    File rarFile = URLs.toFile((URL)entry.getValue());
                    rarFile = DeploymentLoader.unpack(rarFile);
                    entry.setValue(rarFile.toURI().toURL());
                    DeploymentLoader.scanDir(appDir, rarLibs, "");
                }
                catch (MalformedURLException e) {
                    throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
                }
            }
            Iterator iterator = rarLibs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).endsWith(".jar")) continue;
                iterator.remove();
            }
            ArrayList<Object> classPath = new ArrayList<Object>();
            classPath.addAll(ejbModules.values());
            classPath.addAll(clientModules.values());
            classPath.addAll(rarLibs.values());
            classPath.addAll(extraLibs);
            URL[] uRLArray = classPath.toArray(new URL[classPath.size()]);
            URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, uRLArray, OpenEJB.class.getClassLoader());
            AppModule appModule = new AppModule(appClassLoader, appId);
            appModule.getAdditionalLibraries().addAll(extraLibs);
            appModule.getAltDDs().putAll(appDescriptors);
            appModule.getWatchedResources().add(appId);
            if (applicationXmlUrl != null) {
                appModule.getWatchedResources().add(URLs.toFilePath(applicationXmlUrl));
            }
            for (String moduleName : ejbModules.keySet()) {
                try {
                    URL ejbUrl = (URL)ejbModules.get(moduleName);
                    File ejbFile = URLs.toFile(ejbUrl);
                    absolutePath = ejbFile.getAbsolutePath();
                    EjbModule ejbModule = DeploymentLoader.createEjbModule(ejbUrl, absolutePath, appClassLoader, moduleName);
                    appModule.getEjbModules().add(ejbModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load EJBs from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : clientModules.keySet()) {
                try {
                    URL clientUrl = (URL)clientModules.get(moduleName);
                    File clientFile = URLs.toFile(clientUrl);
                    absolutePath = clientFile.getAbsolutePath();
                    ClientModule clientModule = DeploymentLoader.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName);
                    appModule.getClientModules().add(clientModule);
                }
                catch (Exception e) {
                    logger.error("Unable to load App Client from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : resouceModules.keySet()) {
                try {
                    URL rarUrl = (URL)resouceModules.get(moduleName);
                    ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(appId, URLs.toFilePath(rarUrl), appClassLoader, moduleName);
                    appModule.getResourceModules().add(connectorModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load RAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : webModules.keySet()) {
                try {
                    URL warUrl = (URL)webModules.get(moduleName);
                    DeploymentLoader.addWebModule(appModule, URLs.toFilePath(warUrl), appClassLoader, (String)webContextRoots.get(moduleName), moduleName);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load WAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            DeploymentLoader.addPersistenceUnits(appModule, uRLArray);
            return appModule;
        }
        catch (OpenEJBException e) {
            logger.error("Unable to load EAR: " + jarPath, e);
            throw e;
        }
    }

    protected static ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName) throws OpenEJBException {
        return DeploymentLoader.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName, true);
    }

    protected static ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName, boolean log) throws OpenEJBException {
        ResourceFinder clientFinder = new ResourceFinder(new URL[]{clientUrl});
        URL manifestUrl = null;
        try {
            manifestUrl = clientFinder.find("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            // empty catch block
        }
        String mainClass = null;
        if (manifestUrl != null) {
            try {
                InputStream is = manifestUrl.openStream();
                Manifest manifest = new Manifest(is);
                mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            catch (IOException e) {
                throw new OpenEJBException("Unable to determine Main-Class defined in META-INF/MANIFEST.MF file", e);
            }
        }
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(clientFinder, log);
        ApplicationClient applicationClient = null;
        URL clientXmlUrl = descriptors.get("application-client.xml");
        if (clientXmlUrl != null) {
            applicationClient = ReadDescriptors.readApplicationClient(clientXmlUrl);
        }
        ClientModule clientModule = new ClientModule(applicationClient, appClassLoader, absolutePath, mainClass, moduleName);
        clientModule.getAltDDs().putAll(descriptors);
        clientModule.getWatchedResources().add(absolutePath);
        if (clientXmlUrl != null && "file".equals(clientXmlUrl.getProtocol())) {
            clientModule.getWatchedResources().add(URLs.toFilePath(clientXmlUrl));
        }
        return clientModule;
    }

    protected static EjbModule createEjbModule(URL baseUrl, String jarPath, ClassLoader classLoader, String moduleId) throws OpenEJBException {
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(baseUrl);
        EjbJar ejbJar = null;
        URL ejbJarXmlUrl = descriptors.get("ejb-jar.xml");
        if (ejbJarXmlUrl != null) {
            ejbJar = ReadDescriptors.readEjbJar(ejbJarXmlUrl);
        }
        EjbModule ejbModule = new EjbModule(classLoader, moduleId, jarPath, ejbJar, null);
        ejbModule.getAltDDs().putAll(descriptors);
        ejbModule.getWatchedResources().add(jarPath);
        if (ejbJarXmlUrl != null && "file".equals(ejbJarXmlUrl.getProtocol())) {
            ejbModule.getWatchedResources().add(URLs.toFilePath(ejbJarXmlUrl));
        }
        ejbModule.setClientModule(DeploymentLoader.createClientModule(baseUrl, jarPath, classLoader, null, false));
        DeploymentLoader.addWebservices(ejbModule);
        return ejbModule;
    }

    protected static void addWebModule(AppModule appModule, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        WebModule webModule = DeploymentLoader.createWebModule(appModule.getJarLocation(), warPath, parentClassLoader, contextRoot, moduleName);
        appModule.getWebModules().add(webModule);
        ClassLoader webClassLoader = webModule.getClassLoader();
        List urls = null;
        try {
            UrlSet urlSet = new UrlSet(webClassLoader);
            urlSet = urlSet.exclude(webClassLoader.getParent());
            urls = urlSet.getUrls();
        }
        catch (IOException e) {
            logger.warning("Unable to determine URLs in classloader", e);
        }
        for (int i = 0; i < urls.size(); ++i) {
            URL url = (URL)urls.get(i);
            if (!url.getProtocol().equals("jar")) continue;
            try {
                url = new URL(url.getFile().replaceFirst("!.*$", ""));
                urls.set(i, url);
                continue;
            }
            catch (MalformedURLException ignored) {
                // empty catch block
            }
        }
        for (URL ejbUrl : urls) {
            try {
                Class<? extends DeploymentModule> moduleType = DeploymentLoader.discoverModuleType(ejbUrl, webClassLoader, true);
                if (!EjbModule.class.isAssignableFrom(moduleType)) continue;
                File ejbFile = URLs.toFile(ejbUrl);
                String absolutePath = ejbFile.getAbsolutePath();
                EjbModule ejbModule = DeploymentLoader.createEjbModule(ejbUrl, absolutePath, webClassLoader, null);
                appModule.getEjbModules().add(ejbModule);
            }
            catch (IOException e) {
            }
            catch (UnknownModuleTypeException ignore) {}
        }
        DeploymentLoader.addPersistenceUnits(appModule, new URL[0]);
    }

    protected static WebModule createWebModule(String appId, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        Map<String, URL> descriptors;
        File warFile = new File(warPath);
        warFile = DeploymentLoader.unpack(warFile);
        try {
            descriptors = DeploymentLoader.getWebDescriptors(warFile);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", e);
        }
        WebApp webApp = null;
        URL webXmlUrl = descriptors.get("web.xml");
        if (webXmlUrl != null) {
            webApp = ReadDescriptors.readWebApp(webXmlUrl);
        }
        if (contextRoot == null && webApp != null && webApp.getId() != null) {
            moduleName = webApp.getId();
        }
        URL[] webUrls = DeploymentLoader.getWebappUrls(warFile);
        URLClassLoader warClassLoader = ClassLoaderUtil.createTempClassLoader(appId, webUrls, parentClassLoader);
        WebModule webModule = new WebModule(webApp, contextRoot, warClassLoader, warFile.getAbsolutePath(), moduleName);
        webModule.getAltDDs().putAll(descriptors);
        webModule.getWatchedResources().add(warPath);
        webModule.getWatchedResources().add(warFile.getAbsolutePath());
        if (webXmlUrl != null && "file".equals(webXmlUrl.getProtocol())) {
            webModule.getWatchedResources().add(URLs.toFilePath(webXmlUrl));
        }
        DeploymentLoader.addTagLibraries(webModule);
        DeploymentLoader.addWebservices(webModule);
        DeploymentLoader.addFacesConfigs(webModule);
        return webModule;
    }

    public static URL[] getWebappUrls(File warFile) {
        ArrayList<URL> webClassPath = new ArrayList<URL>();
        File webInfDir = new File(warFile, "WEB-INF");
        try {
            webClassPath.add(new File(webInfDir, "classes").toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.warning("War path bad: " + new File(webInfDir, "classes"), e);
        }
        File libDir = new File(webInfDir, "lib");
        if (libDir.exists()) {
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
                try {
                    webClassPath.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + file, e);
                }
            }
        }
        URL[] webUrls = webClassPath.toArray(new URL[webClassPath.size()]);
        return webUrls;
    }

    private static void addWebservices(WsModule wsModule) throws OpenEJBException {
        URL moduleUrl;
        String webservicesEnabled = SystemInstance.get().getProperty("openejb.webservices.enabled", "true");
        if (!Boolean.parseBoolean(webservicesEnabled)) {
            wsModule.getAltDDs().remove("webservices.xml");
            wsModule.setWebservices(null);
            return;
        }
        Object webservicesObject = wsModule.getAltDDs().get("webservices.xml");
        if (webservicesObject == null || !(webservicesObject instanceof URL)) {
            return;
        }
        URL webservicesUrl = (URL)webservicesObject;
        try {
            File jarFile = new File(wsModule.getJarLocation());
            moduleUrl = jarFile.toURI().toURL();
            if (jarFile.isFile()) {
                moduleUrl = new URL("jar", "", -1, moduleUrl + "!/");
            }
        }
        catch (MalformedURLException e) {
            logger.warning("Invalid module location " + wsModule.getJarLocation());
            return;
        }
        HashMap<URL, JavaWsdlMapping> jaxrpcMappingCache = new HashMap<URL, JavaWsdlMapping>();
        Webservices webservices = ReadDescriptors.readWebservices(webservicesUrl);
        wsModule.setWebservices(webservices);
        if ("file".equals(webservicesUrl.getProtocol())) {
            wsModule.getWatchedResources().add(URLs.toFilePath(webservicesUrl));
        }
        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile();
            if (jaxrpcMappingFile == null) continue;
            try {
                URL jaxrpcMappingUrl = new URL(moduleUrl, jaxrpcMappingFile);
                JavaWsdlMapping jaxrpcMapping = (JavaWsdlMapping)jaxrpcMappingCache.get(jaxrpcMappingUrl);
                if (jaxrpcMapping == null) {
                    jaxrpcMapping = ReadDescriptors.readJaxrpcMapping(jaxrpcMappingUrl);
                    jaxrpcMappingCache.put(jaxrpcMappingUrl, jaxrpcMapping);
                }
                webserviceDescription.setJaxrpcMapping(jaxrpcMapping);
                if (!"file".equals(jaxrpcMappingUrl.getProtocol())) continue;
                wsModule.getWatchedResources().add(URLs.toFilePath(jaxrpcMappingUrl));
            }
            catch (MalformedURLException e) {
                logger.warning("Invalid jaxrpc-mapping-file location " + jaxrpcMappingFile);
            }
        }
    }

    private static void addTagLibraries(WebModule webModule) throws OpenEJBException {
        HashSet<URL> tldLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            for (JspConfig jspConfig : webApp.getJspConfig()) {
                for (Taglib taglib : jspConfig.getTaglib()) {
                    String location = taglib.getTaglibLocation();
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        if (location.endsWith(".jar")) {
                            URL url = file.toURI().toURL();
                            tldLocations.add(url);
                            continue;
                        }
                        Set<URL> urls = DeploymentLoader.scanJarForTagLibs(file);
                        tldLocations.addAll(urls);
                    }
                    catch (IOException e) {
                        logger.warning("JSP tag library location bad: " + location, e);
                    }
                }
            }
        }
        Set<URL> urls = DeploymentLoader.scanWarForTagLibs(warFile);
        tldLocations.addAll(urls);
        ClassLoader parentClassLoader = webModule.getClassLoader().getParent();
        urls = DeploymentLoader.scanClassLoaderForTagLibs(parentClassLoader);
        tldLocations.addAll(urls);
        for (URL location : tldLocations) {
            TldTaglib taglib = ReadDescriptors.readTldTaglib(location);
            webModule.getTaglibs().add(taglib);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    private static void addFacesConfigs(WebModule webModule) throws OpenEJBException {
        File facesConfigFile;
        File webInf;
        HashSet<URL> facesConfigLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            List contextParam = webApp.getContextParam();
            for (ParamValue value : contextParam) {
                boolean foundContextParam = value.getParamName().trim().equals("javax.faces.CONFIG_FILES");
                if (!foundContextParam) continue;
                String commaDelimitedListOfFiles = value.getParamValue().trim();
                String[] configFiles = commaDelimitedListOfFiles.split(",");
                String[] trimmedConfigFiles = new String[configFiles.length];
                for (int i = 0; i < configFiles.length; ++i) {
                    trimmedConfigFiles[i] = configFiles[i].trim();
                }
                for (String location : trimmedConfigFiles) {
                    if (!location.startsWith("/")) {
                        logger.error("A faces configuration file should be context relative when specified in web.xml. Please fix the value of context parameter javax.faces.CONFIG_FILES for the file " + location);
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        URL url = file.toURI().toURL();
                        facesConfigLocations.add(url);
                    }
                    catch (IOException e) {
                        logger.error("Faces configuration file location bad: " + location, e);
                    }
                }
            }
        }
        if ((webInf = new File(warFile, "WEB-INF")).isDirectory() && (facesConfigFile = new File(webInf, "faces-config.xml")).exists()) {
            try {
                facesConfigFile = facesConfigFile.getCanonicalFile().getAbsoluteFile();
                URL url = facesConfigFile.toURI().toURL();
                facesConfigLocations.add(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL location : facesConfigLocations) {
            FacesConfig facesConfig = ReadDescriptors.readFacesConfig(location);
            webModule.getFacesConfigs().add(facesConfig);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    private static Set<URL> scanClassLoaderForTagLibs(ClassLoader parentClassLoader) throws OpenEJBException {
        UrlSet urlSet;
        HashSet<URL> urls = new HashSet<URL>();
        if (parentClassLoader == null) {
            return urls;
        }
        try {
            urlSet = new UrlSet(parentClassLoader);
            urlSet = urlSet.excludeJavaEndorsedDirs();
            urlSet = urlSet.excludeJavaExtDirs();
            urlSet = urlSet.excludeJavaHome();
            urlSet = urlSet.exclude(ClassLoader.getSystemClassLoader());
        }
        catch (IOException e) {
            logger.warning("Error scanning class loader for JSP tag libraries", e);
            return urls;
        }
        for (URL url : urlSet.getUrls()) {
            if (url.getProtocol().equals("jar")) {
                try {
                    String path = url.getPath();
                    if (path.endsWith("!/")) {
                        path = path.substring(0, path.length() - 2);
                    }
                    url = new URL(path);
                }
                catch (MalformedURLException e) {
                    logger.warning("JSP tag library location bad: " + url.toExternalForm(), e);
                    continue;
                }
            }
            if (!url.getProtocol().equals("file")) continue;
            File file = URLs.toFile(url);
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
            }
            catch (IOException e) {
                logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
                continue;
            }
            urls.addAll(DeploymentLoader.scanJarForTagLibs(file));
        }
        return urls;
    }

    private static Set<URL> scanWarForTagLibs(File war) {
        HashSet<URL> urls = new HashSet<URL>();
        File webInfDir = new File(war, "WEB-INF");
        if (!webInfDir.isDirectory()) {
            return urls;
        }
        LinkedList<File> files = new LinkedList<File>();
        for (File file : webInfDir.listFiles()) {
            if ("lib".equals(file.getName()) || "classes".equals(file.getName())) continue;
            files.add(file);
        }
        if (files.isEmpty()) {
            return urls;
        }
        while (!files.isEmpty()) {
            File file = (File)files.removeFirst();
            if (file.isDirectory()) {
                files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            if (!file.getName().endsWith(".tld")) continue;
            try {
                file = file.getCanonicalFile().getAbsoluteFile();
                urls.add(file.toURI().toURL());
            }
            catch (IOException e) {
                logger.warning("JSP tag library location bad: " + file.getAbsolutePath(), e);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<URL> scanJarForTagLibs(File file) {
        HashSet<URL> urls = new HashSet<URL>();
        if (!file.isFile()) {
            return urls;
        }
        JarFile jarFile = null;
        jarFile = new JarFile(file);
        URL jarFileUrl = new URL("jar", "", -1, file.toURI().toURL().toExternalForm() + "!/");
        for (JarEntry entry : Collections.list(jarFile.entries())) {
            String name = entry.getName();
            if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
            URL url = new URL(jarFileUrl, name);
            urls.add(url);
        }
        Object var9_9 = null;
        if (jarFile == null) return urls;
        try {
            jarFile.close();
            return urls;
        }
        catch (IOException e2) {}
        return urls;
        {
            catch (IOException e) {
                logger.warning("Error scanning jar for JSP tag libraries: " + file.getAbsolutePath(), e);
                Object var9_10 = null;
                if (jarFile == null) return urls;
                try {
                    jarFile.close();
                    return urls;
                }
                catch (IOException e2) {}
                return urls;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId) throws OpenEJBException {
        File rarFile = new File(rarPath);
        rarFile = DeploymentLoader.unpack(rarFile);
        URL baseUrl = DeploymentLoader.getFileUrl(rarFile);
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(baseUrl);
        Connector connector = null;
        URL rarXmlUrl = descriptors.get("ra.xml");
        if (rarXmlUrl != null) {
            connector = ReadDescriptors.readConnector(rarXmlUrl);
        }
        HashMap<String, URL> rarLibs = new HashMap<String, URL>();
        DeploymentLoader.scanDir(rarFile, rarLibs, "");
        Iterator<Map.Entry<String, URL>> iterator = rarLibs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, URL> fileEntry = iterator.next();
            if (fileEntry.getKey().endsWith(".jar")) continue;
            iterator.remove();
        }
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.addAll(rarLibs.values());
        URL[] urls = classPath.toArray(new URL[classPath.size()]);
        URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, urls, parentClassLoader);
        ConnectorModule connectorModule = new ConnectorModule(connector, appClassLoader, rarPath, moduleId);
        connectorModule.getAltDDs().putAll(descriptors);
        connectorModule.getLibraries().addAll(classPath);
        connectorModule.getWatchedResources().add(rarPath);
        connectorModule.getWatchedResources().add(rarFile.getAbsolutePath());
        if (rarXmlUrl != null && "file".equals(rarXmlUrl.getProtocol())) {
            connectorModule.getWatchedResources().add(URLs.toFilePath(rarXmlUrl));
        }
        return connectorModule;
    }

    protected static void addPersistenceUnits(AppModule appModule, URL ... urls) throws OpenEJBException {
        ArrayList<URL> persistenceUrls = (ArrayList<URL>)appModule.getAltDDs().get("persistence.xml");
        if (persistenceUrls == null) {
            persistenceUrls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        for (URL url : urls) {
            URL descriptor;
            ResourceFinder finder = new ResourceFinder("", appModule.getClassLoader(), new URL[]{url});
            Map<String, URL> descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence.xml") || persistenceUrls.contains(descriptor = descriptors.get("persistence.xml"))) continue;
            String urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence.xml")) {
                logger.info("AltDD persistence.xml -> " + urlString);
            }
            persistenceUrls.add(descriptor);
        }
    }

    private static Map<String, URL> getDescriptors(URL moduleUrl) throws OpenEJBException {
        ResourceFinder finder = new ResourceFinder(new URL[]{moduleUrl});
        return DeploymentLoader.getDescriptors(finder);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder) throws OpenEJBException {
        return DeploymentLoader.getDescriptors(finder, true);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder, boolean log) throws OpenEJBException {
        try {
            return DeploymentLoader.altDDSources(finder.getResourcesMap("META-INF/"), log);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, URL> altDDSources(Map<String, URL> map, boolean log) {
        String prefixes = SystemInstance.get().getProperty(OPENEJB_ALTDD_PREFIX);
        if (prefixes == null || prefixes.length() <= 0) {
            return map;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(prefixes.split(",")));
        Collections.reverse(list);
        HashMap<String, URL> alts = new HashMap<String, URL>();
        for (String string : list) {
            String string2 = string.trim();
            if (!string2.matches(".*[.-]$")) {
                String string3 = string2 + ".";
            }
            for (Map.Entry<String, URL> entry : new HashMap<String, URL>(map).entrySet()) {
                void var6_6;
                String key = entry.getKey();
                URL value = entry.getValue();
                if (!key.startsWith((String)var6_6)) continue;
                key = key.substring(var6_6.length());
                alts.put(key, value);
            }
        }
        for (Map.Entry entry : alts.entrySet()) {
            String key = (String)entry.getKey();
            URL value = (URL)entry.getValue();
            if (value.equals(map.get(key))) continue;
            if (log) {
                logger.info("AltDD " + key + " -> " + value.toExternalForm());
            }
            map.put(key, value);
        }
        return map;
    }

    private static Map<String, URL> getWebDescriptors(File warFile) throws IOException {
        File webInfDir;
        TreeMap<String, URL> descriptors = new TreeMap<String, URL>();
        if (warFile.isFile()) {
            URL jarURL = new URL("jar", "", -1, warFile.toURI().toURL() + "!/");
            try {
                JarFile jarFile = new JarFile(warFile);
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith("WEB-INF/") || entryName.indexOf(47, "WEB-INF/".length()) <= 0) continue;
                    descriptors.put(entryName, new URL(jarURL, entry.getName()));
                }
            }
            catch (IOException e) {}
        } else if (warFile.isDirectory() && (webInfDir = new File(warFile, "WEB-INF")).isDirectory()) {
            for (File file : webInfDir.listFiles()) {
                if (file.isDirectory()) continue;
                descriptors.put(file.getName(), file.toURI().toURL());
            }
        }
        return descriptors;
    }

    protected static File getFile(URL warUrl) {
        if ("jar".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            if (!pathname.startsWith("file:")) {
                return null;
            }
            pathname = pathname.substring("file:".length());
            pathname = pathname.substring(0, pathname.lastIndexOf(33));
            pathname = URLDecoder.decode(pathname);
            return new File(pathname);
        }
        if ("file".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            return new File(URLDecoder.decode(pathname));
        }
        return null;
    }

    public static <T> T unmarshal(Class<T> type, String descriptor, URL url) throws OpenEJBException {
        try {
            return (T)JaxbJavaee.unmarshal(type, (InputStream)url.openStream());
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the " + descriptor + " file: " + url.toExternalForm(), e);
        }
    }

    public static void scanDir(File dir, Map<String, URL> files, String path) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                DeploymentLoader.scanDir(file, files, path + file.getName() + "/");
                continue;
            }
            String name = file.getName();
            try {
                files.put(path + name, file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.warning("EAR path bad: " + path + name, e);
            }
        }
    }

    public static Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, boolean searchForDescriptorlessApplications) throws IOException, UnknownModuleTypeException {
        HashSet<RequireDescriptors> search = new HashSet<RequireDescriptors>();
        if (!searchForDescriptorlessApplications) {
            search.addAll(Arrays.asList(RequireDescriptors.values()));
        }
        return DeploymentLoader.discoverModuleType(baseUrl, classLoader, search);
    }

    public static Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptor) throws IOException, UnknownModuleTypeException {
        InputStream is;
        Manifest manifest;
        String mainClass;
        final boolean scanPotentialEjbModules = !requireDescriptor.contains((Object)RequireDescriptors.EJB);
        final boolean scanPotentialClientModules = !requireDescriptor.contains((Object)RequireDescriptors.CLIENT);
        ResourceFinder finder = new ResourceFinder("", classLoader, new URL[]{baseUrl});
        Map<String, URL> descriptors = DeploymentLoader.altDDSources(finder.getResourcesMap("META-INF/"), false);
        String path = baseUrl.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (descriptors.containsKey("application.xml") || path.endsWith(".ear")) {
            return AppModule.class;
        }
        if (descriptors.containsKey("ejb-jar.xml")) {
            return EjbModule.class;
        }
        if (descriptors.containsKey("application-client.xml")) {
            return ClientModule.class;
        }
        if (descriptors.containsKey("ra.xml") || path.endsWith(".rar")) {
            return ConnectorModule.class;
        }
        Map<String, URL> webDescriptors = DeploymentLoader.getWebDescriptors(DeploymentLoader.getFile(baseUrl));
        if (webDescriptors.containsKey("web.xml") || path.endsWith(".war")) {
            return WebModule.class;
        }
        URL manifestUrl = descriptors.get("MANIFEST.MF");
        if (scanPotentialClientModules && manifestUrl != null && (mainClass = (manifest = new Manifest(is = manifestUrl.openStream())).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
            return ClientModule.class;
        }
        if (scanPotentialEjbModules || scanPotentialClientModules) {
            AnnotationFinder classFinder = new AnnotationFinder(classLoader, baseUrl);
            final LinkedHashSet otherTypes = new LinkedHashSet();
            AnnotationFinder.Filter filter = new AnnotationFinder.Filter(){
                final String packageName = LocalClient.class.getName().replace("LocalClient", "");

                public boolean accept(String annotationName) {
                    if (scanPotentialEjbModules && annotationName.startsWith("javax.ejb.")) {
                        if ("javax.ejb.Stateful".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.Stateless".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.Singleton".equals(annotationName)) {
                            return true;
                        }
                        if ("javax.ejb.MessageDriven".equals(annotationName)) {
                            return true;
                        }
                    } else if (scanPotentialClientModules && annotationName.startsWith(this.packageName)) {
                        if (LocalClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                        if (RemoteClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                    }
                    return false;
                }
            };
            if (classFinder.find(filter)) {
                return EjbModule.class;
            }
            if (otherTypes.size() > 0) {
                return (Class)otherTypes.iterator().next();
            }
        }
        if (descriptors.containsKey("persistence.xml")) {
            return PersistenceModule.class;
        }
        throw new UnknownModuleTypeException("Unknown module type: url=" + baseUrl.toExternalForm());
    }

    private static File unpack(File jarFile) throws OpenEJBException {
        if (jarFile.isDirectory()) {
            return jarFile;
        }
        String name = jarFile.getName();
        name = name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".rar") ? name.replaceFirst("....$", "") : name + ".unpacked";
        try {
            return JarExtractor.extract(jarFile, name);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to extract jar. " + e.getMessage(), e);
        }
    }

    protected static URL getFileUrl(File jarFile) throws OpenEJBException {
        URL baseUrl;
        try {
            baseUrl = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
        }
        return baseUrl;
    }
}

