/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.Vector;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ValidationError;
import org.apache.openejb.config.ValidationFailure;
import org.apache.openejb.config.ValidationResults;
import org.apache.openejb.config.ValidationWarning;
import org.apache.openejb.jee.EjbJar;

public class EjbSet
implements ValidationResults {
    private final Vector failures = new Vector();
    private final Vector warnings = new Vector();
    private final Vector errors = new Vector();
    private final String jarPath;
    private final EjbJar jar;
    private final String moduleType = EjbModule.class.getSimpleName();
    private final ClassLoader classLoader;

    public EjbSet(String jarPath, EjbJar jar, ClassLoader classLoader) {
        this.jarPath = jarPath;
        this.jar = jar;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public EjbJar getJar() {
        return this.jar;
    }

    public String getModuleType() {
        return this.moduleType;
    }

    public void addWarning(ValidationWarning warning) {
        this.warnings.addElement(warning);
    }

    public void addFailure(ValidationFailure failure) {
        this.failures.addElement(failure);
    }

    public void addError(ValidationError error) {
        this.errors.addElement(error);
    }

    public ValidationFailure[] getFailures() {
        Object[] tmp = new ValidationFailure[this.failures.size()];
        this.failures.copyInto(tmp);
        return tmp;
    }

    public ValidationWarning[] getWarnings() {
        Object[] tmp = new ValidationWarning[this.warnings.size()];
        this.warnings.copyInto(tmp);
        return tmp;
    }

    public ValidationError[] getErrors() {
        Object[] tmp = new ValidationError[this.errors.size()];
        this.errors.copyInto(tmp);
        return tmp;
    }

    public boolean hasWarnings() {
        return this.warnings.size() > 0;
    }

    public boolean hasFailures() {
        return this.failures.size() > 0;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public EjbJar getEjbJar() {
        return this.jar;
    }

    public String getJarPath() {
        return this.jarPath;
    }
}

