/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.bind.JAXBElement;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EjbRef;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.jpa.AttributeOverride;
import org.apache.openejb.jee.jpa.Attributes;
import org.apache.openejb.jee.jpa.Basic;
import org.apache.openejb.jee.jpa.Column;
import org.apache.openejb.jee.jpa.Entity;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.Field;
import org.apache.openejb.jee.jpa.GeneratedValue;
import org.apache.openejb.jee.jpa.GenerationType;
import org.apache.openejb.jee.jpa.Id;
import org.apache.openejb.jee.jpa.JoinColumn;
import org.apache.openejb.jee.jpa.JoinTable;
import org.apache.openejb.jee.jpa.NamedQuery;
import org.apache.openejb.jee.jpa.OneToMany;
import org.apache.openejb.jee.jpa.OneToOne;
import org.apache.openejb.jee.jpa.RelationField;
import org.apache.openejb.jee.jpa.Table;
import org.apache.openejb.jee.oejb2.ActivationConfigPropertyType;
import org.apache.openejb.jee.oejb2.ActivationConfigType;
import org.apache.openejb.jee.oejb2.EjbRefType;
import org.apache.openejb.jee.oejb2.EjbRelationType;
import org.apache.openejb.jee.oejb2.EjbRelationshipRoleType;
import org.apache.openejb.jee.oejb2.EnterpriseBean;
import org.apache.openejb.jee.oejb2.EntityBeanType;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.JaxbOpenejbJar2;
import org.apache.openejb.jee.oejb2.Jndi;
import org.apache.openejb.jee.oejb2.MessageDrivenBeanType;
import org.apache.openejb.jee.oejb2.OpenejbJarType;
import org.apache.openejb.jee.oejb2.PatternType;
import org.apache.openejb.jee.oejb2.QueryType;
import org.apache.openejb.jee.oejb2.RpcBean;
import org.apache.openejb.jee.oejb2.SessionBeanType;
import org.apache.openejb.jee.oejb2.TssLinkType;
import org.apache.openejb.jee.oejb2.WebServiceBindingType;
import org.apache.openejb.jee.oejb2.WebServiceSecurityType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.EjbLink;
import org.apache.openejb.jee.oejb3.OpenejbJar;

public class OpenEjb2Conversion
implements DynamicDeployer {
    public AppModule deploy(AppModule appModule) {
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            OpenejbJarType altDD = this.getOpenejbJarType(ejbModule);
            if (!(altDD instanceof OpenejbJarType)) continue;
            this.convertEjbRefs(ejbModule.getEjbJar(), ejbModule.getOpenejbJar(), altDD);
            this.convertMdbConfigs(ejbModule.getEjbJar(), altDD);
            this.mergeEntityMappings(ejbModule.getModuleId(), appModule.getCmpMappings(), ejbModule.getOpenejbJar(), altDD);
        }
        return appModule;
    }

    private OpenejbJarType getOpenejbJarType(EjbModule ejbModule) {
        Object altDD = ejbModule.getAltDDs().get("openejb-jar.xml");
        if (altDD instanceof String) {
            try {
                altDD = JaxbOpenejbJar2.unmarshal(OpenejbJarType.class, (InputStream)new ByteArrayInputStream(((String)altDD).getBytes()), (boolean)false);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (altDD instanceof URL) {
            try {
                altDD = JaxbOpenejbJar2.unmarshal(OpenejbJarType.class, (InputStream)((URL)altDD).openStream(), (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (altDD instanceof JAXBElement) {
            altDD = ((JAXBElement)altDD).getValue();
        }
        if (altDD instanceof OpenejbJarType) {
            return (OpenejbJarType)altDD;
        }
        return null;
    }

    public void convertEjbRefs(EjbJar ejbJar, OpenejbJar openejbJar, OpenejbJarType openejbJarType) {
        openejbJar.getProperties().putAll((Map<?, ?>)openejbJarType.getProperties());
        Map ejbs = ejbJar.getEnterpriseBeansByEjbName();
        Map deployments = openejbJar.getDeploymentsByEjbName();
        for (EnterpriseBean enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            String refName;
            SessionBeanType sessionBean;
            WebServiceSecurityType webServiceSecurityType;
            org.apache.openejb.jee.EnterpriseBean ejb = (org.apache.openejb.jee.EnterpriseBean)ejbs.get(enterpriseBean.getEjbName());
            if (ejb == null) continue;
            Map ejbRefs = ejb.getEjbRefMap();
            EjbDeployment deployment = (EjbDeployment)deployments.get(enterpriseBean.getEjbName());
            if (deployment == null) continue;
            if (enterpriseBean instanceof SessionBeanType && (webServiceSecurityType = (sessionBean = (SessionBeanType)enterpriseBean).getWebServiceSecurity()) != null) {
                if (webServiceSecurityType.getRealmName() != null) {
                    deployment.addProperty("webservice.security.realm", webServiceSecurityType.getRealmName());
                }
                if (webServiceSecurityType.getSecurityRealmName() != null) {
                    deployment.addProperty("webservice.security.securityRealm", webServiceSecurityType.getSecurityRealmName());
                }
                if (webServiceSecurityType.getTransportGuarantee() != null) {
                    deployment.addProperty("webservice.security.transportGarantee", webServiceSecurityType.getTransportGuarantee().value());
                } else {
                    deployment.addProperty("webservice.security.transportGarantee", "NONE");
                }
                if (webServiceSecurityType.getAuthMethod() != null) {
                    deployment.addProperty("webservice.security.authMethod", webServiceSecurityType.getAuthMethod().value());
                } else {
                    deployment.addProperty("webservice.security.authMethod", "NONE");
                }
                deployment.getProperties().putAll((Map<?, ?>)webServiceSecurityType.getProperties());
            }
            deployment.getProperties().putAll((Map<?, ?>)enterpriseBean.getProperties());
            for (String name : enterpriseBean.getLocalJndiName()) {
                deployment.getJndi().add(new org.apache.openejb.jee.oejb3.Jndi(name, "LocalHome"));
            }
            for (String name : enterpriseBean.getJndiName()) {
                deployment.getJndi().add(new org.apache.openejb.jee.oejb3.Jndi(name, "RemoteHome"));
            }
            for (Jndi jndi : enterpriseBean.getJndi()) {
                deployment.getJndi().add(new org.apache.openejb.jee.oejb3.Jndi(jndi.getName(), jndi.getInterface()));
            }
            TreeSet<String> ejbLinks = new TreeSet<String>();
            for (EjbLink ejbLink : deployment.getEjbLink()) {
                ejbLinks.add(ejbLink.getEjbRefName());
            }
            for (EjbRefType refType : enterpriseBean.getEjbRef()) {
                EjbRef ref;
                refName = refType.getRefName();
                if (ejbLinks.contains(refName)) continue;
                String nsCorbaloc = refType.getNsCorbaloc();
                if (nsCorbaloc != null) {
                    ref = (EjbRef)ejbRefs.get(refName);
                    if (ref == null) continue;
                    ref.setMappedName("jndi:" + nsCorbaloc);
                    continue;
                }
                if (refType.getEjbLink() != null) {
                    ref = (EjbRef)ejbRefs.get(refName);
                    if (ref == null) continue;
                    ref.setEjbLink(refType.getEjbLink());
                    continue;
                }
                PatternType pattern = refType.getPattern();
                this.addEjbLink(deployment, refName, pattern);
            }
            for (EjbRefType refType : enterpriseBean.getEjbLocalRef()) {
                refName = refType.getRefName();
                if (ejbLinks.contains(refName)) continue;
                if (refType.getEjbLink() != null) {
                    EjbRef ref = (EjbRef)ejbRefs.get(refName);
                    if (ref == null) continue;
                    ref.setEjbLink(refType.getEjbLink());
                    continue;
                }
                PatternType pattern = refType.getPattern();
                this.addEjbLink(deployment, refName, pattern);
            }
        }
    }

    private void addEjbLink(EjbDeployment deployment, String refName, PatternType pattern) {
        String module = pattern.getModule();
        if (module == null) {
            module = pattern.getArtifactId();
        }
        String ejbName = pattern.getName();
        String deploymentId = module + "/" + ejbName;
        EjbLink ejbLink = new EjbLink(refName, deploymentId);
        deployment.getEjbLink().add(ejbLink);
    }

    public void convertMdbConfigs(EjbJar ejbJar, OpenejbJarType openejbJarType) {
        TreeMap<String, MessageDrivenBean> mdbs = new TreeMap<String, MessageDrivenBean>();
        for (org.apache.openejb.jee.EnterpriseBean enterpriseBean : ejbJar.getEnterpriseBeans()) {
            if (!(enterpriseBean instanceof MessageDrivenBean)) continue;
            mdbs.put(enterpriseBean.getEjbName(), (MessageDrivenBean)enterpriseBean);
        }
        for (EnterpriseBean enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            ActivationConfigType activationConfigType;
            MessageDrivenBeanType bean;
            MessageDrivenBean mdb;
            if (!(enterpriseBean instanceof MessageDrivenBeanType) || (mdb = (MessageDrivenBean)mdbs.get((bean = (MessageDrivenBeanType)enterpriseBean).getEjbName())) == null || (activationConfigType = bean.getActivationConfig()) == null) continue;
            ActivationConfig activationConfig = mdb.getActivationConfig();
            if (activationConfig == null) {
                activationConfig = new ActivationConfig();
                mdb.setActivationConfig(activationConfig);
            }
            for (ActivationConfigPropertyType propertyType : activationConfigType.getActivationConfigProperty()) {
                ActivationConfigProperty property = new ActivationConfigProperty(propertyType.getActivationConfigPropertyName(), propertyType.getActivationConfigPropertyValue());
                activationConfig.getActivationConfigProperty().add(property);
            }
        }
    }

    public void mergeEntityMappings(String moduleId, EntityMappings entityMappings, OpenejbJar openejbJar, OpenejbJarType openejbJarType) {
        Field field;
        TreeMap<String, EntityData> entities = new TreeMap<String, EntityData>();
        if (entityMappings != null) {
            for (Entity entity : entityMappings.getEntity()) {
                entities.put(entity.getDescription(), new EntityData(entity));
            }
        }
        for (EnterpriseBean enterpriseBean : openejbJarType.getEnterpriseBeans()) {
            Attributes attributes;
            if (!(enterpriseBean instanceof EntityBeanType)) continue;
            EntityBeanType bean = (EntityBeanType)enterpriseBean;
            EntityData entityData = (EntityData)entities.get(moduleId + "#" + bean.getEjbName());
            if (entityData == null) continue;
            Table table = new Table();
            table.setName(bean.getTableName());
            entityData.entity.setTable(table);
            for (EntityBeanType.CmpFieldMapping cmpFieldMapping : bean.getCmpFieldMapping()) {
                String cmpFieldName = cmpFieldMapping.getCmpFieldName();
                field = (Field)entityData.fields.get(cmpFieldName);
                if (field == null) continue;
                Column column = new Column();
                column.setName(cmpFieldMapping.getTableColumn());
                field.setColumn(column);
            }
            if (bean.getKeyGenerator() != null && (attributes = entityData.entity.getAttributes()) != null && attributes.getId().size() == 1) {
                Id id = (Id)attributes.getId().get(0);
                id.setGeneratedValue(new GeneratedValue(GenerationType.IDENTITY));
            }
            for (QueryType query : bean.getQuery()) {
                NamedQuery namedQuery = new NamedQuery();
                QueryType.QueryMethod queryMethod = query.getQueryMethod();
                StringBuilder name = new StringBuilder();
                name.append(entityData.entity.getName()).append(".").append(queryMethod.getMethodName());
                if (queryMethod.getMethodParams() != null && !queryMethod.getMethodParams().getMethodParam().isEmpty()) {
                    name.append('(');
                    boolean first = true;
                    for (String methodParam : queryMethod.getMethodParams().getMethodParam()) {
                        if (!first) {
                            name.append(",");
                        }
                        name.append(methodParam);
                        first = false;
                    }
                    name.append(')');
                }
                namedQuery.setName(name.toString());
                namedQuery.setQuery(query.getEjbQl());
                entityData.entity.getNamedQuery().add(namedQuery);
            }
        }
        for (EjbRelationType relation : openejbJarType.getEjbRelation()) {
            List roles = relation.getEjbRelationshipRole();
            if (roles.isEmpty()) continue;
            if (relation.getManyToManyTableName() == null) {
                OneToOne left;
                OneToOne right;
                EjbRelationshipRoleType leftRole = (EjbRelationshipRoleType)roles.get(0);
                EjbRelationshipRoleType.RelationshipRoleSource leftRoleSource = leftRole.getRelationshipRoleSource();
                String leftEjbName = leftRoleSource == null ? null : leftRoleSource.getEjbName();
                EntityData leftEntityData = (EntityData)entities.get(moduleId + "#" + leftEjbName);
                String leftFieldName = leftRole.getCmrField().getCmrFieldName();
                if (leftRole.isForeignKeyColumnOnSource()) {
                    field = (RelationField)leftEntityData.relations.get(leftFieldName);
                    if (field == null) {
                        continue;
                    }
                } else {
                    RelationField other = (RelationField)leftEntityData.relations.get(leftFieldName);
                    if (other == null) continue;
                    field = other.getRelatedField();
                    if (field == null) {
                        if (!(other instanceof OneToMany)) continue;
                        field = other;
                    }
                }
                if (field instanceof OneToOne && (right = (OneToOne)(left = (OneToOne)field).getRelatedField()) != null) {
                    left.setMappedBy(null);
                    right.setMappedBy(left.getName());
                }
                EjbRelationshipRoleType.RoleMapping roleMapping = leftRole.getRoleMapping();
                for (EjbRelationshipRoleType.RoleMapping.CmrFieldMapping cmrFieldMapping : roleMapping.getCmrFieldMapping()) {
                    JoinColumn joinColumn = new JoinColumn();
                    joinColumn.setName(cmrFieldMapping.getForeignKeyColumn());
                    joinColumn.setReferencedColumnName(cmrFieldMapping.getKeyColumn());
                    field.getJoinColumn().add(joinColumn);
                }
                continue;
            }
            JoinTable joinTable = new JoinTable();
            joinTable.setName(relation.getManyToManyTableName());
            EjbRelationshipRoleType leftRole = (EjbRelationshipRoleType)roles.get(0);
            RelationField left = null;
            if (leftRole.getRelationshipRoleSource() != null) {
                String leftEjbName = leftRole.getRelationshipRoleSource().getEjbName();
                EntityData leftEntityData = (EntityData)entities.get(moduleId + "#" + leftEjbName);
                if (leftEntityData == null) continue;
                left = (RelationField)leftEntityData.relations.get(leftRole.getCmrField().getCmrFieldName());
            }
            if (left != null) {
                left.setJoinTable(joinTable);
                EjbRelationshipRoleType.RoleMapping roleMapping = leftRole.getRoleMapping();
                for (EjbRelationshipRoleType.RoleMapping.CmrFieldMapping cmrFieldMapping : roleMapping.getCmrFieldMapping()) {
                    JoinColumn joinColumn = new JoinColumn();
                    joinColumn.setName(cmrFieldMapping.getForeignKeyColumn());
                    joinColumn.setReferencedColumnName(cmrFieldMapping.getKeyColumn());
                    joinTable.getJoinColumn().add(joinColumn);
                }
            }
            if (roles.size() <= 1) continue;
            EjbRelationshipRoleType rightRole = (EjbRelationshipRoleType)roles.get(1);
            if (left == null) {
                RelationField right = left.getRelatedField();
                if (right == null) {
                    if (rightRole.getCmrField() == null) continue;
                    if (rightRole.getRelationshipRoleSource() != null) {
                        String rightEjbName = rightRole.getRelationshipRoleSource().getEjbName();
                        EntityData rightEntityData = (EntityData)entities.get(moduleId + "#" + rightEjbName);
                        if (rightEntityData == null) continue;
                        right = (RelationField)rightEntityData.relations.get(rightRole.getCmrField().getCmrFieldName());
                    }
                }
                right.setJoinTable(joinTable);
            }
            EjbRelationshipRoleType.RoleMapping roleMapping = rightRole.getRoleMapping();
            for (EjbRelationshipRoleType.RoleMapping.CmrFieldMapping cmrFieldMapping : roleMapping.getCmrFieldMapping()) {
                JoinColumn joinColumn = new JoinColumn();
                joinColumn.setName(cmrFieldMapping.getForeignKeyColumn());
                joinColumn.setReferencedColumnName(cmrFieldMapping.getKeyColumn());
                joinTable.getInverseJoinColumn().add(joinColumn);
            }
        }
    }

    public static GeronimoEjbJarType convertToGeronimoOpenejbXml(OpenejbJarType o2) {
        GeronimoEjbJarType g2 = new GeronimoEjbJarType();
        g2.setEnvironment(o2.getEnvironment());
        g2.setSecurity(o2.getSecurity());
        g2.getService().addAll(o2.getService());
        g2.getMessageDestination().addAll(o2.getMessageDestination());
        g2.getPersistence().addAll(o2.getPersistence());
        for (EnterpriseBean bean : o2.getEnterpriseBeans()) {
            RpcBean rpcBean;
            g2.getAbstractNamingEntry().addAll(bean.getAbstractNamingEntry());
            g2.getPersistenceContextRef().addAll(bean.getPersistenceContextRef());
            g2.getPersistenceUnitRef().addAll(bean.getPersistenceUnitRef());
            g2.getEjbLocalRef().addAll(bean.getEjbLocalRef());
            g2.getEjbRef().addAll(bean.getEjbRef());
            g2.getResourceEnvRef().addAll(bean.getResourceEnvRef());
            g2.getResourceRef().addAll(bean.getResourceRef());
            g2.getServiceRef().addAll(bean.getServiceRef());
            if (bean instanceof RpcBean && (rpcBean = (RpcBean)bean).getTssLink() != null) {
                g2.getTssLink().add(new TssLinkType(rpcBean.getEjbName(), rpcBean.getTssLink(), rpcBean.getJndiName()));
            }
            if (!(bean instanceof SessionBeanType)) continue;
            SessionBeanType sb = (SessionBeanType)bean;
            WebServiceBindingType b = new WebServiceBindingType();
            b.setEjbName(sb.getEjbName());
            b.setWebServiceAddress(sb.getWebServiceAddress());
            b.setWebServiceVirtualHost(sb.getWebServiceVirtualHost());
            b.setWebServiceSecurity(sb.getWebServiceSecurity());
            if (!b.containsData()) continue;
            g2.getWebServiceBinding().add(b);
        }
        return g2;
    }

    private class EntityData {
        private final Entity entity;
        private final Map<String, Field> fields = new TreeMap<String, Field>();
        private final Map<String, RelationField> relations = new TreeMap<String, RelationField>();

        public EntityData(Entity entity) {
            String name;
            if (entity == null) {
                throw new NullPointerException("entity is null");
            }
            this.entity = entity;
            Attributes attributes = entity.getAttributes();
            if (attributes != null) {
                for (Id id : attributes.getId()) {
                    name = id.getName();
                    this.fields.put(name, (Field)id);
                }
                for (Basic basic : attributes.getBasic()) {
                    name = basic.getName();
                    this.fields.put(name, (Field)basic);
                }
                for (OneToOne relationField : attributes.getOneToOne()) {
                    name = relationField.getName();
                    this.relations.put(name, (RelationField)relationField);
                }
                for (OneToOne relationField : attributes.getOneToMany()) {
                    name = relationField.getName();
                    this.relations.put(name, (RelationField)relationField);
                }
                for (OneToOne relationField : attributes.getManyToOne()) {
                    name = relationField.getName();
                    this.relations.put(name, (RelationField)relationField);
                }
                for (OneToOne relationField : attributes.getManyToMany()) {
                    name = relationField.getName();
                    this.relations.put(name, (RelationField)relationField);
                }
            }
            for (AttributeOverride attributeOverride : entity.getAttributeOverride()) {
                name = attributeOverride.getName();
                this.fields.put(name, (Field)attributeOverride);
            }
        }
    }
}

