/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Properties;

public class RemoteServer {
    private static final boolean DEBUG = System.getProperty("openejb.server.debug", "false").equalsIgnoreCase("TRUE");
    private static final boolean TOMCAT;
    private boolean serverHasAlreadyBeenStarted = true;
    private Properties properties;
    private Process server;

    public void init(Properties props) {
        this.properties = props;
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", "127.0.0.1:4201");
        props.put("java.naming.security.principal", "testuser");
        props.put("java.naming.security.credentials", "testpassword");
    }

    public static void main(String[] args) {
        assert (args.length > 0) : "no arguments supplied: valid arguments are 'start' or 'stop'";
        if (args[0].equalsIgnoreCase("start")) {
            new RemoteServer().start();
        } else if (args[0].equalsIgnoreCase("stop")) {
            RemoteServer remoteServer = new RemoteServer();
            remoteServer.serverHasAlreadyBeenStarted = false;
            remoteServer.stop();
        } else {
            throw new RuntimeException("valid arguments are 'start' or 'stop'");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void destroy() {
        this.stop();
    }

    public void start() {
        if (!this.connect()) {
            try {
                String[] args;
                System.out.println("[] START SERVER");
                File home = RemoteServer.getHome();
                System.out.println("OPENEJB_HOME = " + home.getAbsolutePath());
                String systemInfo = "Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "/" + System.getProperty("os.version");
                System.out.println("SYSTEM_INFO  = " + systemInfo);
                this.serverHasAlreadyBeenStarted = false;
                File openejbJar = null;
                File javaagentJar = null;
                File lib = !TOMCAT ? new File(home, "lib") : new File(new File(new File(home, "webapps"), "openejb"), "lib");
                for (File file : lib.listFiles()) {
                    if (file.getName().startsWith("openejb-core") && file.getName().endsWith("jar")) {
                        openejbJar = file;
                    }
                    if (!file.getName().startsWith("openejb-javaagent") || !file.getName().endsWith("jar")) continue;
                    javaagentJar = file;
                }
                if (openejbJar == null) {
                    throw new IllegalStateException("Cannot find the openejb-core jar in " + lib.getAbsolutePath());
                }
                if (javaagentJar == null) {
                    throw new IllegalStateException("Cannot find the openejb-javaagent jar in " + lib.getAbsolutePath());
                }
                if (!TOMCAT) {
                    args = DEBUG ? new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-Xdebug", "-Xnoagent", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005", "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"} : new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"};
                } else {
                    File bin = new File(home, "bin");
                    File bootstrapJar = new File(bin, "bootstrap.jar");
                    File commonsLoggingJar = new File(bin, "commons-logging-api.jar");
                    File conf = new File(home, "conf");
                    File loggingProperties = new File(conf, "logging.properties");
                    File endorsed = new File(home, "endorsed");
                    File temp = new File(home, "temp");
                    args = DEBUG ? new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-Xdebug", "-Xnoagent", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005", "-javaagent:" + javaagentJar.getAbsolutePath(), "-Dcom.sun.management.jmxremote", "-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager", "-Djava.util.logging.config.file=" + loggingProperties.getAbsolutePath(), "-Djava.io.tmpdir=" + temp.getAbsolutePath(), "-Djava.endorsed.dirs=" + endorsed.getAbsolutePath(), "-Dcatalina.base=" + home.getAbsolutePath(), "-Dcatalina.home=" + home.getAbsolutePath(), "-Dopenejb.servicemanager.enabled=" + Boolean.getBoolean("openejb.servicemanager.enabled"), "-classpath", bootstrapJar.getAbsolutePath() + ":" + commonsLoggingJar.getAbsolutePath(), "org.apache.catalina.startup.Bootstrap", "start"} : new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-javaagent:" + javaagentJar.getAbsolutePath(), "-Dcom.sun.management.jmxremote", "-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager", "-Djava.util.logging.config.file=" + loggingProperties.getAbsolutePath(), "-Djava.io.tmpdir=" + temp.getAbsolutePath(), "-Djava.endorsed.dirs=" + endorsed.getAbsolutePath(), "-Dcatalina.base=" + home.getAbsolutePath(), "-Dcatalina.home=" + home.getAbsolutePath(), "-Dopenejb.servicemanager.enabled=" + Boolean.getBoolean("openejb.servicemanager.enabled"), "-classpath", bootstrapJar.getAbsolutePath() + ":" + commonsLoggingJar.getAbsolutePath(), "org.apache.catalina.startup.Bootstrap", "start"};
                }
                this.server = Runtime.getRuntime().exec(args);
                InputStream out = this.server.getInputStream();
                Thread serverOut = new Thread(new Pipe(out, System.out));
                serverOut.setDaemon(true);
                serverOut.start();
                InputStream err = this.server.getErrorStream();
                Thread serverErr = new Thread(new Pipe(err, System.err));
                serverErr.setDaemon(true);
                serverErr.start();
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException("Cannot start the server.  Exception: " + e.getClass().getName() + ": " + e.getMessage()).initCause(e);
            }
            if (DEBUG) {
                this.connect(Integer.MAX_VALUE);
            } else {
                this.connect(10);
            }
        }
    }

    private static File getHome() {
        String openejbHome = System.getProperty("openejb.home");
        if (openejbHome != null) {
            return new File(openejbHome);
        }
        return null;
    }

    public void stop() {
        if (!this.serverHasAlreadyBeenStarted) {
            try {
                String command;
                int port;
                System.out.println("[] STOP SERVER");
                if (!TOMCAT) {
                    port = 4200;
                    command = "Stop";
                } else {
                    port = 8005;
                    command = "SHUTDOWN";
                }
                Socket socket = new Socket("localhost", port);
                OutputStream out = socket.getOutputStream();
                out.write(command.getBytes());
                if (this.server != null) {
                    this.server.waitFor();
                    this.server = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean connect() {
        return this.connect(1);
    }

    private boolean connect(int tries) {
        try {
            int port = !TOMCAT ? 4200 : 8005;
            Socket socket = new Socket("localhost", port);
            OutputStream out = socket.getOutputStream();
            out.close();
        }
        catch (Exception e) {
            if (tries < 2) {
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            return this.connect(--tries);
        }
        return true;
    }

    static {
        File home = RemoteServer.getHome();
        TOMCAT = home != null && new File(new File(home, "bin"), "catalina.sh").exists();
    }

    private static final class Pipe
    implements Runnable {
        private final InputStream is;
        private final OutputStream out;

        private Pipe(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        public void run() {
            try {
                int i = this.is.read();
                this.out.write(i);
                while (i != -1) {
                    i = this.is.read();
                    this.out.write(i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

