/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.NoSuchProviderException;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.config.sys.ServicesJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtils {
    public static final String ANY = ServiceUtils.class.getName() + "@ANY";
    public static final String NONE = ServiceUtils.class.getName() + "@NONE";
    public static final String defaultProviderURL;
    private static Map<String, List<ServiceProvider>> loadedServiceJars;
    public static Messages messages;
    public static Logger logger;

    public static boolean hasServiceProvider(String id) {
        try {
            ProviderInfo info = ServiceUtils.getProviderInfo(id);
            List<ServiceProvider> services = ServiceUtils.getServiceProviders(info.getPackageName());
            for (ServiceProvider service : services) {
                if (!service.getId().equals(id)) continue;
                return true;
            }
        }
        catch (OpenEJBException openEJBException) {
            // empty catch block
        }
        return false;
    }

    public static ServiceProvider getServiceProvider(String id) throws OpenEJBException {
        ProviderInfo info = ServiceUtils.getProviderInfo(id);
        List<ServiceProvider> services = ServiceUtils.getServiceProviders(info.getPackageName());
        for (ServiceProvider service : services) {
            if (!service.getId().equals(info.getServiceName())) continue;
            return service;
        }
        throw new NoSuchProviderException(messages.format("conf.4901", info.getServiceName(), info.getPackageName()));
    }

    public static String getServiceProviderId(String type) throws OpenEJBException {
        return ServiceUtils.getServiceProviderId(type, null);
    }

    public static String getServiceProviderId(String type, Properties required) throws OpenEJBException {
        ServiceProvider provider = ServiceUtils.getServiceProviderByType(type, required);
        return provider != null ? provider.getId() : null;
    }

    public static List<ServiceProvider> getServiceProvidersByServiceType(String type) throws OpenEJBException {
        ArrayList<ServiceProvider> providers = new ArrayList<ServiceProvider>();
        if (type == null) {
            return providers;
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProviders(defaultProviderURL);
        for (ServiceProvider service : services) {
            if (!service.getService().equals(type)) continue;
            providers.add(service);
        }
        return providers;
    }

    public static ServiceProvider getServiceProviderByType(String type) throws OpenEJBException {
        return ServiceUtils.getServiceProviderByType(type, (Properties)null);
    }

    public static ServiceProvider getServiceProviderByType(String type, Properties required) throws OpenEJBException {
        if (type == null) {
            return null;
        }
        if (required == null) {
            required = new Properties();
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProviders(defaultProviderURL);
        for (ServiceProvider service : services) {
            if (!service.getTypes().contains(type) || !ServiceUtils.implies(required, service.getProperties())) continue;
            return service;
        }
        return null;
    }

    public static boolean implies(Properties required, Properties available) {
        for (Map.Entry<Object, Object> entry : required.entrySet()) {
            Object value = available.get(entry.getKey());
            Object expected = entry.getValue();
            if (expected.equals(NONE)) {
                if (value == null) continue;
                return false;
            }
            if (expected.equals(ANY)) {
                if (value != null) continue;
                return false;
            }
            if (value instanceof String) {
                value = ((String)value).toLowerCase();
            }
            if (expected instanceof String) {
                expected = ((String)expected).toLowerCase();
            }
            if (expected.equals(value)) continue;
            return false;
        }
        return true;
    }

    public static ServiceProvider getServiceProviderByType(String providerType, String serviceType) throws OpenEJBException {
        if (serviceType == null) {
            return null;
        }
        List<ServiceProvider> services = ServiceUtils.getServiceProvidersByServiceType(providerType);
        for (ServiceProvider service : services) {
            if (!service.getTypes().contains(serviceType)) continue;
            return service;
        }
        return null;
    }

    public static List<ServiceProvider> getServiceProviders() throws OpenEJBException {
        return ServiceUtils.getServiceProviders(defaultProviderURL);
    }

    public static List<ServiceProvider> getServiceProviders(String packageName) throws OpenEJBException {
        List<ServiceProvider> services = loadedServiceJars.get(packageName);
        if (services == null) {
            ServicesJar servicesJar = JaxbOpenejb.readServicesJar(packageName);
            List<ServiceProvider> serviceProviders = servicesJar.getServiceProvider();
            services = new ArrayList<ServiceProvider>(serviceProviders);
            loadedServiceJars.put(packageName, services);
        }
        return services;
    }

    public static void registerServiceProvider(String packageName, ServiceProvider provider) {
        List<ServiceProvider> services = loadedServiceJars.get(packageName);
        if (services == null) {
            ServicesJar servicesJar = null;
            try {
                servicesJar = JaxbOpenejb.readServicesJar(packageName);
            }
            catch (OpenEJBException e) {
                servicesJar = new ServicesJar();
            }
            List<ServiceProvider> serviceProviders = servicesJar.getServiceProvider();
            services = new ArrayList<ServiceProvider>(serviceProviders);
            loadedServiceJars.put(packageName, services);
        }
        services.add(provider);
    }

    private static ProviderInfo getProviderInfo(String id) {
        String providerName = null;
        String serviceName = null;
        if (id.indexOf("#") != -1) {
            providerName = id.substring(0, id.indexOf("#"));
            serviceName = id.substring(id.indexOf("#") + 1);
        } else if (id.indexOf(":") != -1) {
            providerName = id.substring(0, id.indexOf(":"));
            serviceName = id.substring(id.indexOf(":") + 1);
        } else {
            providerName = defaultProviderURL;
            serviceName = id;
        }
        return new ProviderInfo(providerName, serviceName);
    }

    public static Properties loadProperties(String pFile) throws OpenEJBException {
        return ServiceUtils.loadProperties(pFile, new Properties());
    }

    public static Properties loadProperties(String propertiesFile, Properties defaults) throws OpenEJBException {
        try {
            File pfile = new File(propertiesFile);
            FileInputStream in = new FileInputStream(pfile);
            try {
                defaults.load(in);
            }
            catch (IOException ex) {
                throw new OpenEJBException(messages.format("conf.0012", ex.getLocalizedMessage()), ex);
            }
            return defaults;
        }
        catch (FileNotFoundException ex) {
            throw new OpenEJBException(messages.format("conf.0006", propertiesFile, ex.getLocalizedMessage()), ex);
        }
        catch (IOException ex) {
            throw new OpenEJBException(messages.format("conf.0007", propertiesFile, ex.getLocalizedMessage()), ex);
        }
        catch (SecurityException ex) {
            throw new OpenEJBException(messages.format("conf.0005", propertiesFile, ex.getLocalizedMessage()), ex);
        }
    }

    static {
        String defaultValue = "org.apache.openejb";
        try {
            SystemInstance system = SystemInstance.get();
            if (system.getProperty("openejb.embedded") != null) {
                defaultValue = "org.apache.openejb.embedded";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        defaultProviderURL = SystemInstance.get().getOptions().get("openejb.provider.default", defaultValue);
        loadedServiceJars = new HashMap<String, List<ServiceProvider>>();
        messages = new Messages("org.apache.openejb.util.resources");
        logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    }

    public static class ProviderInfo {
        private final String packageName;
        private final String serviceName;

        public ProviderInfo(String providerName, String serviceName) {
            this.packageName = providerName;
            this.serviceName = serviceName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

