/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.Identity;
import java.security.Principal;
import java.util.Properties;
import javax.ejb.EJBContext;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.TimerService;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.UnauthenticatedPrincipal;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.timer.TimerServiceImpl;
import org.apache.openejb.core.transaction.EjbUserTransaction;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.spi.SecurityService;

public abstract class BaseContext
implements EJBContext,
Serializable {
    private final SecurityService securityService;
    private final UserTransaction userTransaction;
    protected static State[] states;

    protected BaseContext(SecurityService securityService) {
        this(securityService, new EjbUserTransaction());
    }

    protected BaseContext(SecurityService securityService, UserTransaction userTransaction) {
        this.securityService = securityService;
        this.userTransaction = new UserTransactionWrapper(userTransaction);
    }

    public static State[] getStates() {
        return states;
    }

    protected abstract State getState();

    public EJBHome getEJBHome() {
        return this.getState().getEJBHome();
    }

    public EJBLocalHome getEJBLocalHome() {
        return this.getState().getEJBLocalHome();
    }

    public final Properties getEnvironment() {
        throw new UnsupportedOperationException();
    }

    public final Identity getCallerIdentity() {
        throw new UnsupportedOperationException();
    }

    public Principal getCallerPrincipal() {
        Principal callerPrincipal = this.getState().getCallerPrincipal(this.securityService);
        if (callerPrincipal == null) {
            callerPrincipal = UnauthenticatedPrincipal.INSTANCE;
        }
        return callerPrincipal;
    }

    public final boolean isCallerInRole(Identity identity) {
        throw new UnsupportedOperationException();
    }

    public boolean isCallerInRole(String roleName) {
        return this.getState().isCallerInRole(this.securityService, roleName);
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        return this.getState().getUserTransaction(this.userTransaction);
    }

    public void setRollbackOnly() throws IllegalStateException {
        this.getState().setRollbackOnly();
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        return this.getState().getRollbackOnly();
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getState().getTimerService();
    }

    public Object lookup(String name) {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
        Context jndiEnc = deploymentInfo.getJndiEnc();
        try {
            jndiEnc = (Context)jndiEnc.lookup("java:comp/env");
            return jndiEnc.lookup(name);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isUserTransactionAccessAllowed() {
        return this.getState().isUserTransactionAccessAllowed();
    }

    public boolean isMessageContextAccessAllowed() {
        return this.getState().isMessageContextAccessAllowed();
    }

    public boolean isJNDIAccessAllowed() {
        return this.getState().isJNDIAccessAllowed();
    }

    public boolean isEntityManagerFactoryAccessAllowed() {
        return this.getState().isEntityManagerFactoryAccessAllowed();
    }

    public boolean isEntityManagerAccessAllowed() {
        return this.getState().isEntityManagerAccessAllowed();
    }

    public boolean isTimerAccessAllowed() {
        return this.getState().isTimerAccessAllowed();
    }

    public static boolean isTimerMethodAllowed() {
        State[] currentStates = ThreadContext.getThreadContext().getCurrentAllowedStates();
        State currentState = currentStates[ThreadContext.getThreadContext().getCurrentOperation().ordinal()];
        return currentState.isTimerMethodAllowed();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new IntraVmArtifact(this, true);
    }

    public static class State {
        public EJBHome getEJBHome() {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            return di.getEJBHome();
        }

        public EJBLocalHome getEJBLocalHome() {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            return di.getEJBLocalHome();
        }

        public Principal getCallerPrincipal(SecurityService securityService) {
            return securityService.getCallerPrincipal();
        }

        public boolean isCallerInRole(SecurityService securityService, String roleName) {
            return securityService.isCallerInRole(roleName);
        }

        public UserTransaction getUserTransaction(UserTransaction userTransaction) throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.isBeanManagedTransaction()) {
                return userTransaction;
            }
            throw new IllegalStateException("container-managed transaction beans can not access the UserTransaction");
        }

        public void setRollbackOnly() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.isBeanManagedTransaction()) {
                throw new IllegalStateException("bean-managed transaction beans can not access the setRollbackOnly() method");
            }
            TransactionPolicy txPolicy = threadContext.getTransactionPolicy();
            if (txPolicy == null) {
                throw new IllegalStateException("ThreadContext does not contain a TransactionEnvironment");
            }
            if (!txPolicy.isTransactionActive()) {
                throw new IllegalStateException("No current transaction");
            }
            txPolicy.setRollbackOnly();
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            if (di.isBeanManagedTransaction()) {
                throw new IllegalStateException("bean-managed transaction beans can not access the getRollbackOnly() method: deploymentId=" + di.getDeploymentID());
            }
            TransactionPolicy transactionPolicy = threadContext.getTransactionPolicy();
            if (transactionPolicy == null) {
                throw new IllegalStateException("ThreadContext does not contain a TransactionEnvironment");
            }
            if (!transactionPolicy.isTransactionActive()) {
                throw new IllegalStateException("No current transaction");
            }
            return transactionPolicy.isRollbackOnly();
        }

        public TimerService getTimerService() throws IllegalStateException {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo deploymentInfo = threadContext.getDeploymentInfo();
            EjbTimerService timerService = deploymentInfo.getEjbTimerService();
            if (timerService == null) {
                throw new IllegalStateException("This ejb does not support timers " + deploymentInfo.getDeploymentID());
            }
            return new TimerServiceImpl(timerService, threadContext.getPrimaryKey());
        }

        public boolean isTimerAccessAllowed() {
            return true;
        }

        public boolean isTimerMethodAllowed() {
            return true;
        }

        public boolean isUserTransactionAccessAllowed() {
            ThreadContext threadContext = ThreadContext.getThreadContext();
            CoreDeploymentInfo di = threadContext.getDeploymentInfo();
            return di.isBeanManagedTransaction();
        }

        public boolean isMessageContextAccessAllowed() {
            return true;
        }

        public boolean isJNDIAccessAllowed() {
            return true;
        }

        public boolean isEntityManagerFactoryAccessAllowed() {
            return true;
        }

        public boolean isEntityManagerAccessAllowed() {
            return true;
        }
    }

    public class UserTransactionWrapper
    implements UserTransaction {
        private UserTransaction userTransaction;

        public UserTransactionWrapper(UserTransaction userTransaction) {
            this.userTransaction = userTransaction;
        }

        public void begin() throws NotSupportedException, SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            this.userTransaction.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            this.userTransaction.commit();
        }

        public int getStatus() throws SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            return this.userTransaction.getStatus();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            this.userTransaction.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            this.userTransaction.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            if (!BaseContext.this.isUserTransactionAccessAllowed()) {
                throw new IllegalStateException();
            }
            this.userTransaction.setTransactionTimeout(i);
        }
    }
}

