/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.cmp;

import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EntityBean;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.entity.EntityEjbHomeHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public class ProxyFactory {
    private final CoreDeploymentInfo deploymentInfo;
    private final KeyGenerator keyGenerator;
    private final Class remoteInterface;
    private final EntityEjbHomeHandler remoteHandler;
    private final Class localInterface;
    private final EntityEjbHomeHandler localHandler;

    public ProxyFactory(CoreDeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
        this.keyGenerator = deploymentInfo.getKeyGenerator();
        this.remoteInterface = deploymentInfo.getRemoteInterface();
        if (this.remoteInterface != null) {
            EJBHome homeProxy = deploymentInfo.getEJBHome();
            this.remoteHandler = (EntityEjbHomeHandler)ProxyManager.getInvocationHandler(homeProxy);
        } else {
            this.remoteHandler = null;
        }
        this.localInterface = deploymentInfo.getLocalInterface();
        if (this.localInterface != null) {
            EJBLocalHome localHomeProxy = deploymentInfo.getEJBLocalHome();
            this.localHandler = (EntityEjbHomeHandler)ProxyManager.getInvocationHandler(localHomeProxy);
        } else {
            this.localHandler = null;
        }
    }

    public Object createRemoteProxy(EntityBean bean, RpcContainer container) {
        Object primaryKey = this.keyGenerator.getPrimaryKey(bean);
        Object proxy = this.remoteHandler.createProxy(primaryKey);
        return proxy;
    }

    public Object createLocalProxy(EntityBean bean, RpcContainer container) {
        Object primaryKey = this.keyGenerator.getPrimaryKey(bean);
        Object proxy = this.localHandler.createProxy(primaryKey);
        return proxy;
    }
}

