/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.managed;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.managed.PassivationStrategy;
import org.apache.openejb.spi.Serializer;

public class RAFPassivater
implements PassivationStrategy {
    int fileID = 0;
    Hashtable masterTable = new Hashtable();

    public void init(Properties props) throws SystemException {
    }

    public synchronized void passivate(Map stateTable) throws SystemException {
        try {
            ++this.fileID;
            RandomAccessFile ras = new RandomAccessFile(System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "passivation" + this.fileID + ".ser", "rw");
            Iterator iterator = stateTable.keySet().iterator();
            Pointer lastPointer = null;
            while (iterator.hasNext()) {
                Object id = iterator.next();
                Object obj = stateTable.get(id);
                byte[] bytes = Serializer.serialize(obj);
                long filepointer = ras.getFilePointer();
                lastPointer = lastPointer == null ? new Pointer(this.fileID, filepointer, (int)filepointer) : new Pointer(this.fileID, filepointer, (int)(filepointer - lastPointer.filepointer));
                this.masterTable.put(id, lastPointer);
                ras.write(bytes);
            }
            ras.close();
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public synchronized Object activate(Object primaryKey) throws SystemException {
        Pointer pointer = (Pointer)this.masterTable.get(primaryKey);
        if (pointer == null) {
            return null;
        }
        try {
            RandomAccessFile ras = new RandomAccessFile(System.getProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "passivation" + pointer.fileid + ".ser", "r");
            byte[] bytes = new byte[pointer.bytesize];
            ras.seek(pointer.filepointer);
            ras.readFully(bytes);
            ras.close();
            return Serializer.deserialize(bytes);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    static class Pointer {
        int fileid;
        long filepointer;
        int bytesize;

        public Pointer(int file, long pointer, int bytecount) {
            this.fileid = file;
            this.filepointer = pointer;
            this.bytesize = bytecount;
        }
    }
}

