/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.MessageDrivenBean;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.resource.spi.UnavailableException;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbContext;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;

public class MdbInstanceFactory {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final CoreDeploymentInfo deploymentInfo;
    private final SecurityService securityService;
    private final int instanceLimit;
    private int instanceCount;

    public MdbInstanceFactory(CoreDeploymentInfo deploymentInfo, SecurityService securityService, int instanceLimit) {
        this.deploymentInfo = deploymentInfo;
        this.securityService = securityService;
        this.instanceLimit = instanceLimit;
    }

    public int getInstanceLimit() {
        return this.instanceLimit;
    }

    public synchronized int getInstanceCount() {
        return this.instanceCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createInstance(boolean ignoreInstanceCount) throws UnavailableException {
        if (!ignoreInstanceCount) {
            MdbInstanceFactory mdbInstanceFactory = this;
            synchronized (mdbInstanceFactory) {
                if (this.instanceLimit > 0 && this.instanceCount >= this.instanceLimit) {
                    throw new UnavailableException("Only " + this.instanceLimit + " instances can be created");
                }
                ++this.instanceCount;
            }
        }
        try {
            Object bean = this.constructBean();
            return bean;
        }
        catch (UnavailableException e) {
            if (!ignoreInstanceCount) {
                MdbInstanceFactory mdbInstanceFactory = this;
                synchronized (mdbInstanceFactory) {
                    --this.instanceCount;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeInstance(Instance instance, boolean ignoredInstanceCount) {
        if (instance == null) {
            throw new NullPointerException("bean is null");
        }
        if (!ignoredInstanceCount) {
            MdbInstanceFactory mdbInstanceFactory = this;
            synchronized (mdbInstanceFactory) {
                --this.instanceCount;
            }
        }
        ThreadContext callContext = ThreadContext.getThreadContext();
        Operation originalOperation = callContext.getCurrentOperation();
        BaseContext.State[] originalAllowedStates = callContext.getCurrentAllowedStates();
        try {
            try {
                callContext.setCurrentOperation(Operation.PRE_DESTROY);
                callContext.setCurrentAllowedStates(MdbContext.getStates());
                Method remove = instance.bean instanceof MessageDrivenBean ? MessageDrivenBean.class.getMethod("ejbRemove", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = this.deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable re) {
                logger.error("The bean instance " + instance.bean + " threw a system exception:" + re, re);
                Object var10_11 = null;
                callContext.setCurrentOperation(originalOperation);
                callContext.setCurrentAllowedStates(originalAllowedStates);
                return;
            }
            Object var10_10 = null;
            callContext.setCurrentOperation(originalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            callContext.setCurrentOperation(originalOperation);
            callContext.setCurrentAllowedStates(originalAllowedStates);
            throw throwable;
        }
    }

    public Object recreateInstance(Object bean) throws UnavailableException {
        if (bean == null) {
            throw new NullPointerException("bean is null");
        }
        Object newBean = this.constructBean();
        return newBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object constructBean() throws UnavailableException {
        Instance instance;
        Class beanClass = this.deploymentInfo.getBeanClass();
        ThreadContext callContext = new ThreadContext(this.deploymentInfo, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        try {
            Class clazz;
            MdbContext mdbContext;
            Context ctx = this.deploymentInfo.getJndiEnc();
            MdbInstanceFactory mdbInstanceFactory = this;
            synchronized (mdbInstanceFactory) {
                try {
                    mdbContext = (MdbContext)ctx.lookup("java:comp/EJBContext");
                }
                catch (NamingException e) {
                    mdbContext = new MdbContext(this.securityService);
                    ctx.bind("java:comp/EJBContext", (Object)mdbContext);
                }
            }
            InjectionProcessor injectionProcessor = new InjectionProcessor(beanClass, this.deploymentInfo.getInjections(), null, null, InjectionProcessor.unwrap(ctx));
            callContext.setCurrentOperation(Operation.INJECTION);
            callContext.setCurrentAllowedStates(MdbContext.getStates());
            if (MessageDrivenBean.class.isAssignableFrom(beanClass)) {
                injectionProcessor.setProperty("messageDrivenContext", mdbContext);
            }
            Object bean = injectionProcessor.createInstance();
            HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
            for (InterceptorInstance interceptorInstance : this.deploymentInfo.getSystemInterceptors()) {
                clazz = interceptorInstance.getData().getInterceptorClass();
                interceptorInstances.put(clazz.getName(), interceptorInstance.getInterceptor());
            }
            for (InterceptorData interceptorData : this.deploymentInfo.getInstanceScopedInterceptors()) {
                if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                clazz = interceptorData.getInterceptorClass();
                InjectionProcessor interceptorInjector = new InjectionProcessor(clazz, this.deploymentInfo.getInjections(), InjectionProcessor.unwrap(ctx));
                try {
                    Object interceptorInstance = interceptorInjector.createInstance();
                    interceptorInstances.put(clazz.getName(), interceptorInstance);
                }
                catch (ConstructionException e) {
                    throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                }
            }
            interceptorInstances.put(beanClass.getName(), bean);
            Instance instance2 = new Instance(bean, interceptorInstances);
            callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
            callContext.setCurrentAllowedStates(MdbContext.getStates());
            List<InterceptorData> callbackInterceptors = this.deploymentInfo.getCallbackInterceptors();
            InterceptorStack interceptorStack = new InterceptorStack(bean, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
            interceptorStack.invoke(new Object[0]);
            if (bean instanceof MessageDrivenBean) {
                callContext.setCurrentOperation(Operation.CREATE);
                callContext.setCurrentAllowedStates(MdbContext.getStates());
                Method create = this.deploymentInfo.getCreateMethod();
                interceptorStack = new InterceptorStack(bean, create, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                interceptorStack.invoke(new Object[0]);
            }
            instance = instance2;
            Object var15_20 = null;
        }
        catch (Throwable e) {
            try {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                String message = "The bean instance threw a system exception:" + e;
                logger.error(message, e);
                throw new UnavailableException(message, e);
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                ThreadContext.exit(oldContext);
                throw throwable;
            }
        }
        ThreadContext.exit(oldContext);
        return instance;
    }

    private static void fillInjectionProperties(ObjectRecipe objectRecipe, Class clazz, CoreDeploymentInfo deploymentInfo, Context context) {
        for (Injection injection : deploymentInfo.getInjections()) {
            if (!injection.getTarget().isAssignableFrom(clazz)) continue;
            try {
                String jndiName = injection.getJndiName();
                Object object = context.lookup("java:comp/env/" + jndiName);
                if (object instanceof String) {
                    String string = (String)object;
                    objectRecipe.setProperty(injection.getTarget().getName() + "/" + injection.getName(), (Object)string);
                    continue;
                }
                objectRecipe.setProperty(injection.getTarget().getName() + "/" + injection.getName(), object);
            }
            catch (NamingException e) {
                logger.warning("Injection data not found in enc: jndiName='" + injection.getJndiName() + "', target=" + injection.getTarget() + "/" + injection.getName());
            }
        }
    }
}

