/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.SessionSynchronization;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.Transaction;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.ContainerType;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.Instance;
import org.apache.openejb.core.stateful.StatefulContext;
import org.apache.openejb.core.stateful.StatefulUserTransaction;
import org.apache.openejb.core.transaction.BeanTransactionPolicy;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.EjbUserTransaction;
import org.apache.openejb.core.transaction.JtaTransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.ManagedMBean;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.persistence.EntityManagerAlreadyRegisteredException;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.recipe.ConstructionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulContainer
implements RpcContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final Object containerID;
    private final SecurityService securityService;
    protected final JtaEntityManagerRegistry entityManagerRegistry = (JtaEntityManagerRegistry)SystemInstance.get().getComponent(JtaEntityManagerRegistry.class);
    protected final Map<Object, DeploymentInfo> deploymentsById = new HashMap<Object, DeploymentInfo>();
    protected final Cache<Object, Instance> cache;
    private final ConcurrentHashMap<Object, Instance> checkedOutInstances = new ConcurrentHashMap();

    public StatefulContainer(Object id, SecurityService securityService, Cache<Object, Instance> cache) {
        this.containerID = id;
        this.securityService = securityService;
        this.cache = cache;
        cache.setListener(new StatefulCacheListener());
    }

    private Map<Method, MethodType> getLifecycleMethodsOfInterface(CoreDeploymentInfo deploymentInfo) {
        Class localHomeInterface;
        Class homeInterface;
        Class businessRemoteHomeInterface;
        Class businessLocalBeanHomeInterface;
        Class businessLocalHomeInterface;
        Class legacyLocal;
        HashMap<Method, MethodType> methods = new HashMap<Method, MethodType>();
        List<Method> removeMethods = deploymentInfo.getRemoveMethods();
        for (Method removeMethod : removeMethods) {
            Method method;
            methods.put(removeMethod, MethodType.REMOVE);
            for (Class businessLocal : deploymentInfo.getBusinessLocalInterfaces()) {
                try {
                    method = businessLocal.getMethod(removeMethod.getName(), new Class[0]);
                    methods.put(method, MethodType.REMOVE);
                }
                catch (NoSuchMethodException thatsFine) {}
            }
            for (Class businessRemote : deploymentInfo.getBusinessRemoteInterfaces()) {
                try {
                    method = businessRemote.getMethod(removeMethod.getName(), new Class[0]);
                    methods.put(method, MethodType.REMOVE);
                }
                catch (NoSuchMethodException thatsFine) {}
            }
        }
        Class legacyRemote = deploymentInfo.getRemoteInterface();
        if (legacyRemote != null) {
            try {
                Method method = legacyRemote.getMethod("remove", new Class[0]);
                methods.put(method, MethodType.REMOVE);
            }
            catch (NoSuchMethodException thatsFine) {
                // empty catch block
            }
        }
        if ((legacyLocal = deploymentInfo.getLocalInterface()) != null) {
            try {
                Method method = legacyLocal.getMethod("remove", new Class[0]);
                methods.put(method, MethodType.REMOVE);
            }
            catch (NoSuchMethodException thatsFine) {
                // empty catch block
            }
        }
        if ((businessLocalHomeInterface = deploymentInfo.getBusinessLocalInterface()) != null) {
            for (Method method : DeploymentInfo.BusinessLocalHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((businessLocalBeanHomeInterface = deploymentInfo.getBusinessLocalBeanInterface()) != null) {
            for (Method method : DeploymentInfo.BusinessLocalBeanHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((businessRemoteHomeInterface = deploymentInfo.getBusinessRemoteInterface()) != null) {
            for (Method method : DeploymentInfo.BusinessRemoteHome.class.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((homeInterface = deploymentInfo.getHomeInterface()) != null) {
            for (Method method : homeInterface.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        if ((localHomeInterface = deploymentInfo.getLocalHomeInterface()) != null) {
            for (Method method : localHomeInterface.getMethods()) {
                if (method.getName().startsWith("create")) {
                    methods.put(method, MethodType.CREATE);
                    continue;
                }
                if (!method.getName().equals("remove")) continue;
                methods.put(method, MethodType.REMOVE);
            }
        }
        return methods;
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.STATEFUL;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public synchronized DeploymentInfo[] deployments() {
        return this.deploymentsById.values().toArray(new DeploymentInfo[this.deploymentsById.size()]);
    }

    @Override
    public synchronized DeploymentInfo getDeploymentInfo(Object deploymentID) {
        return this.deploymentsById.get(deploymentID);
    }

    @Override
    public void deploy(DeploymentInfo deploymentInfo) throws OpenEJBException {
        this.deploy((CoreDeploymentInfo)deploymentInfo);
    }

    @Override
    public void undeploy(DeploymentInfo info) throws OpenEJBException {
        this.undeploy((CoreDeploymentInfo)info);
    }

    private synchronized void undeploy(final CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        Data data = (Data)deploymentInfo.getContainerData();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName objectName : data.jmxNames) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception e) {
                logger.error("Unable to unregister MBean " + objectName);
            }
        }
        this.deploymentsById.remove(deploymentInfo.getDeploymentID());
        deploymentInfo.setContainer(null);
        deploymentInfo.setContainerData(null);
        this.cache.removeAll(new Cache.CacheFilter<Instance>(){

            @Override
            public boolean matches(Instance instance) {
                return deploymentInfo == instance.deploymentInfo;
            }
        });
    }

    private synchronized void deploy(CoreDeploymentInfo deploymentInfo) throws OpenEJBException {
        Map<Method, MethodType> methods = this.getLifecycleMethodsOfInterface(deploymentInfo);
        this.deploymentsById.put(deploymentInfo.getDeploymentID(), deploymentInfo);
        deploymentInfo.setContainer(this);
        Data data = new Data(new Index<Method, MethodType>(methods));
        deploymentInfo.setContainerData(data);
        StatsInterceptor stats = new StatsInterceptor(deploymentInfo.getBeanClass());
        deploymentInfo.addSystemInterceptor(stats);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "openejb");
        jmxName.set("J2EEApplication", null);
        jmxName.set("EJBModule", deploymentInfo.getModuleID());
        jmxName.set("StatefulSessionBean", deploymentInfo.getEjbName());
        jmxName.set("j2eeType", "");
        jmxName.set("name", deploymentInfo.getEjbName());
        try {
            ObjectName objectName = jmxName.set("j2eeType", "Invocations").build();
            server.registerMBean(new ManagedMBean(stats), objectName);
            data.jmxNames.add(objectName);
        }
        catch (Exception e) {
            logger.error("Unable to register MBean ", e);
        }
    }

    @Override
    public Object invoke(Object deployID, Method callMethod, Object[] args, Object primKey, Object securityIdentity) throws OpenEJBException {
        return this.invoke(deployID, null, callMethod.getDeclaringClass(), callMethod, args, primKey);
    }

    @Override
    public Object invoke(Object deployID, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        return this.invoke(deployID, null, callInterface, callMethod, args, primKey);
    }

    @Override
    public Object invoke(Object deployID, InterfaceType type, Class callInterface, Method callMethod, Object[] args, Object primKey) throws OpenEJBException {
        Data data;
        MethodType methodType;
        CoreDeploymentInfo deployInfo = (CoreDeploymentInfo)this.getDeploymentInfo(deployID);
        if (deployInfo == null) {
            throw new OpenEJBException("Deployment does not exist in this container. Deployment(id='" + deployID + "'), Container(id='" + this.containerID + "')");
        }
        if (type == null) {
            type = deployInfo.getInterfaceType(callInterface);
        }
        methodType = (methodType = (data = (Data)deployInfo.getContainerData()).getMethodIndex().get(callMethod)) != null ? methodType : MethodType.BUSINESS;
        switch (methodType) {
            case CREATE: {
                return this.createEJBObject(deployInfo, callMethod, args, type);
            }
            case REMOVE: {
                return this.removeEJBObject(deployInfo, primKey, callInterface, callMethod, args, type);
            }
        }
        return this.businessMethod(deployInfo, primKey, callInterface, callMethod, args, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProxyInfo createEJBObject(CoreDeploymentInfo deploymentInfo, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        Object primaryKey = this.newPrimaryKey();
        ThreadContext createContext = new ThreadContext(deploymentInfo, primaryKey);
        ThreadContext oldCallContext = ThreadContext.enter(createContext);
        try {
            this.checkAuthorization(callMethod, interfaceType);
            Index<EntityManagerFactory, EntityManager> entityManagers = this.createEntityManagers(deploymentInfo);
            if (entityManagers != null) {
                try {
                    this.entityManagerRegistry.addEntityManagers((String)deploymentInfo.getDeploymentID(), primaryKey, entityManagers);
                }
                catch (EntityManagerAlreadyRegisteredException e) {
                    throw new EJBException((Exception)e);
                }
            }
            createContext.setCurrentOperation(Operation.CREATE);
            createContext.setCurrentAllowedStates(StatefulContext.getStates());
            TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(createContext.getDeploymentInfo().getTransactionType(callMethod), createContext);
            Instance instance = null;
            try {
                instance = this.newInstance(primaryKey, deploymentInfo.getBeanClass(), entityManagers);
                this.registerSessionSynchronization(instance, createContext);
                if (!(callMethod.getDeclaringClass().equals(DeploymentInfo.BusinessLocalHome.class) || callMethod.getDeclaringClass().equals(DeploymentInfo.BusinessRemoteHome.class) || callMethod.getDeclaringClass().equals(DeploymentInfo.BusinessLocalBeanHome.class))) {
                    Method createOrInit = deploymentInfo.getMatchingBeanMethod(callMethod);
                    createContext.set(Method.class, createOrInit);
                    InterceptorStack interceptorStack = new InterceptorStack(instance.bean, createOrInit, Operation.CREATE, new ArrayList<InterceptorData>(), new HashMap<String, Object>());
                    if (args == null) {
                        interceptorStack.invoke(new Object[0]);
                    } else {
                        interceptorStack.invoke(args);
                    }
                }
            }
            catch (Throwable e) {
                this.handleException(createContext, txPolicy, e);
            }
            finally {
                this.afterInvoke(createContext, txPolicy, instance);
            }
            ProxyInfo proxyInfo = new ProxyInfo(deploymentInfo, primaryKey);
            return proxyInfo;
        }
        finally {
            ThreadContext.exit(oldCallContext);
        }
    }

    protected Object newPrimaryKey() {
        return new VMID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object removeEJBObject(CoreDeploymentInfo deploymentInfo, Object primKey, Class callInterface, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        Object object;
        if (primKey == null) {
            throw new NullPointerException("primKey is null");
        }
        ThreadContext callContext = new ThreadContext(deploymentInfo, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Instance instance2;
            this.checkAuthorization(callMethod, interfaceType);
            if (interfaceType.isComponent() && (instance2 = this.checkedOutInstances.get(primKey)) != null && instance2.bean instanceof SessionBean) {
                throw new ApplicationException((Exception)((Object)new RemoveException("A stateful EJB enrolled in a transaction can not be removed")));
            }
            TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(callContext.getDeploymentInfo().getTransactionType(callMethod), callContext);
            Object returnValue = null;
            boolean retain = false;
            Instance instance = null;
            Method runMethod = null;
            try {
                block25: {
                    try {
                        BeanTransactionPolicy.SuspendedTransaction suspendedTransaction;
                        instance = this.obtainInstance(primKey, callContext);
                        if (txPolicy instanceof BeanTransactionPolicy && (suspendedTransaction = instance.getBeanTransaction()) != null) {
                            instance.setBeanTransaction(null);
                            BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
                            beanTxEnv.resumeUserTransaction(suspendedTransaction);
                        }
                        this.registerEntityManagers(instance, callContext);
                        this.registerSessionSynchronization(instance, callContext);
                        callContext.setCurrentOperation(Operation.REMOVE);
                        callContext.setCurrentAllowedStates(StatefulContext.getStates());
                        callContext.setInvokedInterface(callInterface);
                        runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                        callContext.set(Method.class, runMethod);
                        Class<?> declaringClass = callMethod.getDeclaringClass();
                        if (declaringClass.equals(EJBHome.class) || declaringClass.equals(EJBLocalHome.class)) {
                            args = new Object[]{};
                        }
                        List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.REMOVE, interceptors, instance.interceptors);
                        if (args == null) {
                            returnValue = interceptorStack.invoke(new Object[0]);
                            break block25;
                        }
                        returnValue = interceptorStack.invoke(args);
                    }
                    catch (InvalidateReferenceException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        block30: {
                            block28: {
                                if (interfaceType.isBusiness()) {
                                    retain = deploymentInfo.retainIfExeption(runMethod);
                                    this.handleException(callContext, txPolicy, e);
                                } else {
                                    try {
                                        this.handleException(callContext, txPolicy, e);
                                    }
                                    catch (ApplicationException ae) {
                                    }
                                }
                                Object var18_21 = null;
                                if (retain) break block30;
                                try {}
                                catch (Throwable throwable) {
                                    Object var22_40 = null;
                                    callContext.setCurrentOperation(Operation.REMOVE);
                                    throw throwable;
                                }
                                try {}
                                catch (Throwable callbackException) {
                                    String logMessage = "An unexpected exception occured while invoking the preDestroy method on the removed Stateful SessionBean instance; " + callbackException.getClass().getName() + " " + callbackException.getMessage();
                                    logger.error(logMessage);
                                    Object var22_39 = null;
                                    callContext.setCurrentOperation(Operation.REMOVE);
                                    break block28;
                                }
                                callContext.setCurrentOperation(Operation.PRE_DESTROY);
                                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                                interceptorStack.invoke(new Object[0]);
                                Object var22_38 = null;
                                callContext.setCurrentOperation(Operation.REMOVE);
                            }
                            this.discardInstance(callContext);
                        }
                        this.afterInvoke(callContext, txPolicy, instance);
                    }
                }
                Object var18_20 = null;
                if (!retain) {
                    block26: {
                        try {
                            try {
                                callContext.setCurrentOperation(Operation.PRE_DESTROY);
                                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                                interceptorStack.invoke(new Object[0]);
                            }
                            catch (Throwable callbackException) {
                                String logMessage = "An unexpected exception occured while invoking the preDestroy method on the removed Stateful SessionBean instance; " + callbackException.getClass().getName() + " " + callbackException.getMessage();
                                logger.error(logMessage);
                                Object var22_36 = null;
                                callContext.setCurrentOperation(Operation.REMOVE);
                                break block26;
                            }
                            Object var22_35 = null;
                            callContext.setCurrentOperation(Operation.REMOVE);
                        }
                        catch (Throwable throwable) {
                            Object var22_37 = null;
                            callContext.setCurrentOperation(Operation.REMOVE);
                            throw throwable;
                        }
                    }
                    this.discardInstance(callContext);
                }
                this.afterInvoke(callContext, txPolicy, instance);
            }
            catch (Throwable throwable) {
                block31: {
                    block29: {
                        Object var18_22 = null;
                        if (retain) break block31;
                        try {}
                        catch (Throwable throwable2) {
                            Object var22_43 = null;
                            callContext.setCurrentOperation(Operation.REMOVE);
                            throw throwable2;
                        }
                        try {}
                        catch (Throwable callbackException) {
                            String logMessage = "An unexpected exception occured while invoking the preDestroy method on the removed Stateful SessionBean instance; " + callbackException.getClass().getName() + " " + callbackException.getMessage();
                            logger.error(logMessage);
                            Object var22_42 = null;
                            callContext.setCurrentOperation(Operation.REMOVE);
                            break block29;
                        }
                        callContext.setCurrentOperation(Operation.PRE_DESTROY);
                        List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, null, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                        interceptorStack.invoke(new Object[0]);
                        Object var22_41 = null;
                        callContext.setCurrentOperation(Operation.REMOVE);
                    }
                    this.discardInstance(callContext);
                }
                this.afterInvoke(callContext, txPolicy, instance);
                throw throwable;
            }
            object = returnValue;
            Object var24_48 = null;
        }
        catch (Throwable throwable) {
            Object var24_49 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object businessMethod(CoreDeploymentInfo deploymentInfo, Object primKey, Class callInterface, Method callMethod, Object[] args, InterfaceType interfaceType) throws OpenEJBException {
        Object object;
        ThreadContext callContext = new ThreadContext(deploymentInfo, primKey);
        ThreadContext oldCallContext = ThreadContext.enter(callContext);
        try {
            Object returnValue;
            block7: {
                this.checkAuthorization(callMethod, interfaceType);
                TransactionPolicy txPolicy = EjbTransactionUtil.createTransactionPolicy(callContext.getDeploymentInfo().getTransactionType(callMethod), callContext);
                returnValue = null;
                Instance instance = null;
                try {
                    try {
                        BeanTransactionPolicy.SuspendedTransaction suspendedTransaction;
                        instance = this.obtainInstance(primKey, callContext);
                        if (txPolicy instanceof BeanTransactionPolicy && (suspendedTransaction = instance.getBeanTransaction()) != null) {
                            instance.setBeanTransaction(null);
                            BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
                            beanTxEnv.resumeUserTransaction(suspendedTransaction);
                        }
                        this.registerEntityManagers(instance, callContext);
                        this.registerSessionSynchronization(instance, callContext);
                        callContext.setCurrentOperation(Operation.BUSINESS);
                        callContext.setCurrentAllowedStates(StatefulContext.getStates());
                        callContext.setInvokedInterface(callInterface);
                        Method runMethod = deploymentInfo.getMatchingBeanMethod(callMethod);
                        callContext.set(Method.class, runMethod);
                        List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(runMethod);
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, runMethod, Operation.BUSINESS, interceptors, instance.interceptors);
                        returnValue = interceptorStack.invoke(args);
                    }
                    catch (Throwable e) {
                        this.handleException(callContext, txPolicy, e);
                        Object var16_17 = null;
                        this.afterInvoke(callContext, txPolicy, instance);
                        break block7;
                    }
                    Object var16_16 = null;
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    this.afterInvoke(callContext, txPolicy, instance);
                    throw throwable;
                }
                this.afterInvoke(callContext, txPolicy, instance);
            }
            object = returnValue;
            Object var18_20 = null;
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            ThreadContext.exit(oldCallContext);
            throw throwable;
        }
        ThreadContext.exit(oldCallContext);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instance newInstance(Object primaryKey, Class beanClass, Map<EntityManagerFactory, EntityManager> entityManagers) throws OpenEJBException {
        Instance instance = null;
        ThreadContext threadContext = ThreadContext.getThreadContext();
        Operation currentOperation = threadContext.getCurrentOperation();
        try {
            try {
                Class clazz;
                SessionContext sessionContext;
                ThreadContext callContext = ThreadContext.getThreadContext();
                CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
                Context ctx = deploymentInfo.getJndiEnc();
                StatefulContainer statefulContainer = this;
                synchronized (statefulContainer) {
                    try {
                        sessionContext = (SessionContext)ctx.lookup("java:comp/EJBContext");
                    }
                    catch (NamingException e1) {
                        StatefulUserTransaction userTransaction = new StatefulUserTransaction(new EjbUserTransaction(), this.entityManagerRegistry);
                        sessionContext = new StatefulContext(this.securityService, userTransaction);
                        ctx.bind("java:comp/EJBContext", (Object)sessionContext);
                    }
                }
                InjectionProcessor injectionProcessor = new InjectionProcessor(beanClass, deploymentInfo.getInjections(), null, null, InjectionProcessor.unwrap(ctx));
                try {
                    if (SessionBean.class.isAssignableFrom(beanClass) || beanClass.getMethod("setSessionContext", SessionContext.class) != null) {
                        callContext.setCurrentOperation(Operation.INJECTION);
                        injectionProcessor.setProperty("sessionContext", sessionContext);
                    }
                }
                catch (NoSuchMethodException ignored) {
                    // empty catch block
                }
                Object bean = injectionProcessor.createInstance();
                HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
                for (InterceptorInstance interceptorInstance : deploymentInfo.getSystemInterceptors()) {
                    clazz = interceptorInstance.getData().getInterceptorClass();
                    interceptorInstances.put(clazz.getName(), interceptorInstance.getInterceptor());
                }
                for (InterceptorData interceptorData : deploymentInfo.getInstanceScopedInterceptors()) {
                    if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                    clazz = interceptorData.getInterceptorClass();
                    InjectionProcessor interceptorInjector = new InjectionProcessor(clazz, deploymentInfo.getInjections(), InjectionProcessor.unwrap(ctx));
                    try {
                        Object interceptorInstance = interceptorInjector.createInstance();
                        interceptorInstances.put(clazz.getName(), interceptorInstance);
                    }
                    catch (ConstructionException e) {
                        throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                    }
                }
                interceptorInstances.put(beanClass.getName(), bean);
                callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(bean, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
                interceptorStack.invoke(new Object[0]);
                instance = new Instance(deploymentInfo, primaryKey, bean, interceptorInstances, entityManagers);
            }
            catch (Throwable callbackException) {
                this.discardInstance(threadContext);
                EjbTransactionUtil.handleSystemException(threadContext.getTransactionPolicy(), callbackException, threadContext);
                Object var20_25 = null;
                threadContext.setCurrentOperation(currentOperation);
            }
            Object var20_24 = null;
            threadContext.setCurrentOperation(currentOperation);
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            threadContext.setCurrentOperation(currentOperation);
            throw throwable;
        }
        this.cache.add(primaryKey, instance);
        this.checkedOutInstances.put(primaryKey, instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instance obtainInstance(Object primaryKey, ThreadContext callContext) throws OpenEJBException {
        if (primaryKey == null) {
            throw new SystemException(new NullPointerException("Cannot obtain an instance of the stateful session bean with a null session id"));
        }
        Transaction currentTransaction = this.getTransaction(callContext);
        Instance instance = this.checkedOutInstances.get(primaryKey);
        if (instance == null) {
            try {
                instance = this.cache.checkOut(primaryKey);
            }
            catch (OpenEJBException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SystemException("Unexpected load exception", e);
            }
            if (instance == null) {
                throw new InvalidateReferenceException(new NoSuchObjectException("Not Found"));
            }
            this.checkedOutInstances.put(primaryKey, instance);
        }
        Instance instance2 = instance;
        synchronized (instance2) {
            Operation currentOperation;
            if (instance.isInUse() && (currentOperation = callContext.getCurrentOperation()) != Operation.AFTER_COMPLETION && currentOperation != Operation.BEFORE_COMPLETION) {
                throw new ApplicationException(new RemoteException("Concurrent calls not allowed."));
            }
            if (instance.getTransaction() != null) {
                if (!instance.getTransaction().equals(currentTransaction) && !instance.getLock().tryLock()) {
                    throw new ApplicationException(new RemoteException("Instance is in a transaction and cannot be invoked outside that transaction.  See EJB 3.0 Section 4.4.4"));
                }
            } else {
                instance.setTransaction(currentTransaction);
            }
            instance.setInUse(true);
            return instance;
        }
    }

    private Transaction getTransaction(ThreadContext callContext) {
        TransactionPolicy policy = callContext.getTransactionPolicy();
        Transaction currentTransaction = null;
        if (policy instanceof JtaTransactionPolicy) {
            JtaTransactionPolicy jtaPolicy = (JtaTransactionPolicy)policy;
            currentTransaction = jtaPolicy.getCurrentTransaction();
        }
        return currentTransaction;
    }

    private void releaseInstance(Instance instance) {
        if (instance.deploymentInfo.isDestroyed()) {
            return;
        }
        if (instance.getBeanTransaction() != null) {
            new IllegalStateException("Instance has an active bean-managed transaction");
        }
        instance.setInUse(false);
        if (instance.getTransaction() == null) {
            this.cache.checkIn(instance.primaryKey);
            this.checkedOutInstances.remove(instance.primaryKey);
        }
    }

    private void discardInstance(ThreadContext threadContext) {
        Object primaryKey = threadContext.getPrimaryKey();
        if (primaryKey == null) {
            return;
        }
        this.checkedOutInstances.remove(primaryKey);
        this.cache.remove(primaryKey);
    }

    private void checkAuthorization(Method callMethod, InterfaceType interfaceType) throws ApplicationException {
        boolean authorized = this.securityService.isCallerAuthorized(callMethod, interfaceType);
        if (!authorized) {
            throw new ApplicationException((Exception)new EJBAccessException("Unauthorized Access by Principal Denied"));
        }
    }

    private void handleException(ThreadContext callContext, TransactionPolicy txPolicy, Throwable e) throws ApplicationException {
        if (e instanceof ApplicationException) {
            throw (ApplicationException)e;
        }
        ExceptionType type = callContext.getDeploymentInfo().getExceptionType(e);
        if (type == ExceptionType.SYSTEM) {
            this.discardInstance(callContext);
            EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
        } else {
            EjbTransactionUtil.handleApplicationException(txPolicy, e, type == ExceptionType.APPLICATION_ROLLBACK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInvoke(ThreadContext callContext, TransactionPolicy txPolicy, Instance instance) throws OpenEJBException {
        try {
            this.unregisterEntityManagers(instance, callContext);
            if (instance != null && txPolicy instanceof BeanTransactionPolicy) {
                BeanTransactionPolicy.SuspendedTransaction suspendedTransaction = null;
                try {
                    try {
                        BeanTransactionPolicy beanTxEnv = (BeanTransactionPolicy)txPolicy;
                        suspendedTransaction = beanTxEnv.suspendUserTransaction();
                    }
                    catch (SystemException e) {
                        EjbTransactionUtil.handleSystemException(txPolicy, e, callContext);
                        Object var7_8 = null;
                        instance.setBeanTransaction(suspendedTransaction);
                    }
                    Object var7_7 = null;
                    instance.setBeanTransaction(suspendedTransaction);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    instance.setBeanTransaction(suspendedTransaction);
                    throw throwable;
                }
            }
            Object var9_11 = null;
            if (instance != null) {
                instance.setInUse(false);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (instance != null) {
                instance.setInUse(false);
            }
            EjbTransactionUtil.afterInvoke(txPolicy, callContext);
            throw throwable;
        }
        EjbTransactionUtil.afterInvoke(txPolicy, callContext);
    }

    private Index<EntityManagerFactory, EntityManager> createEntityManagers(CoreDeploymentInfo deploymentInfo) {
        Index<EntityManagerFactory, Map> factories = deploymentInfo.getExtendedEntityManagerFactories();
        Index<EntityManagerFactory, EntityManager> entityManagers = null;
        if (factories != null && factories.size() > 0) {
            entityManagers = new Index<EntityManagerFactory, EntityManager>(new ArrayList(factories.keySet()));
            for (Map.Entry<EntityManagerFactory, Map> entry : factories.entrySet()) {
                EntityManagerFactory entityManagerFactory = entry.getKey();
                Map properties = entry.getValue();
                EntityManager entityManager = this.entityManagerRegistry.getInheritedEntityManager(entityManagerFactory);
                if (entityManager == null) {
                    entityManager = properties != null ? entityManagerFactory.createEntityManager(properties) : entityManagerFactory.createEntityManager();
                }
                entityManagers.put(entityManagerFactory, entityManager);
            }
        }
        return entityManagers;
    }

    private void registerEntityManagers(Instance instance, ThreadContext callContext) throws OpenEJBException {
        if (this.entityManagerRegistry == null) {
            return;
        }
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        Index<EntityManagerFactory, Map> factories = deploymentInfo.getExtendedEntityManagerFactories();
        if (factories == null) {
            return;
        }
        Map<EntityManagerFactory, EntityManager> entityManagers = instance.getEntityManagers(factories);
        if (entityManagers == null) {
            return;
        }
        try {
            this.entityManagerRegistry.addEntityManagers((String)deploymentInfo.getDeploymentID(), instance.primaryKey, entityManagers);
        }
        catch (EntityManagerAlreadyRegisteredException e) {
            throw new EJBException((Exception)e);
        }
    }

    private void unregisterEntityManagers(Instance instance, ThreadContext callContext) {
        if (this.entityManagerRegistry == null) {
            return;
        }
        if (instance == null) {
            return;
        }
        CoreDeploymentInfo deploymentInfo = callContext.getDeploymentInfo();
        this.entityManagerRegistry.removeEntityManagers((String)deploymentInfo.getDeploymentID(), instance.primaryKey);
    }

    private void registerSessionSynchronization(Instance instance, ThreadContext callContext) {
        TransactionPolicy txPolicy = callContext.getTransactionPolicy();
        if (txPolicy == null) {
            throw new IllegalStateException("ThreadContext does not contain a TransactionEnvironment");
        }
        SessionSynchronizationCoordinator coordinator = (SessionSynchronizationCoordinator)txPolicy.getResource(SessionSynchronizationCoordinator.class);
        if (coordinator == null) {
            coordinator = new SessionSynchronizationCoordinator(txPolicy);
            txPolicy.registerSynchronization(coordinator);
            txPolicy.putResource(SessionSynchronizationCoordinator.class, coordinator);
        }
        boolean synchronize = callContext.getCurrentOperation() != Operation.CREATE && callContext.getDeploymentInfo().isSessionSynchronized() && txPolicy.isTransactionActive();
        coordinator.registerSessionSynchronization(instance, callContext.getDeploymentInfo(), callContext.getPrimaryKey(), synchronize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Data {
        private final Index<Method, MethodType> methodIndex;
        private final List<ObjectName> jmxNames = new ArrayList<ObjectName>();

        private Data(Index<Method, MethodType> methodIndex) {
            this.methodIndex = methodIndex;
        }

        public Index<Method, MethodType> getMethodIndex() {
            return this.methodIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StatefulCacheListener
    implements Cache.CacheListener<Instance> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterLoad(Instance instance) throws SystemException, ApplicationException {
            CoreDeploymentInfo deploymentInfo = instance.deploymentInfo;
            ThreadContext threadContext = new ThreadContext(instance.deploymentInfo, instance.primaryKey, Operation.ACTIVATE);
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method remove = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbActivate", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.ACTIVATE, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable callbackException) {
                StatefulContainer.this.discardInstance(threadContext);
                EjbTransactionUtil.handleSystemException(threadContext.getTransactionPolicy(), callbackException, threadContext);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beforeStore(Instance instance) {
            CoreDeploymentInfo deploymentInfo = instance.deploymentInfo;
            ThreadContext threadContext = new ThreadContext(deploymentInfo, instance.primaryKey, Operation.PASSIVATE);
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method passivate = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbPassivate", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, passivate, Operation.PASSIVATE, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable e) {
                logger.error("An unexpected exception occured while invoking the ejbPassivate method on the Stateful SessionBean instance", e);
            }
            finally {
                ThreadContext.exit(oldContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timedOut(Instance instance) {
            CoreDeploymentInfo deploymentInfo = instance.deploymentInfo;
            ThreadContext threadContext = new ThreadContext(deploymentInfo, instance.primaryKey, Operation.PRE_DESTROY);
            threadContext.setCurrentAllowedStates(StatefulContext.getStates());
            ThreadContext oldContext = ThreadContext.enter(threadContext);
            try {
                Method remove = instance.bean instanceof SessionBean ? SessionBean.class.getMethod("ejbRemove", new Class[0]) : null;
                List<InterceptorData> callbackInterceptors = deploymentInfo.getCallbackInterceptors();
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, remove, Operation.PRE_DESTROY, callbackInterceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Throwable e) {
                logger.error("An unexpected exception occured while invoking the ejbRemove method on the timed-out Stateful SessionBean instance", e);
            }
            finally {
                logger.info("Removing the timed-out stateful session bean instance " + instance.primaryKey);
                ThreadContext.exit(oldContext);
            }
        }
    }

    private class SessionSynchronizationCoordinator
    implements TransactionPolicy.TransactionSynchronization {
        private final Map<Object, Synchronization> registry = new HashMap<Object, Synchronization>();
        private final TransactionPolicy txPolicy;

        private SessionSynchronizationCoordinator(TransactionPolicy txPolicy) {
            this.txPolicy = txPolicy;
        }

        private void registerSessionSynchronization(Instance instance, CoreDeploymentInfo deploymentInfo, Object primaryKey, boolean synchronize) {
            boolean wasSynchronized;
            Synchronization synchronization = this.registry.get(primaryKey);
            if (synchronization == null) {
                synchronization = new Synchronization(instance);
                this.registry.put(primaryKey, synchronization);
            }
            if ((wasSynchronized = synchronization.setCallSessionSynchronization(synchronize)) || !synchronize) {
                return;
            }
            ThreadContext callContext = new ThreadContext(instance.deploymentInfo, instance.primaryKey, Operation.AFTER_BEGIN);
            callContext.setCurrentAllowedStates(StatefulContext.getStates());
            ThreadContext oldCallContext = ThreadContext.enter(callContext);
            try {
                Method afterBegin = SessionSynchronization.class.getMethod("afterBegin", new Class[0]);
                List<InterceptorData> interceptors = deploymentInfo.getMethodInterceptors(afterBegin);
                InterceptorStack interceptorStack = new InterceptorStack(instance.bean, afterBegin, Operation.AFTER_BEGIN, interceptors, instance.interceptors);
                interceptorStack.invoke(new Object[0]);
            }
            catch (Exception e) {
                String message = "An unexpected system exception occured while invoking the afterBegin method on the SessionSynchronization object";
                logger.error(message, e);
                throw new RuntimeException(message, e);
            }
            finally {
                ThreadContext.exit(oldCallContext);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void beforeCompletion() {
            Iterator<Synchronization> i$ = this.registry.values().iterator();
            while (i$.hasNext()) {
                Synchronization synchronization = i$.next();
                Instance instance = synchronization.instance;
                if (this.txPolicy.isRollbackOnly()) {
                    return;
                }
                if (!synchronization.isCallSessionSynchronization()) continue;
                ThreadContext callContext = new ThreadContext(instance.deploymentInfo, instance.primaryKey, Operation.BEFORE_COMPLETION);
                callContext.setCurrentAllowedStates(StatefulContext.getStates());
                ThreadContext oldCallContext = ThreadContext.enter(callContext);
                try {
                    instance.setInUse(true);
                    Method beforeCompletion = SessionSynchronization.class.getMethod("beforeCompletion", new Class[0]);
                    List<InterceptorData> interceptors = instance.deploymentInfo.getMethodInterceptors(beforeCompletion);
                    InterceptorStack interceptorStack = new InterceptorStack(instance.bean, beforeCompletion, Operation.BEFORE_COMPLETION, interceptors, instance.interceptors);
                    interceptorStack.invoke(new Object[0]);
                    instance.setInUse(false);
                    continue;
                }
                catch (InvalidateReferenceException e) {
                    continue;
                }
                catch (Exception e) {
                    String message = "An unexpected system exception occured while invoking the beforeCompletion method on the SessionSynchronization object";
                    logger.error(message, e);
                    this.txPolicy.setRollbackOnly();
                    StatefulContainer.this.discardInstance(callContext);
                    throw new RuntimeException(message, e);
                }
                finally {
                    ThreadContext.exit(oldCallContext);
                    continue;
                }
                break;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterCompletion(TransactionPolicy.TransactionSynchronization.Status status) {
            Throwable firstException = null;
            for (Synchronization synchronization : this.registry.values()) {
                Instance instance = synchronization.instance;
                ThreadContext callContext = new ThreadContext(instance.deploymentInfo, instance.primaryKey, Operation.AFTER_COMPLETION);
                callContext.setCurrentAllowedStates(StatefulContext.getStates());
                ThreadContext oldCallContext = ThreadContext.enter(callContext);
                try {
                    instance.setInUse(true);
                    if (synchronization.isCallSessionSynchronization()) {
                        Method afterCompletion = SessionSynchronization.class.getMethod("afterCompletion", Boolean.TYPE);
                        List<InterceptorData> interceptors = instance.deploymentInfo.getMethodInterceptors(afterCompletion);
                        InterceptorStack interceptorStack = new InterceptorStack(instance.bean, afterCompletion, Operation.AFTER_COMPLETION, interceptors, instance.interceptors);
                        interceptorStack.invoke(status == TransactionPolicy.TransactionSynchronization.Status.COMMITTED);
                    }
                    instance.setTransaction(null);
                    StatefulContainer.this.releaseInstance(instance);
                }
                catch (InvalidateReferenceException inv) {
                }
                catch (Throwable e) {
                    String message = "An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object";
                    logger.error(message, e);
                    StatefulContainer.this.discardInstance(callContext);
                    if (firstException != null) continue;
                    firstException = e;
                }
                finally {
                    ThreadContext.exit(oldCallContext);
                }
            }
            if (firstException != null) {
                throw new RuntimeException("An unexpected system exception occured while invoking the afterCompletion method on the SessionSynchronization object", firstException);
            }
        }

        public class Synchronization {
            private final Instance instance;
            private boolean callSessionSynchronization;

            public Synchronization(Instance instance) {
                this.instance = instance;
            }

            public synchronized boolean isCallSessionSynchronization() {
                return this.callSessionSynchronization;
            }

            public synchronized boolean setCallSessionSynchronization(boolean synchronize) {
                boolean oldValue = this.callSessionSynchronization;
                this.callSessionSynchronization = synchronize;
                return oldValue;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        CREATE,
        REMOVE,
        BUSINESS;

    }
}

