/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.ejb.RemoveException;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.stateful.StatefulEjbObjectHandler;
import org.apache.openejb.util.proxy.ProxyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulEjbHomeHandler
extends EjbHomeProxyHandler {
    public StatefulEjbHomeHandler(DeploymentInfo deploymentInfo, InterfaceType interfaceType, List<Class> interfaces) {
        super(deploymentInfo, interfaceType, interfaces);
    }

    @Override
    public Object createProxy(Object primaryKey) {
        Object proxy = super.createProxy(primaryKey);
        EjbObjectProxyHandler handler = null;
        try {
            handler = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(proxy);
        }
        catch (Exception e) {
            try {
                Field field = proxy.getClass().getDeclaredField("invocationHandler");
                field.setAccessible(true);
                handler = (EjbObjectProxyHandler)field.get(proxy);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        this.registerHandler(handler.getRegistryId(), handler);
        return proxy;
    }

    @Override
    protected Object findX(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        throw new UnsupportedOperationException("Stateful beans may not have find methods");
    }

    @Override
    protected Object removeByPrimaryKey(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoveException("Session objects are private resources and do not have primary keys");
    }

    @Override
    protected EjbObjectProxyHandler newEjbObjectHandler(DeploymentInfo deploymentInfo, Object pk, InterfaceType interfaceType, List<Class> interfaces) {
        return new StatefulEjbObjectHandler(this.getDeploymentInfo(), pk, interfaceType, interfaces);
    }
}

