/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.ScheduleExpression;
import org.quartz.Calendar;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Trigger;

public class EJBCronTrigger
extends Trigger {
    private static final Pattern INCREMENTS = Pattern.compile("(\\d+|\\*)/(\\d+)*");
    private static final Pattern LIST = Pattern.compile("\\p{Alnum}+(?:,\\p{Alnum}+)*");
    private static final Pattern RANGE = Pattern.compile("(\\p{Alnum}+)-(\\p{Alnum}+)");
    private static final Pattern WEEKDAY = Pattern.compile("(1ST|2ND|3RD|4TH|5TH|LAST)(\\p{Alpha}+)");
    private static final Pattern DAYS_TO_LAST = Pattern.compile("-([1-7])");
    private final List<FieldExpression> expressions = new ArrayList<FieldExpression>(7);
    private Date startTime;
    private Date endTime;
    private Date nextFireTime;
    private Date previousFireTime;

    public EJBCronTrigger(ScheduleExpression expr) throws ParseException {
        TreeMap<Integer, String> fieldValues = new TreeMap<Integer, String>();
        fieldValues.put(1, expr.getYear());
        fieldValues.put(2, expr.getMonth());
        fieldValues.put(7, expr.getDayOfWeek());
        fieldValues.put(5, expr.getDayOfMonth());
        fieldValues.put(11, expr.getHour());
        fieldValues.put(12, expr.getMinute());
        fieldValues.put(13, expr.getSecond());
        HashMap<Integer, ParseException> errors = new HashMap<Integer, ParseException>();
        for (Map.Entry entry : fieldValues.entrySet()) {
            int field = (Integer)entry.getKey();
            String value = (String)entry.getValue();
            try {
                FieldExpression fieldExpr = this.parseExpression(field, value);
                if (fieldExpr == null) continue;
                this.expressions.add(fieldExpr);
            }
            catch (ParseException e) {
                errors.put(field, e);
            }
        }
        if (!errors.isEmpty()) {
            throw new ParseException(errors);
        }
    }

    protected FieldExpression parseExpression(int field, String expr) throws ParseException {
        if ((expr = expr.replaceAll("\\s+", "").toUpperCase()).equals("*")) {
            return null;
        }
        Matcher m = RANGE.matcher(expr);
        if (m.matches()) {
            return new RangeExpression(m, field);
        }
        switch (field) {
            case 11: 
            case 12: 
            case 13: {
                m = INCREMENTS.matcher(expr);
                if (!m.matches()) break;
                return new IncrementExpression(m, field);
            }
            case 5: {
                if (expr.equals("LAST")) {
                    return new DaysFromLastDayExpression();
                }
                m = DAYS_TO_LAST.matcher(expr);
                if (m.matches()) {
                    return new DaysFromLastDayExpression(m);
                }
                m = WEEKDAY.matcher(expr);
                if (!m.matches()) break;
                return new WeekdayExpression(m);
            }
        }
        m = LIST.matcher(expr);
        if (m.matches()) {
            return new ListExpression(m, field);
        }
        throw new ParseException(field, expr, "Unparseable time expression");
    }

    public Date computeFirstFireTime(Calendar calendar) {
        this.nextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
        return this.nextFireTime;
    }

    public int executionComplete(JobExecutionContext context, JobExecutionException result) {
        if (result != null && result.refireImmediately()) {
            return 1;
        }
        if (result != null && result.unscheduleFiringTrigger()) {
            return 2;
        }
        if (result != null && result.unscheduleAllTriggers()) {
            return 4;
        }
        if (!this.mayFireAgain()) {
            return 3;
        }
        return 0;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getFinalFireTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setLenient(false);
        calendar.setFirstDayOfWeek(1);
        if (this.endTime == null) {
            if (this.expressions.get((int)0).field != 1) {
                return null;
            }
            this.resetFields(calendar, 0, true);
            calendar.set(14, 0);
        } else {
            calendar.setTime(this.endTime);
        }
        GregorianCalendar stopCalendar = new GregorianCalendar();
        if (this.startTime != null) {
            stopCalendar.setTime(this.startTime);
        } else {
            stopCalendar.setTimeInMillis(0L);
        }
        ListIterator<FieldExpression> fieldIterator = this.expressions.listIterator();
        while (fieldIterator.hasNext() && calendar.after(stopCalendar)) {
            FieldExpression expr = fieldIterator.next();
            Integer value = expr.getPreviousValue(calendar);
            if (value != null) {
                int oldValue = calendar.get(expr.field);
                if (oldValue == value) continue;
                calendar.set(expr.field, value);
                this.resetFields(calendar, expr.field, true);
                if (expr.field != 7) continue;
                fieldIterator.previous();
                fieldIterator.previous();
                continue;
            }
            if (fieldIterator.previousIndex() >= 1) {
                fieldIterator.previous();
                expr = fieldIterator.previous();
                ((java.util.Calendar)calendar).add(expr.field, -1);
                continue;
            }
            return null;
        }
        return calendar.after(stopCalendar) ? calendar.getTime() : null;
    }

    public Date getFireTimeAfter(Date afterTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setLenient(false);
        calendar.setFirstDayOfWeek(1);
        if (this.startTime != null && this.startTime.after(afterTime)) {
            calendar.setTime(this.startTime);
        } else {
            calendar.setTime(afterTime);
            ((java.util.Calendar)calendar).add(13, 1);
        }
        GregorianCalendar stopCalendar = new GregorianCalendar();
        if (this.endTime != null) {
            stopCalendar.setTime(this.endTime);
        } else {
            int stopYear = calendar.get(1) + 100;
            stopCalendar.set(1, stopYear);
        }
        ListIterator<FieldExpression> fieldIterator = this.expressions.listIterator();
        while (fieldIterator.hasNext() && calendar.before(stopCalendar)) {
            FieldExpression expr = fieldIterator.next();
            Integer value = expr.getNextValue(calendar);
            if (value != null) {
                int oldValue = calendar.get(expr.field);
                if (oldValue == value) continue;
                calendar.set(expr.field, value);
                this.resetFields(calendar, expr.field, false);
                if (expr.field != 7) continue;
                fieldIterator.previous();
                fieldIterator.previous();
                continue;
            }
            if (fieldIterator.previousIndex() >= 1) {
                fieldIterator.previous();
                expr = fieldIterator.previous();
                ((java.util.Calendar)calendar).add(expr.field, 1);
                continue;
            }
            return null;
        }
        return calendar.before(stopCalendar) ? calendar.getTime() : null;
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    private void resetFields(java.util.Calendar calendar, int currentField, boolean max) {
        int[] fields;
        for (int field : fields = new int[]{1, 2, 5, 11, 12, 13}) {
            if (field <= currentField) continue;
            int value = max ? calendar.getActualMaximum(field) : calendar.getActualMinimum(field);
            calendar.set(field, value);
        }
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void triggered(Calendar calendar) {
        this.previousFireTime = this.nextFireTime;
        while (this.nextFireTime != null && calendar != null && !calendar.isTimeIncluded(this.nextFireTime.getTime())) {
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    public void updateAfterMisfire(Calendar cal) {
        if (this.isVolatile()) {
            Date newFireTime = this.getFireTimeAfter(new Date());
            while (newFireTime != null && cal != null && !cal.isTimeIncluded(newFireTime.getTime())) {
                newFireTime = this.getFireTimeAfter(newFireTime);
            }
            this.nextFireTime = newFireTime;
        } else {
            this.nextFireTime = new Date();
        }
    }

    public void updateWithNewCalendar(Calendar cal, long misfireThreshold) {
        if (cal == null) {
            return;
        }
        Date now = new Date();
        this.nextFireTime = this.getFireTimeAfter(this.previousFireTime);
        while (this.nextFireTime != null && !cal.isTimeIncluded(this.nextFireTime.getTime())) {
            long diff;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
            if (this.nextFireTime == null || !this.nextFireTime.before(now) || (diff = now.getTime() - this.nextFireTime.getTime()) < misfireThreshold) continue;
            this.nextFireTime = this.getFireTimeAfter(this.nextFireTime);
        }
    }

    protected boolean validateMisfireInstruction(int misfireInstruction) {
        return misfireInstruction == 0;
    }

    private static class DaysFromLastDayExpression
    extends FieldExpression {
        private final int days;

        public DaysFromLastDayExpression(Matcher m) {
            super(5);
            this.days = new Integer(m.group(1));
        }

        public DaysFromLastDayExpression() {
            super(5);
            this.days = 0;
        }

        public Integer getNextValue(java.util.Calendar calendar) {
            int maxValue;
            int value;
            int currValue = calendar.get(this.field);
            return currValue <= (value = (maxValue = calendar.getActualMaximum(this.field)) - this.days) ? Integer.valueOf(value) : null;
        }

        public Integer getPreviousValue(java.util.Calendar calendar) {
            int maxValue = calendar.getActualMaximum(this.field);
            return maxValue - this.days;
        }
    }

    private static class WeekdayExpression
    extends FieldExpression {
        private final Integer ordinal;
        private final int weekday;

        public WeekdayExpression(Matcher m) throws ParseException {
            super(5);
            Character firstChar = Character.valueOf(m.group(1).charAt(0));
            this.ordinal = Character.isDigit(firstChar.charValue()) ? new Integer(firstChar.charValue()) : null;
            this.weekday = WeekdayExpression.convertValue(m.group(2), 7);
        }

        public Integer getNextValue(java.util.Calendar calendar) {
            int currDay = calendar.get(5);
            Integer nthDay = this.getPreviousValue(calendar);
            return nthDay != null && nthDay >= currDay ? nthDay : null;
        }

        public Integer getPreviousValue(java.util.Calendar calendar) {
            int currDay = calendar.get(5);
            int currWeekday = calendar.get(7);
            int maxDay = calendar.getActualMaximum(5);
            int firstWeekday = currDay % 7 - (currWeekday - this.weekday);
            int numWeekdays = (maxDay - firstWeekday) / 7;
            int multiplier = this.ordinal != null ? this.ordinal : numWeekdays;
            int nthDay = firstWeekday + multiplier * 7;
            return nthDay <= maxDay ? Integer.valueOf(nthDay) : null;
        }
    }

    private static class IncrementExpression
    extends FieldExpression {
        private final int start;
        private final int interval;

        public IncrementExpression(Matcher m, int field) {
            super(field);
            int minValue = CALENDAR.getMinimum(field);
            this.start = m.group(1).equals("*") ? minValue : Integer.parseInt(m.group(1));
            this.interval = Integer.parseInt(m.group(2));
        }

        public Integer getNextValue(java.util.Calendar calendar) {
            int currValue = Math.max(calendar.get(this.field), this.start);
            int maxValue = calendar.getMaximum(this.field);
            if (currValue % this.interval > 0) {
                int nextValue = currValue + (this.interval - currValue % this.interval);
                return nextValue <= maxValue ? Integer.valueOf(nextValue) : null;
            }
            return currValue;
        }

        public Integer getPreviousValue(java.util.Calendar calendar) {
            int maxValue = calendar.getMaximum(this.field);
            int currValue = Math.min(calendar.get(this.field), maxValue);
            int nextValue = currValue - currValue % this.interval;
            return nextValue >= this.start ? Integer.valueOf(nextValue) : null;
        }
    }

    private static class ListExpression
    extends FieldExpression {
        private final List<Integer> values = new ArrayList<Integer>();

        public ListExpression(Matcher m, int field) throws ParseException {
            super(field);
            for (String num : m.group().split(",")) {
                this.values.add(this.convertValue(num));
            }
            Collections.sort(this.values);
        }

        public Integer getNextValue(java.util.Calendar calendar) {
            int currValue = calendar.get(this.field);
            for (Integer day : this.values) {
                if (day < currValue) continue;
                return day;
            }
            return null;
        }

        public Integer getPreviousValue(java.util.Calendar calendar) {
            int currValue = calendar.get(this.field);
            ListIterator<Integer> iterator = this.values.listIterator(this.values.size());
            while (iterator.hasPrevious()) {
                int day = iterator.previous();
                if (day > currValue) continue;
                return day;
            }
            return null;
        }
    }

    private static class RangeExpression
    extends FieldExpression {
        private final int start;
        private final int end;

        public RangeExpression(Matcher m, int field) throws ParseException {
            super(field);
            this.start = this.convertValue(m.group(1));
            this.end = this.convertValue(m.group(2));
            if (this.end < this.start) {
                throw new ParseException(field, m.group(), "End value must be higher than start value");
            }
        }

        public Integer getNextValue(java.util.Calendar calendar) {
            int currValue = calendar.get(this.field);
            int maxValue = calendar.getActualMaximum(this.field);
            return currValue <= this.end && currValue <= maxValue ? Integer.valueOf(Math.min(this.start, maxValue)) : null;
        }

        public Integer getPreviousValue(java.util.Calendar calendar) {
            int maxValue = calendar.getActualMaximum(this.field);
            return this.end <= maxValue ? Integer.valueOf(this.end) : null;
        }
    }

    private static abstract class FieldExpression {
        private static final Map<String, Integer> MONTHS_MAP = new HashMap<String, Integer>();
        private static final Map<String, Integer> WEEKDAYS_MAP = new HashMap<String, Integer>();
        protected static final java.util.Calendar CALENDAR = new GregorianCalendar(Locale.US);
        public final int field;

        protected static int convertValue(String value, int field) throws ParseException {
            if (Character.isDigit(value.charAt(0))) {
                int numValue;
                try {
                    numValue = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(field, value, "Unparseable value");
                }
                if (field == 7) {
                    if (++numValue == 8) {
                        numValue = 1;
                    }
                } else if (field == 2) {
                    --numValue;
                }
                if (numValue < CALENDAR.getMinimum(field) || numValue > CALENDAR.getMaximum(field)) {
                    throw new ParseException(field, value, "Value is out of range");
                }
                return numValue;
            }
            switch (field) {
                case 2: {
                    return MONTHS_MAP.get(value);
                }
                case 7: {
                    return WEEKDAYS_MAP.get(value);
                }
            }
            throw new ParseException(field, value, "Unparseable value");
        }

        protected FieldExpression(int field) {
            this.field = field;
        }

        protected int convertValue(String value) throws ParseException {
            return FieldExpression.convertValue(value, this.field);
        }

        public abstract Integer getNextValue(java.util.Calendar var1);

        public abstract Integer getPreviousValue(java.util.Calendar var1);

        static {
            int i = 1;
            for (String month : new DateFormatSymbols(Locale.US).getShortMonths()) {
                MONTHS_MAP.put(month.toUpperCase(Locale.US), i++);
            }
            i = 0;
            for (String weekday : new DateFormatSymbols(Locale.US).getShortWeekdays()) {
                WEEKDAYS_MAP.put(weekday.toUpperCase(Locale.US), i++);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseException
    extends Exception {
        private final Map<Integer, ParseException> children;
        private final Integer field;
        private final String value;
        private final String error;

        protected ParseException(int field, String value, String message) {
            this.children = null;
            this.field = field;
            this.value = value;
            this.error = message;
        }

        protected ParseException(Map<Integer, ParseException> children) {
            this.children = children;
            this.field = null;
            this.value = null;
            this.error = null;
        }

        public Map<Integer, ParseException> getChildren() {
            return this.children != null ? Collections.unmodifiableMap(this.children) : null;
        }

        public Integer getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getError() {
            return this.error;
        }
    }
}

