/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.io.Serializable;
import java.util.Date;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.timer.TimerData;
import org.apache.openejb.core.timer.TimerHandleImpl;

public class TimerImpl
implements Timer {
    private final TimerData timerData;

    public TimerImpl(TimerData timerData) {
        this.timerData = timerData;
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        this.timerData.cancel();
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        long now = System.currentTimeMillis();
        long then = this.timerData.getExpiration().getTime();
        return then - now;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return this.timerData.getExpiration();
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return (Serializable)this.timerData.getInfo();
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException {
        this.checkState();
        return new TimerHandleImpl(this.timerData.getId(), this.timerData.getDeploymentId());
    }

    private void checkState() throws IllegalStateException, NoSuchObjectLocalException {
        if (!BaseContext.isTimerMethodAllowed()) {
            throw new IllegalStateException("Timer method not permitted for current operation " + ThreadContext.getThreadContext().getCurrentOperation().name());
        }
        if (this.timerData.isCancelled()) {
            throw new NoSuchObjectLocalException("Timer has been cancelled");
        }
    }
}

