/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.JtaQuery;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaEntityManager
implements EntityManager {
    private static final Logger baseLogger = Logger.getInstance(LogCategory.OPENEJB.createChild("persistence"), JtaEntityManager.class);
    private final JtaEntityManagerRegistry registry;
    private final EntityManagerFactory entityManagerFactory;
    private final Map properties;
    private final boolean extended;
    private final String unitName;
    private final Logger logger;

    public JtaEntityManager(JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties) {
        this(null, registry, entityManagerFactory, properties, false);
    }

    public JtaEntityManager(String unitName, JtaEntityManagerRegistry registry, EntityManagerFactory entityManagerFactory, Map properties, boolean extended) {
        if (registry == null) {
            throw new NullPointerException("registry is null");
        }
        if (entityManagerFactory == null) {
            throw new NullPointerException("entityManagerFactory is null");
        }
        this.registry = registry;
        this.entityManagerFactory = entityManagerFactory;
        this.properties = properties;
        this.extended = extended;
        this.unitName = unitName;
        this.logger = unitName == null ? baseLogger : baseLogger.getChildLogger(unitName);
    }

    private EntityManager getEntityManager() {
        return this.registry.getEntityManager(this.entityManagerFactory, this.properties, this.extended);
    }

    private boolean isTransactionActive() {
        return this.registry.isTransactionActive();
    }

    private void assertTransactionActive() throws TransactionRequiredException {
        if (!this.extended && !this.isTransactionActive()) {
            throw new TransactionRequiredException();
        }
    }

    private void closeIfNoTx(EntityManager entityManager) {
        if (!this.extended && !this.isTransactionActive()) {
            entityManager.close();
        }
    }

    public EntityManager getDelegate() {
        return this.getEntityManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.persist.start(this);
        try {
            this.getEntityManager().persist(entity);
            Object var4_3 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        Object object;
        this.assertTransactionActive();
        Timer timer = Op.merge.start(this);
        try {
            object = this.getEntityManager().merge(entity);
            Object var5_4 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            timer.stop();
            throw throwable;
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.remove.start(this);
        try {
            this.getEntityManager().remove(entity);
            Object var4_3 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.find.start(this);
            try {
                object = entityManager.find(entityClass, primaryKey);
                Object var7_6 = null;
                timer.stop();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                timer.stop();
                throw throwable;
            }
            Object var9_8 = null;
            this.closeIfNoTx(entityManager);
            return (T)object;
        }
        catch (Throwable throwable2) {
            Object var9_9 = null;
            this.closeIfNoTx(entityManager);
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Object object;
            Timer timer = Op.getReference.start(this);
            try {
                object = entityManager.getReference(entityClass, primaryKey);
                Object var7_6 = null;
                timer.stop();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                timer.stop();
                throw throwable;
            }
            Object var9_8 = null;
            this.closeIfNoTx(entityManager);
            return (T)object;
        }
        catch (Throwable throwable2) {
            Object var9_9 = null;
            this.closeIfNoTx(entityManager);
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.assertTransactionActive();
        Timer timer = Op.flush.start(this);
        try {
            this.getEntityManager().flush();
            Object var3_2 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        EntityManager entityManager = this.getEntityManager();
        try {
            Timer timer = Op.setFlushMode.start(this);
            try {
                entityManager.setFlushMode(flushMode);
                Object var5_4 = null;
                timer.stop();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                timer.stop();
                throw throwable;
            }
            Object var7_7 = null;
            this.closeIfNoTx(entityManager);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.closeIfNoTx(entityManager);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlushModeType getFlushMode() {
        EntityManager entityManager = this.getEntityManager();
        try {
            FlushModeType flushModeType;
            Timer timer = Op.getFlushMode.start(this);
            try {
                flushModeType = entityManager.getFlushMode();
                Object var5_4 = null;
                timer.stop();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                timer.stop();
                throw throwable;
            }
            Object var7_6 = null;
            this.closeIfNoTx(entityManager);
            return flushModeType;
        }
        catch (Throwable throwable2) {
            Object var7_7 = null;
            this.closeIfNoTx(entityManager);
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        this.assertTransactionActive();
        Timer timer = Op.lock.start(this);
        try {
            this.getEntityManager().lock(entity, lockMode);
            Object var5_4 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.assertTransactionActive();
        Timer timer = Op.refresh.start(this);
        try {
            this.getEntityManager().refresh(entity);
            Object var4_3 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (!this.extended && !this.isTransactionActive()) {
            return;
        }
        Timer timer = Op.clear.start(this);
        try {
            this.getEntityManager().clear();
            Object var3_2 = null;
            timer.stop();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        Timer timer = Op.contains.start(this);
        try {
            boolean bl = this.isTransactionActive() && this.getEntityManager().contains(entity);
            Object var5_4 = null;
            timer.stop();
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String qlString) {
        Timer timer = Op.createQuery.start(this);
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = entityManager.createQuery(qlString);
            Query query2 = this.proxyIfNoTx(entityManager, query);
            Object var7_6 = null;
            timer.stop();
            return query2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        Timer timer = Op.createNamedQuery.start(this);
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = entityManager.createNamedQuery(name);
            Query query2 = this.proxyIfNoTx(entityManager, query);
            Object var7_6 = null;
            timer.stop();
            return query2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = entityManager.createNativeQuery(sqlString);
            Query query2 = this.proxyIfNoTx(entityManager, query);
            Object var7_6 = null;
            timer.stop();
            return query2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = entityManager.createNativeQuery(sqlString, resultClass);
            Query query2 = this.proxyIfNoTx(entityManager, query);
            Object var8_7 = null;
            timer.stop();
            return query2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            timer.stop();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Timer timer = Op.createNativeQuery.start(this);
        try {
            EntityManager entityManager = this.getEntityManager();
            Query query = entityManager.createNativeQuery(sqlString, resultSetMapping);
            Query query2 = this.proxyIfNoTx(entityManager, query);
            Object var8_7 = null;
            timer.stop();
            return query2;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            timer.stop();
            throw throwable;
        }
    }

    private Query proxyIfNoTx(EntityManager entityManager, Query query) {
        if (!this.extended && !this.isTransactionActive()) {
            return new JtaQuery(entityManager, query);
        }
        return query;
    }

    public void joinTransaction() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PersistenceUnit(name=" + this.unitName + ") - entityManager.joinTransaction() call ignored - not applicable to a JTA Managed EntityManager", new Exception().fillInStackTrace());
        }
    }

    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PersistenceUnit(name=" + this.unitName + ") - entityManager.close() call ignored - not applicable to a JTA Managed EntityManager", new Exception().fillInStackTrace());
        }
    }

    public boolean isOpen() {
        return true;
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("A JTA EntityManager can not use the EntityTransaction API.  See JPA 1.0 section 5.5");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Op {
        clear,
        close,
        contains,
        createNamedQuery,
        createNativeQuery,
        createQuery,
        find,
        flush,
        getFlushMode,
        getReference,
        getTransaction,
        lock,
        merge,
        refresh,
        remove,
        setFlushMode,
        persist;


        public Timer start(JtaEntityManager em) {
            return new Timer(this, em);
        }
    }

    public static class Timer {
        private final long start = System.nanoTime();
        private final Op operation;
        private final JtaEntityManager em;

        public Timer(Op operation, JtaEntityManager em) {
            this.operation = operation;
            this.em = em;
        }

        public void stop() {
            if (!this.em.logger.isDebugEnabled()) {
                return;
            }
            long time = TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            this.em.logger.debug("PersistenceUnit(name=" + this.em.unitName + ") - entityManager." + (Object)((Object)this.operation) + " - " + time + "ms");
        }
    }
}

